




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


#include <windows.h>
#include <commdlg.h>

#if defined(_MSC_VER)
#include <memory.h>
#else
#include <mem.h>
#endif


#include "base/bytstrng.h"

#include "ui/stddlg.h"
#include "ui/applic.h"
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/font.h"


UI_ViewID UI_StandardDialog (const char* message,
                             const char* box_title,
                             UI_CompositeVObject* parent,
                             UI_StandardDialogStyle style,
                             UI_StandardDialogIconStyle icon)
{
    long s;
    switch (style) {
    case UIS_Ok:
        s = MB_OK;
        break;
        
    case UIS_OkCancel:
        s = MB_OKCANCEL;
        break;
        
    case UIS_YesNo:
        s = MB_YESNO;
        break;
        
    case UIS_YesNoCancel:
        s = MB_YESNOCANCEL;
        break;

    default:
        s = MB_OKCANCEL;
        break;
    }

    switch (icon) {
    case UIS_Information:
        s |= MB_ICONINFORMATION;
        break;
        
    case UIS_Error:
        s |= MB_ICONSTOP;
        break;
        
    case UIS_Question:
        s |= MB_ICONQUESTION;
        break;
        
    case UIS_Warning:
        s |= MB_ICONEXCLAMATION;
        break;

    }
    UI_ViewHandle h = parent ? parent->ViewHandle() : NULL;
    short ret_val = MessageBox (h, message, box_title,
                                s | (h ? MB_APPLMODAL : MB_TASKMODAL));
    switch (ret_val) {
    case IDYES:
        ret_val = UI_IDYES;
        break;

    case IDNO:
        ret_val = UI_IDNO;
        break;

    default:
        break;
    }
    return ret_val;
}







static char file_name[256]; // Windows doesn't like this object to be
                            // on the stack!

CL_String UI_FileSelectDialog (UI_VisualObject* parent,
                               const char* initialDir,
                               const char* box_title,
                               const char* typeMask)
{
    OPENFILENAME ofnTemp;
    long ErrVal;	// Error value
    char temp[256];
    long n = typeMask ? lstrlen (typeMask) : 0;
    if (n > 0 && n < sizeof temp) {
        temp[0] = ' ';
        temp[1] = '\0';
        lstrcpy (temp+2, typeMask);
        temp[n+2] = temp[n+3] = '\0';
    }
        
    if (!parent)
        return "";
    UI_ViewHandle hWnd = parent->ViewHandle ();

    memset (file_name, 0, sizeof file_name);
    ofnTemp.lStructSize = sizeof (OPENFILENAME);
    ofnTemp.hwndOwner = hWnd;	// An invalid hWnd causes non-modality
    ofnTemp.hInstance = 0;
    ofnTemp.lpstrFilter = (LPSTR) (n > 0 ? temp : 0);  
    ofnTemp.lpstrCustomFilter = NULL;
    ofnTemp.nMaxCustFilter = 0;
    ofnTemp.nFilterIndex = 1;
    ofnTemp.lpstrFile = (LPSTR)file_name; // Stores the result in this variable
    ofnTemp.nMaxFile = sizeof (file_name);
    ofnTemp.lpstrFileTitle = NULL;
    ofnTemp.nMaxFileTitle = 0;
    ofnTemp.lpstrInitialDir = initialDir;
    ofnTemp.lpstrTitle = box_title;	// Title for dialog
    ofnTemp.Flags = OFN_HIDEREADONLY;
    ofnTemp.nFileOffset = 0;
    ofnTemp.nFileExtension = 0;
    ofnTemp.lpstrDefExt = 0;
    ofnTemp.lCustData = NULL;
    ofnTemp.lpfnHook = NULL;
    ofnTemp.lpTemplateName = NULL;
    /*
    If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
    to retrieve the type of error that occured.
    */
    bool result = (n > 0) ?  GetOpenFileName (&ofnTemp) 
        : GetSaveFileName (&ofnTemp);
    if (!result) {
        ErrVal=CommDlgExtendedError();
        if (ErrVal) {	// 0 value means user selected Cancel
            UI_StandardDialog ("FileSelectDialog failed: "
                               "Error code: " + CL_String (ErrVal));
        }
        else
            file_name[0] = '\0';

    }
    InvalidateRect (hWnd, NULL, TRUE) ;	// Repaint to display the new name
    return file_name;
}



bool UI_FontDialog (UI_CompositeVObject* parent, UI_FontDesc& desc)
{
    CHOOSEFONT fontDlg;
    LOGFONT    font;
    fontDlg.lStructSize    = sizeof (CHOOSEFONT);
    fontDlg.hwndOwner      = parent->ViewHandle();
    fontDlg.Flags          = CF_SCREENFONTS;
    fontDlg.nFontType      = SCREEN_FONTTYPE;
    fontDlg.lpLogFont      = &font;
    fontDlg.nSizeMin       = 20;
    fontDlg.nSizeMax       = 20;
    fontDlg.hInstance      = YACLApp()->ProcessId();

    bool d = ChooseFont (&fontDlg);
    if (d) {
        const PTS_PER_INCH = 72.24;
        HDC dc = GetDC (NULL);
        long pixelsPerInch  = GetDeviceCaps (dc, LOGPIXELSY);
        ReleaseDC (NULL, dc);
        ulong style = 0;
        if (font.lfItalic)
            style |= UIFont_Italic;
        if (font.lfUnderline)
            style |= UIFont_Underline;
        if (font.lfStrikeOut)
            style |= UIFont_StrikeOut;
        if (font.lfWeight)
            style |= UIFont_BoldFace;
        desc = UI_FontDesc (font.lfFaceName,
                            font.lfHeight * PTS_PER_INCH / pixelsPerInch,
                            style);
        return TRUE;
    }
    return FALSE;
}


