



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif

// Support for event handling under OS/2
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/timer.h"
#include "ui/menu.h"
#include "ui/stred.h"

#include <string.h>

static struct {
    ulong         message;
    UI_EventType  yaclEvent;
} TransTable [] = {
    WM_BUTTON1DOWN,         Event_LButtonPress,
    WM_BUTTON2DOWN,         Event_MButtonPress,
    WM_BUTTON3DOWN,         Event_RButtonPress,
    WM_BUTTON1UP,           Event_LButtonRelease,
    WM_BUTTON2UP,           Event_MButtonRelease,
    WM_BUTTON3UP,           Event_RButtonRelease,
    WM_BUTTON1DBLCLK,       Event_LButtonDblClk,
    WM_BUTTON2DBLCLK,       Event_MButtonDblClk,
    WM_BUTTON3DBLCLK,       Event_RButtonDblClk,
    WM_CHAR,                Event_KeyTyped,
    WM_CLOSE,               Event_CloseDown,
    WM_DESTROY,             Event_Quit,
    WM_MENUEND,             Event_LoseFocus,
    WM_MENUSELECT,          Event_GetFocus,
    WM_MOVE,                Event_Reconfigure,
    WM_MOUSEMOVE,           Event_MouseMove,
    WM_PAINT,               Event_Paint,
    WM_SETFOCUS,            Event_GetFocus,
    WM_SIZE,                Event_Reconfigure,
    0,                      Event_Other
};



bool UI_Controller::_DoOneEvent (NativeEventStruct& qMsg)
{
    UI_Event e (Event_None, NULL);
    if (TranslateNativeEvent (qMsg, e) &&
        e._origin->WindowClass() != NULL &&
        // The window class is null for menu items. The menu item events
        // are dispatched from the WindowProc.
        e._origin->WindowClass() != _YACLWindowClassName &&
        // ---------------------^^^^ ------------------
        // Note that we compare pointers, not strings. We cannot
        // compare strings, because OS/2's built-in window classes
        // return invalid pointers as window classes. This check is
        // needed because events targeted at a YACLWindow are dispatched
        // from YACLWindowProc.
        e._origin->WindowClass() != _YACLSimpleClassName &&
        (e._type != Event_KeyTyped || e.key != '\011') &&
        // Another hack, to prevent tabs from being dispatched. They
        // should be dispatched from the WindowProcs.
        (!_eventFilter || _eventFilter->Execute (e)))
        DispatchNativeEvent (e);
    if (_termination && _termination->Execute (e))
        return FALSE;
    DispatchSoftEvents ();
    return TRUE;
}


bool UI_Controller::ProcessNativeEvents ()
{
    NativeEventStruct qMsg;
    while (_root && WinGetMsg (_hab, &qMsg, NULLHANDLE, 0, 0)) {
        WinDispatchMsg (_hab, &qMsg);
        if (!_DoOneEvent (qMsg))
            return FALSE;
//         if (_deIconifyPending == qMsg.hwnd) {
//             // We need to delay dispatching the de-iconify event until
//             // after the window is visible. Otherwise, if the event
//             // handler puts up a window, the application subsequently
//             // hangs under OS/2. THIS DOESN'T WORK!
//             UI_VisualObject* view = (*this)[qMsg.hwnd];
//             if (view) {
//                 UI_Event evt (Event_Deiconify, view, view);
//                 DispatchNativeEvent (evt);
//             }
//             _deIconifyPending = 0;
//         }
    }
    return TRUE;
}

void UI_Controller::FlushEventQueue ()
{
    NativeEventStruct qMsg;
    while (_root && WinPeekMsg (_hab, &qMsg, NULLHANDLE, 0, 0, PM_REMOVE));
}



void UI_Controller::DispatchPendingEvents ()
{
    DispatchSoftEvents ();
    NativeEventStruct qMsg;
    while (_root && WinPeekMsg (_hab, &qMsg, NULLHANDLE, 0, 0, PM_REMOVE)) {
        WinDispatchMsg (_hab, &qMsg);
        if (!_DoOneEvent (qMsg))
            break;
    }
}



bool UI_Controller::DispatchNativeEvent ( UI_Event& e )
{
    if (!_root)
        return TRUE;
    switch (e.Type()) {
    case Event_MouseMove:
        if ( _current != e.Destination () ) {
            // The mouse entered a different visual obj
            if ( _current ) {
                UI_Event leave (Event_ViewLeave, _current);
                DispatchEvent (&leave);
            }
            _current = e.Destination ();
            UI_Event enter (Event_ViewEnter, e.Destination ());
            DispatchEvent (&enter);
        }
        break;

    default:
        break;
    }
    return DispatchEvent (&e);
}



bool UI_Controller::TranslateNativeEvent (NativeEventStruct& msg, UI_Event& e)
{
    e._nativeEvent = new NativeEventStruct;
    *(NativeEventStruct*)(e._nativeEvent) = msg;
    e._shiftKey = WinGetKeyState (HWND_DESKTOP, VK_SHIFT) < 0 ? TRUE : FALSE;
    e._ctrlKey  = WinGetKeyState (HWND_DESKTOP, VK_CTRL ) < 0 ? TRUE : FALSE;
    e._metaKey  = WinGetKeyState (HWND_DESKTOP, VK_ALT  ) < 0 ? TRUE : FALSE;

    short i;
    for (i = 0; TransTable[i].message != 0; i++) {
        if ( TransTable [i].message == msg.msg ) {
            break;
        }
    }
    e._type  = TransTable [i].yaclEvent;
    UI_VisualObject* view = (UI_VisualObject*) _visualObjMap[msg.hwnd];
    switch (msg.msg) {
    case WM_PAINT:{
        RECTL rect;
        if (view) {
            if (WinQueryUpdateRect (view->_handle, &rect)) {
                long x = rect.xLeft;
                long y = view->_shape.Height() - rect.yTop - 1;
                long w = rect.xRight - rect.xLeft + 1;
                long h = rect.yTop   - rect.yBottom + 1;
                e.curPos = UI_Rectangle (x, y, w, h);
            }
            else
                e.curPos = UI_Rectangle (0, 0, view->_shape.Width(),
                                         view->_shape.Height());
        }
        break;
    }
        
    case WM_MENUEND: {
        UI_VisualObject* v = (UI_VisualObject*)
            _visualObjMap [(ulong) msg.mp2];
        if (!v)
            break;
        UI_Menu* menu = NULL;
        if (v->WindowClass() == WC_MENU)
            menu = (UI_Menu*) v;
        else {
            UI_MenuItem* itm = (UI_MenuItem*) v;
            menu = &(itm->Container());
        }
        if (menu) {
            UI_MenuItem* focusItem = menu->Focus();
            if (focusItem) {
                UI_Event evt (Event_LoseFocus, focusItem, focusItem);
                DispatchEvent (&evt);
            }
            menu->MoveFocusTo (NULL);
        }
        view = NULL;
        break;
    }
        
    case WM_MENUSELECT: {
        UI_VObjCollection* parent = (UI_VObjCollection*)
            _visualObjMap[msg.hwnd];
        UI_ViewID id = SHORT1FROMMP (msg.mp1);
        UI_MenuItem* itm = parent && id >= 1 && id < 32700 ?
            (UI_MenuItem*)(*parent)[id] : (UI_MenuItem*) NULL;
        // OS/2 is very picky about view id's. The above check for id range
        // between 1 and 32700 is so that rogue MENUSELECT messages do not
        // cause problems.
        if (itm) {
            UI_Menu& menu = itm->Container();
            UI_MenuItem* focusItem = menu.Focus();
            if (focusItem) {
                UI_Event evt (Event_LoseFocus, focusItem, focusItem);
                DispatchEvent (&evt);
            }
            menu.MoveFocusTo (itm);
        }
        view = itm;
        break;
    }
        
    case WM_CHAR:
        e.key = SHORT1FROMMP(msg.mp2);
        // PM gives me two WM_CHAR messages (See p. 452 of Petzold's book),
        // so I ignore one of them:
        if (((ulong) msg.mp1) & KC_KEYUP || e.key == 0)
            e._type = Event_Other;
        break;
        
    case WM_BUTTON1DBLCLK:
    case WM_BUTTON2DBLCLK:
    case WM_BUTTON3DBLCLK:
    case WM_BUTTON1DOWN:
    case WM_BUTTON2DOWN:
    case WM_BUTTON3DOWN:
    case WM_BUTTON1UP:
    case WM_BUTTON2UP:
    case WM_BUTTON3UP: {
        POINTL point = msg.ptl;
        WinMapWindowPoints (HWND_DESKTOP, msg.hwnd, &point, 1);
        RECTL rect;
        WinQueryWindowRect (msg.hwnd, &rect);
        e.curPos.Origin (UI_Point (point.x,
                                   rect.yTop - rect.yBottom + 1 - point.y));
        break;
    }

    case WM_SETFOCUS:
        e._type = SHORT1FROMMP (msg.mp2) ? Event_GetFocus: Event_LoseFocus;
        break;

    case WM_TIMER: {
        ulong id = SHORT1FROMMP (msg.mp1);
        UI_Timer::DoAlarm (id);
        break;
    }
        
    case WM_COMMAND: {
        UI_ViewID id = SHORT1FROMMP(msg.mp1);
        e._type = Event_Select;
        UI_VObjCollection* parent = (UI_VObjCollection*)
            _visualObjMap[msg.hwnd];
        view = parent ? (*parent)[id] : (UI_VisualObject*) NULL;
        break;
    }

    case WM_CONTROL: {
        UI_ViewID id = SHORT1FROMMP(msg.mp1);
        e._type = Event_Select;
        HWND h = WinWindowFromID (msg.hwnd, id);
        view = (UI_VObjCollection*) _visualObjMap[h];
        ushort code = SHORT2FROMMP(msg.mp1);
        //  if (code == CBN_EFCHANGE || CBN_LBSELECT)
        //      e._type = Event_Select;
        //  else
        //      e._type = (code == BN_CLICKED) ? Event_Select
        //          : Event_LButtonDblClk;
        // The CBN_ messages seem to come before the WM_COMMAND (or is it
        // WM_CONTROL), in fact, even before the selection actually changes.
        // So we can't ask the listbox what its selection is, because it
        // hasn't changed yet.
        if (code == EN_CHANGE) {
            UI_WindowClass cls = view->WindowClass();
            if (cls == WC_ENTRYFIELD || cls == WC_MLE) {
                // This is a message from a StringEditor
                UI_StringEditor* edit = (UI_StringEditor*) view;
                edit->Update();
            }
            break;
        }
        e._type = (code == BN_CLICKED) ? Event_Select
            : Event_LButtonDblClk;
        break;
    }
        
    case WM_MOUSEMOVE: {
        short x = SHORT1FROMMP (msg.mp1);
        short y = SHORT2FROMMP (msg.mp1);
        if (view)
            y = view->_shape.Height() - y; // Adjust for the fact that
                                           // OS/2's origin reckoning is
                                           // bottom left, not top left
        e.curPos = UI_Rectangle (x, y, 0, 0);
        e._type = Event_MouseMove;
        break;
    }

    case WM_MOVE: {
        if (!view)
            break;
        SWP swp;
        UI_ViewHandle vHandle = msg.hwnd;
        WinQueryWindowPos (vHandle, &swp);
        UI_ViewID vID = WinQueryWindowUShort (vHandle, QWS_ID);
        if (vID == FID_CLIENT) // It's part of a framed window
            vHandle = WinQueryWindow (vHandle, QW_PARENT); // Get the frame
        POINTL newOrigin;
        newOrigin.x = newOrigin.y = 0;
        HWND parentHandle  = WinQueryWindow (vHandle, QW_PARENT);
        WinMapWindowPoints (vHandle, parentHandle, &newOrigin, 1);
        e.curPos =  UI_Rectangle
            (newOrigin.x,
             _YACLWindowHeight (parentHandle) - newOrigin.y - swp.cy,
             swp.cx, swp.cy);
        e._type = Event_Reconfigure;
        // DEBUG CODE:
//         CL_Error::Warning ("WM_MOVE view '%s' to %s\n", view->ClassName(),
//                            e.curPos.AsString().AsPtr());
        break;
    }
        
    case WM_SIZE: {
        RECTL rect;
        WinQueryWindowRect (msg.hwnd, &rect);
        if (view) {
            UI_Rectangle shape = view->Shape();
            e.curPos =  UI_Rectangle (shape.Left(), shape.Top(),
                                      rect.xRight, rect.yTop);
        }
        e._type = Event_Reconfigure;
        // DEBUG CODE:
//         CL_Error::Warning ("WM_SIZE view '%s' to %s\n",
//                            view ? view->ClassName() : "",
//                            e.curPos.AsString().AsPtr());
        break;
    }

    case WM_MINMAXFRAME: {
        PSWP pSwp = (PSWP) msg.mp1;
        e._type = Event_Other;
        // Use Event_Other, because a WM_SIZE is sent which takes care
        // of the reconfigure event.
        if (view && pSwp) {
            if (pSwp->fl & SWP_MINIMIZE)
                e._type = Event_Iconify;
            else if (pSwp->fl & SWP_RESTORE) {
                _deIconifyPending = msg.hwnd;
                e._type = Event_Deiconify;
            }
        }
        break;
    }
        
    case WM_VSCROLL:
    case WM_HSCROLL: {
        HWND parent = WinWindowFromID (msg.hwnd, SHORT1FROMMP(msg.mp1));
        view = (UI_VisualObject*) _visualObjMap [parent];
        e.param = SHORT1FROMMP(msg.mp2);
        switch (SHORT2FROMMP (msg.mp2)) {
        case SB_LINEDOWN:
            e._type = Event_ScrollForwardLine;
            break;

        case SB_PAGEDOWN:
            e._type = Event_ScrollForwardPage;
            break;

        case SB_LINEUP:
            e._type = Event_ScrollBackwardLine;
            break;

        case SB_PAGEUP:
            e._type = Event_ScrollBackwardPage;
            break;

        case SB_ENDSCROLL:
            e._type = Event_FinishScroll;
            break;

        case SB_SLIDERPOSITION:
            e._type = Event_ScrollToPosition;
            break;

        case SB_SLIDERTRACK:
            e._type = Event_Scroll;
            break;
        }
        break;
    }
        
    default:
        e.curPos.Origin (UI_Point (msg.ptl.x, msg.ptl.y));
        break;
    }
    e._origin = e._dest = view;
//     {
//         UI_VisualObject* v = view;
//         if (msg.msg != WM_MOUSEMOVE)
//             CL_Error::Warning ("msg %d for id %d obj '%s'\n", msg.msg,
//                                v ? v->ViewID() : -1000, v ? v->ClassName() :
//                                "Unknown");
//     }
    return view != NULL;
}


void UI_Controller::_MakeOS2Interface (const UI_Event& e)
{
    UI_VisualObject* origin = e.Origin ();
    if (origin->MakeVisualElement ())
        Register (origin);
    origin->_PrivateInitialize ();
    origin->Initialize ();
    if (origin->WindowClass() == _YACLWindowClassName &&
        origin->ViewHandle () > 0) {
        // Force an initial paint event to be sent
        UI_ViewHandle h = origin->ViewHandle();
        RECTL rect;
        WinQueryWindowRect (h, &rect);
        WinInvalidateRect  (h, &rect, TRUE);
    }
}

// 
// static short _PendingEvents (UI_EventType t, UI_VisualObject* w)
// {
//     short count = 0;
//     UI_Controller& ctrlr = YACLApp()->Controller();
//     for (long i = ctrlr._eventQueue.Size() - 1; i >= 0; i--) {
//         UI_Event* e = (UI_Event*) ctrlr._eventQueue(i);
//         if (e->Type() == t && e->Origin()->Parent() == v &&
//             e->Origin()->WindowClass() != NULL) {
//             // Don't count menu items with null window class
//             count++;
//             CL_Error::Warning ("cls %s id %d EventsPending %d\n",
//                                e->Origin()->ClassName(),
//                                e->Origin()->ViewID(), count);//DEBUG
//         }
//     }
//     return count;
// }


MRESULT EXPENTRY YACLWindowProc (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    MRESULT result = 0;
    UI_Controller& ctrlr = YACLApp()->Controller();
    switch (msg) {
    case WM_ERASEBACKGROUND: {
//         HPS hps = (HPS) p1;
//         RECTL* rect = (RECTL*) p2;
//         UI_VisualObject* v = ctrlr[hWnd];
//         long color = v ? v->Background().NativeForm() : SYSCLR_WINDOW;
//         WinFillRect     (hps, rect, color);
//         result = (MRESULT) FALSE; 
        // Return TRUE to cause PM to paint the window background
        // in SYSCLR_WINDOW
        result = (MRESULT) TRUE;
        break;
    }

    case WM_CLOSE:
        break;

        
    case WM_MOUSEMOVE: {
        if (ctrlr._inWaitState)
            ctrlr.SetCurrentCursor (ctrlr._defaultCursor);
        else {
            UI_VisualObject* v = ctrlr[hWnd];
            if (v) {
                UI_Cursor& cursor = v->Cursor();
                if (cursor != UICursor_Default) {
                    ctrlr.SetCurrentCursor (v->Cursor());
                    break;
                }
            }
        }
        result = WinDefWindowProc (hWnd, msg, p1, p2);
        break;
    }

        
    case WM_PAINT:
        // Don't do anything: the processing is done by VisualObject's Paint
        // method.
        break;

    default:
        result = WinDefWindowProc (hWnd, msg, p1, p2);
        break;
    }
    QMSG qMsg;
    WinQueryPointerPos (HWND_DESKTOP, &qMsg.ptl);
    qMsg.hwnd = hWnd;
    qMsg.msg  = msg;
    qMsg.mp1  = p1;
    qMsg.mp2  = p2;
    qMsg.time = 0;
    UI_Event e (Event_None, 0);
        // WM_COMMAND events arrive both in this WindowProc and in
        // ProcessNativeEvent. Those from menu items are dispatched from
        // here, and the rest are dispatched from ProcessNativeEvent.
    if (ctrlr.TranslateNativeEvent (qMsg, e)) {
        bool disp = (qMsg.msg == WM_COMMAND) ?
            (SHORT1FROMMP(p2) == CMDSRC_MENU) : FALSE;
        // disp is now TRUE if it's a menu selection event
        if (!disp) {
//             if (qMsg.msg == WM_PAINT) {
//                 UI_VObjCollection* w = (UI_VObjCollection*) e.Origin();
//                 disp = !(w->CompressPaintEvents()) ||
//                     ctrlr.EventsPending (Event_MakeInterface, w) <= 1;
//             }
//             else
            disp = qMsg.msg != WM_COMMAND && qMsg.msg != WM_VSCROLL &&
                qMsg.msg != WM_HSCROLL;
        }
        
        // disp is now TRUE if it's either a menu selection event or a paint
        // event that must be dispatched
//         if ((qMsg.msg == WM_COMMAND && SHORT1FROMMP(p2) == CMDSRC_MENU)
//             || (qMsg.msg != WM_COMMAND && qMsg.msg != WM_VSCROLL &&
//                 qMsg.msg != WM_HSCROLL &&
        if (disp &&
            (!ctrlr._eventFilter || ctrlr._eventFilter->Execute (e)))
            ctrlr.DispatchNativeEvent (e);
    }
    if (qMsg.msg == WM_PAINT)
        WinValidateRect (hWnd, NULL, FALSE); // Assume that the Paint method
                                             // did its job. Without this
                                             // call I'll be flooded with
                                             // WM_PAINT messages
    return result;
}



MRESULT EXPENTRY YACLBmpBtnProc (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    // Here's a bit of OS/2 weirdness: the default processing for WM_CHAR
    // involves sending the message to the parent! the result is that the
    // parent dispatches the event, and then this BmpBtnProc does, so we
    // have duplicate notification. So I call WinDefWindowProc only if
    // it's not a WM_CHAR message:
    MRESULT result =  (msg == WM_CHAR) ? (MRESULT) TRUE
        : WinDefWindowProc (hWnd, msg, p1, p2);
    UI_Controller& ctrlr = YACLApp()->Controller();
    QMSG qMsg;
    WinQueryPointerPos (HWND_DESKTOP, &qMsg.ptl);
    qMsg.hwnd = hWnd;
    qMsg.msg  = msg;
    qMsg.mp1  = p1;
    qMsg.mp2  = p2;
    qMsg.time = 0;
    UI_Event e (Event_None, 0);
    if (ctrlr.TranslateNativeEvent (qMsg, e)) {
        if (!ctrlr._eventFilter || ctrlr._eventFilter->Execute (e))
            ctrlr.DispatchNativeEvent (e);
    }
    return result;
}



void UI_Controller::_AbortPMApp (const char* msg)
{
    PERRINFO  pErrInfoBlk;
    PSZ       pszOffSet;
    void      stdprint(void);
    PSZ  pszErrMsg;

    DosBeep (100, 10);
    DosBeep (440, 110);
    if ((pErrInfoBlk = WinGetErrorInfo (_hab)) != NULL) {
        pszOffSet = ((PSZ) pErrInfoBlk) + pErrInfoBlk->offaoffszMsg;
        pszErrMsg = ((PSZ )pErrInfoBlk) + *((PSHORT)pszOffSet);
        CL_String sMsg = CL_String("YACL: ") + msg + CL_String (" failed:\n")
            + pszErrMsg;
        WinMessageBox
            (HWND_DESKTOP, HWND_DESKTOP,  sMsg.AsPtr(), "YACL FATAL", 0,
             MB_MOVEABLE | MB_CUACRITICAL | MB_CANCEL );
        WinFreeErrorInfo (pErrInfoBlk);
    }
}

short UI_Controller::Initialize ()
{
    if ((_hab = WinInitialize (0)) == NULLHANDLE)
        _AbortPMApp ("WinInitialize");
    if ((_hmq = WinCreateMsgQueue (_hab, 0)) == NULLHANDLE) {
        _AbortPMApp ("WinCreateMsgQueue");
        WinTerminate (_hab);
        return FALSE;
    }
    if (!WinRegisterClass (_hab, _YACLWindowClassName, YACLWindowProc,
                           CS_SYNCPAINT | CS_MOVENOTIFY | CS_SIZEREDRAW, 0)) {
        _AbortPMApp ("WinRegisterClass");
        WinDestroyMsgQueue (_hmq);
        WinTerminate (_hab);
        return FALSE;
    }
    if (!WinRegisterClass (_hab, _YACLSimpleClassName, YACLBmpBtnProc,
                           CS_SYNCPAINT | CS_MOVENOTIFY | CS_SIZEREDRAW, 0)) {
        _AbortPMApp ("WinRegisterClass Simple");
        WinDestroyMsgQueue (_hmq);
        WinTerminate (_hab);
        return FALSE;
    }
    return TRUE;
}

