

#ifndef _strseq_h_
#define _strseq_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma interface
#endif



#include "ui/uidefs.h"     // Include this first.

#include "base/strgseq.h"
#include "base/objset.h"

// A {\tt UI_StringSequence} is   used as a model for StringViews and
// ComboBoxes. It is derived from {\tt CL_StringSequence}; the behavior it
// adds to its parent class is to make itself dependent on all the
// contained Strings. {\tt
// UI_StringSequence} maintains a set of clients that are either StringViews or
// ComboBoxes. It assumes that the client's protocol includes a method {\tt
// ItemChanged (long i)}. When one of its contained strings changes, it
// notifies its clients by calling their {\tt ItemChanged} methods. This
// is in addition to the usual dependent notification that {\tt
// CL_StringSequence} executes when structural changes occur in it.
//
// The {\tt UI_StringSequence} also includes methods {\tt AddClient} and
// {\tt RemoveClient} for manipulating the client set.
//
// The implementation of {\tt UI_StringSequence} sets itself up as a
// dependent on each contained String, such that the notification code from
// the String is the index of the String in the Sequence. The implementation
// also sets up {\tt UI_StringSequence} as a dependent on itself, so that
// when a structural change in the Sequence
// takes place, the {\tt _ReassignCodes} method is called.

class YACL_UI UI_StringView;

class YACL_UI UI_StringSequence: public CL_StringSequence {

public:
    UI_StringSequence ();
    // Constructor.
    
    UI_StringSequence (const char* data[], long count = -1);
    // Create this Sequence from a C-style array of character  pointers. The
    // resulting Sequence has {\tt count} cells initialized to the values in
    // {\tt data}, which is assumed to contain {\tt count} strings. If {\tt
    // count} is $-1$, then the last cell of the {\tt data} array is assumed to
    // contain  a NULL pointer. This allows initialization in the following
    // style:
    // 
    // \begin{verbatim}
    //        const char* data[] = {"One", "Two", "Three", 0};
    //        UI_StringSequence seq (data);
    // \end{verbatim}
    //
    // \noindent
    // So you don't have to count the number of strings in the initializing
    // array.
    
    void AddClient    (UI_StringView* client);
    // Add a client to this {\tt UI_StringSequence}. The client's {\tt
    // ItemChanged} method will be called whenever one of the contained
    // strings changes.

    void RemoveClient (UI_StringView* client);
    // Remove {\tt client} from the client set.

    
protected:

    bool _ReassignCodes ();
    // Called when there is a structural change in the underlying
    // StringSequence. The implementation reassigns notification codes to
    // all the contained Strings.
    
    bool Update (CL_String&, long);
    // Called when one of the contained Strings changes. The second
    // parameter is the index of the String in the Sequence.

    CL_ObjectSet      _clientSet;
};

#endif

