




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include <iostream.h> // DEBUG
#include "ui/stred.h"
#include "ui/cntroler.h"
#include "ui/composit.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#    define DEFAULT_STYLE \
     ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | WS_GROUP
#elif defined(__OS2__)
#    define DEFAULT_STYLE WS_VISIBLE | ES_MARGIN
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/Text.h>
#    define MARGIN_SIZE 2    // Value of XmNmarginHeight and XmNmarginWidth
#elif defined(__X_YACL__)
#    include "ui/shadorec.h"
#    include "ui/dsinmem.h"
#    include "ui/dsplsurf.h"
#    include "ui/support/x_yacl/window.h"
#endif


typedef CL_Binding0<UI_StringEditor> StrEdBind;
#if defined(__GNUC__)
template class CL_Binding0<UI_StringEditor>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_StringEditor>;
#endif

#if defined(__OS2__) && defined(__IBMCPP__)
inline MRESULT EXPENTRY CallBackStrEditProc( HWND hWnd, ULONG msg,
                                             MPARAM p1, MPARAM p2)
{
    return UI_StringEditor::StrEditProc( hWnd, msg, p1, p2);
}
#endif


UI_StringEditor::UI_StringEditor
    (UI_VisualObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_SimpleVObject (parent, shape, id)
{
    _model = new CL_String; 
    _limit = -1;
    StrEdBind bind (this, &UI_StringEditor::_SelectionChanged);
    _selection.AddDependent (bind);
    _insertPos.AddDependent (StrEdBind
                             (this, &UI_StringEditor::_InsertPosChanged));
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style =  DEFAULT_STYLE;
#elif defined(__OS2__)
    _style = DEFAULT_STYLE;
#elif defined(__X_MOTIF__)
    _callbackActive = FALSE;
    _text = NULL;
#endif
}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_StringEditor::UI_StringEditor (UI_CompositeVObject* parent,
                                  UI_ViewID id, UI_ViewHandle h)
: UI_SimpleVObject (parent, id, h)
{
    _model = new CL_String;
    _limit = -1;
    StrEdBind bind (this, &UI_StringEditor::_SelectionChanged);
    _insertPos.AddDependent (StrEdBind
                             (this, &UI_StringEditor::_InsertPosChanged));
    _selection.AddDependent (bind);
}
#endif


UI_StringEditor::UI_StringEditor
    (UI_VisualObject* parent, CL_String* model,
     const UI_Rectangle& shape, UI_ViewID id)
: UI_SimpleVObject(parent, model, id, shape)
{
    _limit = -1;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = DEFAULT_STYLE;
#elif defined(__OS2__)
    _style = DEFAULT_STYLE;
#elif defined(__X_MOTIF__)
    _callbackActive = FALSE;
    _text = NULL;
#endif
    StrEdBind bind (this, (StrEdBind::MethodPtr)
                    &UI_StringEditor::_SelectionChanged);
    _selection.AddDependent (bind);
    _insertPos.AddDependent (StrEdBind
                             (this, &UI_StringEditor::_InsertPosChanged));
}



#if defined(__X_MOTIF__)
void UI_StringEditor::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (p, argn);
    XtSetArg (arg[argn], XmNeditMode, XmSINGLE_LINE_EDIT); argn++;
}

bool UI_StringEditor::MakeVisualElement ()
{
    // For the StringEditor _text and _xwidget are the same
    // TextEditor uses both variables.
    bool retc = UI_SimpleVObject::MakeVisualElement();
    _text = _xwidget;
    return retc;
}


void UI_StringEditor::ModifyCallback (Widget , void* client,
                                      void* call)
{
    UI_StringEditor* edit = (UI_StringEditor *) client;
    edit->_callbackActive = TRUE;
    XmAnyCallbackStruct* cbAny = (XmAnyCallbackStruct*) call;
    if (cbAny->reason == XmCR_MODIFYING_TEXT_VALUE) {
        XmTextVerifyCallbackStruct* cb = (XmTextVerifyCallbackStruct*) call;
        if (cb->text && cb->text->ptr) {
            // Update the insertion position for the duration of the callback
            StrEdBind b (edit, &UI_StringEditor::_InsertPosChanged);
            edit->_insertPos.RemoveDependent (b);
            edit->_insertPos = cb->currInsert;
            edit->_insertPos.AddDependent (b);

            // Now ask the editor to filter the character
            if (cb->text->ptr[0]) {
                short key = cb->text->ptr[0];
                cb->doit =  edit->FilterChar (key) ? TRUE : FALSE;
                cb->text->ptr[0] = key;
                // If the FilterChar method modified the insertion position,
                // Motif's XmTextSetInsertionPosition function won't have
                // worked -- it doesn't seem to work if the modifyVerify
                // callback is currently active. So we work around it, and
                // set the insertion position explicitly:
                long pos = edit->InsertionPosition();
                cb->currInsert = pos;
                cb->newInsert  = pos;
                cb->startPos   = pos;
                cb->endPos     = pos;
            }
            else if (!edit->PermitDelete ()) {
                // Weird: Motif doesn't let me refuse permission for
                // deletion. If I do, the app hangs. So:
                CL_String& model = (CL_String&) edit->Model();
                if (cb->endPos > cb->startPos) {
                    // There's a selection
                    CL_String s = model (cb->startPos,
                                         cb->endPos - cb->startPos);
                    model.Insert (s, cb->startPos-1);
                }
                else
                    model.Insert (model(cb->startPos), cb->startPos-1);
                // _Controller->Beep(); This should be optional
            }                    
        }
    }
    else if (cbAny->reason == XmCR_VALUE_CHANGED)
        _Controller->AddEvent (new UI_Event (Event_StrEdChanged, edit));
    edit->_callbackActive = FALSE;
}

#endif


void UI_StringEditor::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _Controller->SubclassControl (_handle, (FARPROC) YACLEditProc);
    CL_String& s = *((CL_String*) _model);
    if (s.Size() > 0) {
        SetWindowText (_handle, s.AsPtr());
    }
#elif defined(__OS2__)
    CL_String& s = *((CL_String*) _model);
    if (s.Size() > 0)
        WinSetWindowText (_handle, s.AsPtr());
    _SubclassEditor();
#elif defined(__X_MOTIF__)
    if (_text) {
        CL_String& model = *(CL_String*) _model;
        if (model.Size())
            XmTextSetString (_text, (char*) ((CL_String*) _model)->AsPtr());
        XtAddCallback (_text, XmNmodifyVerifyCallback, 
                       &UI_StringEditor::ModifyCallback, (XtPointer) this);
        XtAddCallback (_text, XmNvalueChangedCallback, 
                       &UI_StringEditor::ModifyCallback, (XtPointer) this);
        // Motif doesn't set StringEditor shape correctly, so:
        XtVaSetValues (_xwidget, XmNwidth, _shape.Width(),
                       XmNheight, _shape.Height(),
                       XmNmarginHeight, MARGIN_SIZE,
                       XmNmarginWidth,  MARGIN_SIZE,
                       NULL);
        if (_visible) {
            // Just call MakeVisible() here instead of XtManageChild()
            MakeVisible();
        }
    }
#endif
    if (_limit != -1)
        SetLengthLimit (_limit);
}



UI_WindowClass UI_StringEditor::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "edit";
#elif defined(__OS2__)
    return WC_ENTRYFIELD;
#elif defined(__X_MOTIF__)
    return  xmTextWidgetClass;
#endif
}



//
// -----------------StringEditor Event methods--------------------
//



CL_Interval& UI_StringEditor::Selection ()
{
    StrEdBind bind (this, (StrEdBind::MethodPtr)
                    &UI_StringEditor::_SelectionChanged);
    _selection.RemoveDependent (bind);
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    DWORD pos;
    pos = SendMessage  (_handle, EM_GETSEL, 0, 0);
    long lo = ((long) LOWORD(pos)), hi = ((long) HIWORD(pos))-1;
    _selection = CL_Interval (lo, hi);
#elif defined(__OS2__)
    MPARAM pos = WinSendMsg  (_handle, EM_QUERYSEL, 0, 0);
    long lo = ((long) SHORT1FROMMP(pos)), hi = ((long) SHORT2FROMMP(pos))-1;
    _selection = CL_Interval (lo, hi);
#elif defined(__X_MOTIF__)
    XmTextPosition left, right;
    XmTextGetSelectionPosition(_text, &left, &right);
    _selection = CL_Interval ((long) left, (long) right-1);
#endif
    _selection.AddDependent (bind);
    return _selection;
}


CL_Object& UI_StringEditor::Model ()
{
    if (!ViewHandle()) {
        _SetModelValue (CL_String (""));
        return *_model;
    }
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    long n = GetWindowTextLength (_handle);
    char* buf = new char[n+1];
    if (!buf)
        return *_model; // No memory
    GetWindowText (_handle, buf, n+1);
    _SetModelValue (CL_String (buf));
    delete [] buf;

#elif defined(__OS2__)
    long n = WinQueryWindowTextLength (_handle);
    char* buf = new char[n+1];
    if (!buf)
        return *_model; // No memory
    WinQueryWindowText (_handle,  n+1, buf);
    _SetModelValue (CL_String (buf));
    delete [] buf;
#elif defined(__X_MOTIF__)
    char* p =  XmTextGetString (_text);
    _SetModelValue (CL_String (p));
    XtFree (p);
#endif
    return *_model;
}


bool UI_StringEditor::SetLengthLimit (long n)
{
    if (n <= 0)
        return FALSE;
//     if (n == _limit)
//         return TRUE;
    _limit = n;
    if (!ViewHandle())
        return TRUE; // Will be set later
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (n > 0 && n <= 32767) {
        return SendMessage  (_handle, EM_LIMITTEXT, n, 0);
    }
    return FALSE;
#elif defined (__OS2__)
    if (n > 0 && n <= 32767) {
        WinSendMsg  (_handle, EM_SETTEXTLIMIT, MPFROM2SHORT(n, 0), 0);
        return TRUE;
    }
    return FALSE;
#elif defined (__X_MOTIF__)
    if (n > 0) {
        Arg arg[1];
        XtSetArg (arg[0], XmNmaxLength, n);
        XtSetValues (_text, arg, 1);
    }
    return TRUE;
#elif defined(__X_YACL__)
    return TRUE;
#endif
}


bool UI_StringEditor::_ModelChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    CL_String& s = *((CL_String*) _model);
    if (_handle > 0)
        SetWindowText (_handle, s.AsPtr());
#elif defined(__OS2__)
    CL_String& s = *((CL_String*) _model);
    if (_handle)
        WinSetWindowText (_handle, s.AsPtr());
#elif defined(__X_MOTIF__)
    if (_text) {
        XtRemoveCallback (_text, XmNmodifyVerifyCallback, 
                          &UI_StringEditor::ModifyCallback, (XtPointer) this);
        XtRemoveCallback (_text, XmNvalueChangedCallback, 
                          &UI_StringEditor::ModifyCallback, (XtPointer) this);
        XmTextSetString (_text, (char*) ((CL_String*) _model)->AsPtr());
        XtAddCallback (_text, XmNvalueChangedCallback, 
                       &UI_StringEditor::ModifyCallback, (XtPointer) this);
        XtAddCallback (_text, XmNmodifyVerifyCallback, 
                       &UI_StringEditor::ModifyCallback, (XtPointer) this);
    }
#elif defined(__X_YACL__)
    Invalidate ();
#endif
    return TRUE;
}



bool UI_StringEditor::_SelectionChanged ()
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0) {
        SendMessage (_handle, EM_SETSEL, TRUE,
                     MAKELPARAM (_selection.Low(), _selection.High()+1));
    }
#elif defined(__MS_WIN32__)
    if (_handle > 0) {
        SendMessage (_handle, EM_SETSEL, (LPARAM) _selection.Low(),
                     (LPARAM) _selection.High()+1);
    }
#elif defined(__OS2__)
    if (_handle) {
        WinSendMsg (_handle, EM_SETSEL, MPFROM2SHORT
                    (_selection.Low(), _selection.High()+1), 0);
    }
#elif defined(__X_MOTIF__)
    if (_text)
        XmTextSetSelection (_text, _selection.Low(), _selection.High(), 0);
#endif
    return TRUE;
}

#if defined(__X_MOTIF__)
bool UI_StringEditor::_FontChanged ()
{
    // For UI_StringEditor _xwidget and _text are the same
    // But for UI_Texteditor we want to set the font on
    // the editor rather than the ScrolledWindow

    UI_ViewHandle xwidget = _xwidget;
    _xwidget = _text;
    bool b = UI_SimpleVObject::_FontChanged ();
    _xwidget = xwidget;

    // Motif has the "feature" that when the font of a StringEditor is
    // changed, it mucks with its shape. So:
    if (_xwidget) {
        long x = _shape.Width(), y = _shape.Height();
        XtVaSetValues (_xwidget, XmNwidth, x, XmNheight, y,  NULL);
    }
    return b;
}

#endif


CL_Integer& UI_StringEditor::InsertionPosition ()
{
    long position = 0;
#if defined(__X_MOTIF__)
    if (_text) {
        if (_callbackActive)
            return _insertPos;
        XmTextPosition pos;
        XtVaGetValues (_text, XmNcursorPosition, &pos, NULL);
        position = pos;
    }
#elif defined(__OS2__)
    if (_handle) {
        MPARAM pos = WinSendMsg  (_handle, EM_QUERYSEL, 0, 0);
        position = ((long) SHORT2FROMMP(pos));
    }
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        DWORD result = SendMessage (_handle, EM_GETSEL, 0, 0);
        position = HIWORD (result);
    }
#endif
    StrEdBind b (this, &UI_StringEditor::_InsertPosChanged);
    _insertPos.RemoveDependent (b);
    _insertPos = position;
    _insertPos.AddDependent (b);
    return _insertPos;
}


bool UI_StringEditor::_InsertPosChanged ()
{
#if defined(__X_MOTIF__)
    if (_text) {
        XmTextPosition pos = _insertPos;
        XmTextSetInsertionPosition (_text, pos);
    }
#elif defined(__OS2__)
    if (_handle) {
        short pos = _insertPos.Value();
        WinSendMsg (_handle, EM_SETSEL, MPFROM2SHORT (pos, pos), 0);
    }
#elif defined(__MS_WINDOWS__)
    if (_handle) {
        UINT pos = _insertPos;
        SendMessage (_handle, EM_SETSEL, 0, MAKELPARAM (pos, pos));
    }
#elif defined(__MS_WIN32__)
    if (_handle) {
        UINT pos = _insertPos;
        SendMessage (_handle, EM_SETSEL, (WPARAM) pos, (LPARAM) pos);
    }
#endif
    return TRUE;
}



#if defined(__OS2__)
MRESULT 
#if !defined(__IBMCPP__)
EXPENTRY
#endif
UI_StringEditor::StrEditProc
    (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    UI_StringEditor* edit = (UI_StringEditor*) (*_Controller)[hWnd];
    if (!edit)
        return WinDefWindowProc (hWnd, msg, p1, p2);
    if (msg == WM_CHAR && !(((ulong) p1) & KC_KEYUP) &&
        SHORT1FROMMP(p2) != 0) {
        int flag = SHORT1FROMMP(p1);
        if (flag & KC_VIRTUALKEY) {
            short vKey = SHORT2FROMMP(p2);
            if (vKey == VK_DELETE || vKey == VK_BACKSPACE) {
                if (!edit->PermitDelete ())
                    return 0;
            }
            else if (vKey == VK_SPACE) {
                short key = ' ';
                if (!edit->FilterChar (key))
                    return 0;
            }
            // Otherwise we want default processing, so fall through..
        }
        else {
            short mp1 = SHORT1FROMMP(p2);
            short mp2 = SHORT2FROMMP(p2);
            if (!edit->FilterChar (mp1))
                return 0;
            p2 = MPFROM2SHORT (mp1, mp2);
        }
    }
    return (*(edit->_oldEditProc)) (hWnd, msg, p1, p2);
}


void UI_StringEditor::_SubclassEditor ()
{
#if defined(__IBMCPP__)
    _oldEditProc = WinSubclassWindow (_handle, CallBackStrEditProc);
#else
    _oldEditProc = WinSubclassWindow (_handle, UI_StringEditor::StrEditProc);
#endif
}
#endif




#if defined(__X_YACL__)
bool UI_StringEditor::MakeVisualElement ()
{
    _visualElement = new YVE_StringWindow (this);
    if (_visualElement)
        _window = _visualElement->Handle();
    return _visualElement && _visualElement->Handle() ? TRUE : FALSE;
}

bool UI_StringEditor::HandleEvent (UI_Event* e)
{
    if (e->Type() == Event_Paint && _visible)
        _DrawVisualElement ();
    return ProcessEvent (e);
}


void UI_StringEditor::_DrawVisualElement ()
{
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    UI_ShadowRectangle rect (0, 0, _shape.Width(), _shape.Height(),
                             UI_ShadowRectangle::Recessed);
    rect.DrawOn (sfc);
    sfc.ColorRectangle (rect.Interior(), UIColor_White);
    DestroyDisplaySurface();
}

#endif
