
#ifndef _simple_h_
#define _simple_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




//   The SimpleVObject is an abstract class that encapsulates a VisualObject
//   that displays either a
//   single data item or a homogeneous collection of data items.
//
// 
//   SimpleVObject includes in its protocol a data structure called the {\it
//   model\/} 
//   and a selection mechanism determined by a {\it selection}. The actual 
//   interpretation of model and selection and their management is
//   left to subclasses of the SimpleVObject. The model is not owned by
//   this object but 
//   passed to it at construction by the derived class. The simple object
//   may however modify the
//   model. The parent of a simple object must be a VObjCollection.
// 
// 
//   The model has this object as a dependent and invokes
//   {\tt _ModelChanged()} when it changes.
//
// An application only  needs to instantiate classes derived from
// SimpleVObject, never a SimpleVObject itself. So all SimpleVObject
// constructors are protected.


#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/visualob.h"


#if defined(__OS2__) && defined(__IBMCPP__)
MRESULT EXPENTRY CallBackSubclassProc (HWND hWnd, ULONG msg,
                                       MPARAM p1, MPARAM p2);
#endif

class YACL_UI UI_VObjCollection;

class YACL_UI UI_SimpleVObject: public UI_VisualObject {

public:

    virtual UI_WindowClass WindowClass () const = 0;
    // Override the inherited method.
    
    const char* ClassName() const {return "UI_SimpleVObject";};

    
protected:

    UI_SimpleVObject (UI_VisualObject* parent, const UI_Rectangle& r,
                      UI_ViewID id = -1, long style = -1);
    // Constructor: create a SimpleVObject as child of {\tt parent}, with
    // given shape and id. The SimpleVObject owns its model.

    UI_SimpleVObject (UI_VisualObject* parent, CL_Object* model,
                      UI_ViewID id, const UI_Rectangle& r,
                      long style = -1);
    // Constructor: create a SimpleVObject as child of {\tt parent}, with
    // given shape and id. The SimpleVObject does not own its model, but
    // borrows the parameter {\tt model} from its caller to use as model.


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_SimpleVObject (UI_VObjCollection* parent, UI_ViewID id, UI_ViewHandle h);
    // [MS-Windows-specific] For resource-based construction.

#endif
                     

    ~UI_SimpleVObject(); 

    virtual bool _ModelChanged ();
    // Called by our model when it changes. The default
    // implementation calls {\tt Paint}.

    bool MakeVisualElement ();
    // Override the inherited method. The implementation supports the 3-d
    // look under MS-Windows.

    bool DestroyVisualElement ();
    // Destroy the visual element. This overrides the inherited method.

    void _PrivateInitialize();
    // Override the inherited method. Perform miscellaneous initializations.


    friend class YACL_UI UI_Controller;

#if defined(__X_MOTIF__)
    bool _ShapeRectChanged ();
    // [X-Motif-specific, for internal use only] Override the inherited
    // method.

#endif

public:

    // ------------- For YACL internal use only --------------

    bool SetStyleParam();
    // [MS-Windows-specific, for YACL internal use only]
    
protected:

    // Instance variables:
    
    bool       _ownModel;

#if defined(__OS2__)

private:
    void _Subclass ();
    // [OS/2-specific, for YACL internal use only] Subclass the control of
    // this SimpleVObject.

    PFNWP _oldProc;

#if defined(__IBMCPP__) // IBMCPP only allows _OptLink calling convention
                        // for member functions.  the work around is to
                        // make a global function that is used to call the
                        // class static function...
    static MRESULT SubclassProc (HWND hWnd, ULONG msg,
                                 MPARAM p1, MPARAM p2);
    // [OS/2- and IBM C++-specific, for YACL internal use only]

    friend MRESULT EXPENTRY CallBackSubclassProc(HWND hWnd, ULONG msg,
                                                 MPARAM p1, MPARAM p2);
    // [OS/2- and IBM C++-specific, for YACL internal use only] 

#else
    static MRESULT EXPENTRY SubclassProc (HWND hWnd, ULONG msg,
                                          MPARAM p1, MPARAM p2);
    // [OS/2-specific, for YACL internal use only] The window procedure used
    // for subclassing.

#endif
    virtual void WindowProcHook (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2);
    // [OS/2-specific, for YACL internal use only] Called by the
    // subclassing procedure.
    
#endif
};








#endif

