

#ifndef _shadorec_h_ /* Sat Jul 22 16:13:01 1995 */
#define _shadorec_h_


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// A ShadowRectangle is a Rectangle that can be drawn with a shadow so that
// it appears in either raised or recessed form. Its current implementation
// uses shades of gray to achieve the 3-d effect. It fills the rectangle's
// interior with light gray.
//
// Here is a diagram illustrating how it's drawn:
//
//       -----------------------------------       Legend:
//       |................................*|          ---    Border
//       |.                               *|          ...    Top shadow
//       |.                               *|          ***    Bottom shadow
//       |*********************************|
//       -----------------------------------
//
// The ShadowRectangle constructor can be given a base color as parameter;
// this parameter defaults to gray. The shadow colors are computed with
// respect to the base color, and the interior is filled with the base color.

#include "ui/rectangl.h"
#include "ui/color.h"

class YACL_UI UI_ShadowRectangle: public UI_Rectangle {

public:
    //[ Local
    enum Style {Raised, Recessed};

    // This enumeration determines the style of the ShadowRectangle.
    //] Local
    
    UI_ShadowRectangle (long x, long y, long w, long h, Style style = Raised,
                        short shadowThickness = 1, bool border = TRUE,
                        const UI_Color& baseColor = UIColor_MediumGray);
    // Construct a shadowed rectangle w units wide and h units high,
    // with its top left corner positioned at (x, y). If {\tt border}
    // is TRUE, a 1-pixel black border is drawn around the rectangle. (Note
    // that if {\tt border} is FALSE, the outer one-pixel region of the
    // rectangle is not used.) The parameter {\tt baseColor} specifies the
    // base color of the rectangle, with respect to which the light and dark
    // shadow colors are computed (see ui/color.h).

    UI_ShadowRectangle (const UI_Rectangle& r, Style style = Raised,
                        short shadowThickness = 1, bool border = TRUE,
                        const UI_Color& baseColor = UIColor_MediumGray);
    
    UI_ShadowRectangle (const UI_ShadowRectangle&);
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point()) const;

    short Thickness () const {return _thickness;};
    // Return the shadow thickness in pixels.

    Style ShadowStyle () const {return _shadowStyle;};
    // Return the shadow style.

    UI_Color BaseColor () const {return _baseColor;};
    // Return the base color of this ShadowRectangle, which was specified
    // as parameter when the ShadowRectangle was constructed.

    UI_Rectangle Interior() const;
    // Return the shape of the interior of the ShadowRectangle, i.e., the
    // region enclosed within the border and the shadows.
    
    CL_Object* Clone () const {return new UI_ShadowRectangle (*this);}

    const char* ClassName () const {return "UI_ShadowRectangle";};
    
protected:
    short     _thickness;
    Style     _shadowStyle;
    bool      _showBorder;
    UI_Color  _baseColor;
    
};


#endif /* _shadorec_h_ */
