



#ifndef _shadolin_h_ /* Fri Sep 15 11:17:15 1995 */
#define _shadolin_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// This is a horizontal or vertical line with a shadow. It is two pixels
// wide.


#include "ui/graphic.h"
#include "ui/point.h"
#include "ui/color.h"

class YACL_UI UI_ShadowedLine: public UI_GraphicObject {

public:
    enum Style     {Raised, Recessed};
    enum Direction {Horizontal, Vertical};

    UI_ShadowedLine (long x, long y, long length, Style style = Raised,
                     Direction dir = Horizontal,
                     const UI_Color& baseColor = UIColor_MediumGray);
    // Specify the line to be constructed. (x, y) specifies the starting
    // point, which is the left end for a horizontal line and the top end
    // for a vertical line. The {\tt baseColor} parameter specifies the base
    // color with respect to which the light and dark shadow colors are
    // computed (see color.h).

    UI_ShadowedLine (const UI_ShadowedLine&);
    
    virtual UI_Rectangle BoundingRectangle () const;
    // Return the bounding rectangle for this ShadowedLine.

    virtual UI_Point Center () const;
    
    virtual bool DrawOn (UI_DrawingSurface& sfc,
                         const UI_Point& p = UI_Point (0, 0)) const;

    virtual void operator+= (const UI_Vector& p);

    virtual bool MoveTo (const UI_Point& p);
    // Move this ShadowedLine so that its starting point is at the given
    // point, and return TRUE if successful.


    const char* ClassName () const {return "UI_ShadowedLine";};

    CL_Object* Clone () const {return new UI_ShadowedLine (*this);};

protected:
    long         _x, _y;
    Style        _style;
    Direction    _dir;
    long         _length;
    UI_Color     _baseColor;
};

    
#endif /* _shadolin_h_ */
