

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#include "ui/shadolin.h"
#include "ui/dwgsurf.h"


const short Thickness = 2;

UI_ShadowedLine::UI_ShadowedLine (long x, long y, long length, Style style,
                                  Direction dir, const UI_Color& clr)
: _x (x), _y(y), _length (length), _style (style), _dir (dir), _baseColor(clr)
{
}


UI_ShadowedLine::UI_ShadowedLine (const UI_ShadowedLine& l)
: _x (l._x), _y(l._y), _length (l._length), _style (l._style),
  _dir (l._dir), _baseColor(l._baseColor)
{
}


UI_Rectangle UI_ShadowedLine::BoundingRectangle () const
{
    if (_dir == Horizontal) 
        return UI_Rectangle (_x, _y, _length, Thickness);
    else
        return UI_Rectangle (_x, _y, Thickness, _length);
}


UI_Point UI_ShadowedLine::Center () const
{
    if (_dir == Horizontal)
        return UI_Point (_x + _length/2, _y + Thickness/2);
    else
        return UI_Point (_x + Thickness/2, _y + _length/2);
}



bool UI_ShadowedLine::DrawOn (UI_DrawingSurface& sfc,
                              const UI_Point& p) const
{
    UI_Point w1, w2, g1, g2; // End-points for white and dark lines
    if (_dir == Horizontal) {
        if (_style == Raised) {
            w1 = UI_Point (_x,               _y);
            w2 = UI_Point (_x + _length - 1, _y);
            g1 = UI_Point (_x + 1,           _y + 1);
            g2 = UI_Point (_x + _length - 2, _y + 1);
        }
        else {
            w1 = UI_Point (_x,               _y + 1);
            w2 = UI_Point (_x + _length - 1, _y + 1);
            g1 = UI_Point (_x,               _y);
            g2 = UI_Point (_x + _length - 1, _y);
        }
    }
    else {
        if (_style == Raised) {
            w1 = UI_Point (_x,     _y);
            w2 = UI_Point (_x,     _y + _length - 1);
            g1 = UI_Point (_x + 1, _y + 1);
            g2 = UI_Point (_x + 1, _y + _length - 2);
        }
        else {
            w1 = UI_Point (_x + 1, _y);
            w2 = UI_Point (_x + 1, _y + _length - 1);
            g1 = UI_Point (_x,     _y);
            g2 = UI_Point (_x,     _y + _length - 1);
        }
    }

    UI_Pen&  pen      = sfc.Pen();
    
    // Save the old pen color
    UI_Color oldColor = pen.Color();

    // Draw the two lines
    UI_Color lightShadow = _baseColor.LightShadow();
    UI_Color darkShadow  = _baseColor.DarkShadow();
    pen.Color (lightShadow);
    sfc.DrawLine (w1 + p, w2 + p);
    pen.Color (darkShadow);
    sfc.DrawLine (g1 + p, g2 + p);

    // All done: restore the old pen color
    pen.Color (oldColor);
    return TRUE;
}

                                          

void UI_ShadowedLine::operator+= (const UI_Vector& p)
{
    if (PrepareToChange()) {
        _x += p.X();
        _y += p.Y();
        Notify();
    }
}



bool UI_ShadowedLine::MoveTo (const UI_Point& p)
{
    if (PrepareToChange()) {
        _x = p.XCoord();
        _y = p.YCoord();
        Notify();
        return TRUE;
    }
    return FALSE;
}


