

#include "ui/scrolwin.h"
#include "ui/applic.h"
#include "ui/cntroler.h"

#if defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#include <Xm/ScrolledW.h> 
#include <Xm/Form.h> 
#include <Xm/BulletinB.h> 
#include <Xm/DrawingA.h> 
#include <Xm/ScrollBar.h>
#include "ui/support/x_motif/ycomp.h"
#endif


class YACL_UI UIPriv_Scroller: public UI_ScrollBar {
    // This is a private class for use by the ScrollableWindow.
public:
    UIPriv_Scroller (UI_ScrollableWindow* parent, UI_ViewID id, bool vert);

    void MakeVisible ();

    void MakeInvisible ();

    bool Enable ();

    bool Disable ();

    void Reshape ();
    
protected:
    ~UIPriv_Scroller () {};
    
    bool MakeVisualElement ();

    bool DestroyVisualElement ();

    bool _ShapeRectChanged ();

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    void _SetPosition (long pos);
    void _SetRange();

#endif

};

#if defined(__X_MOTIF__)
static const SCROLL_BAR_WIDTH = 12;
#endif

UIPriv_Scroller::UIPriv_Scroller (UI_ScrollableWindow* parent,
                                  UI_ViewID id, bool vert)
: UI_ScrollBar (parent, UI_Rectangle(), id, -1)
{
    _vertical = vert;
    Reshape ();
}


void UIPriv_Scroller::Reshape ()
{
#if defined(__X_MOTIF__)
    if (_vertical)
        _shape = UI_Rectangle
            (_parent->Shape().Width() - SCROLL_BAR_WIDTH, 0, SCROLL_BAR_WIDTH,
             _parent->Shape().Height() - SCROLL_BAR_WIDTH);
    else
        _shape = UI_Rectangle
            (0, _parent->Shape().Height() - SCROLL_BAR_WIDTH,
             _parent->Shape().Width() - SCROLL_BAR_WIDTH,
             SCROLL_BAR_WIDTH);
#endif
}



bool UIPriv_Scroller::_ShapeRectChanged ()
{
#if defined(__X_MOTIF__)
    UI_ScrollBar::_ShapeRectChanged();
#endif
    return TRUE;
}


void UIPriv_Scroller::MakeVisible ()
{
    _visible = TRUE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewHandle ph = _parent->ViewHandle();
    if (ph)
        ShowScrollBar (ph, _vertical ? SB_VERT : SB_HORZ, TRUE);
#elif defined(__OS2__)
    // This trick I learned from the FAQ
    HWND hFrame = ((UI_ScrollableWindow*) Parent())->FrameHandle();
    WinSetParent (_handle, hFrame, TRUE);
    WinSendMsg (hFrame, WM_UPDATEFRAME,
                (MPARAM) ( _vertical ? FCF_VERTSCROLL :
                          FCF_HORZSCROLL),
                NULL);
    WinShowWindow (_handle, TRUE);
#elif defined (__X_MOTIF__)
    UI_ScrollBar::MakeVisible ();
#endif
}

void UIPriv_Scroller::MakeInvisible ()
{
    _visible = FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewHandle ph = _parent->ViewHandle();
    if (ph)
        ShowScrollBar (ph, _vertical ? SB_VERT : SB_HORZ, FALSE);
#elif defined(__OS2__)
    // This trick I learned from the FAQ
    WinSetParent (_handle, HWND_OBJECT, TRUE);
    HWND hFrame = ((UI_ScrollableWindow*) Parent())->FrameHandle();
    WinSendMsg (hFrame, WM_UPDATEFRAME,
                (MPARAM) (_vertical ? FCF_VERTSCROLL : FCF_HORZSCROLL),
                NULL);
    WinShowWindow (_handle, FALSE);
#elif defined (__X_MOTIF__)
    UI_ScrollBar::MakeInvisible ();
#endif
}



bool UIPriv_Scroller::Enable ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewHandle ph = _parent->ViewHandle();
    if (ph)
        EnableScrollBar (ph, _vertical ? SB_VERT : SB_HORZ,
                         ESB_ENABLE_BOTH);
    return TRUE;
#elif defined(__OS2__) || defined(__X_MOTIF__)
    return UI_ScrollBar::Enable();
#endif
}

    

bool UIPriv_Scroller::Disable ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ViewHandle ph = _parent->ViewHandle();
    if (ph)
        EnableScrollBar (ph, _vertical ? SB_VERT : SB_HORZ,
                         ESB_DISABLE_BOTH);
    return TRUE;
#elif defined(__OS2__) || defined(__X_MOTIF__)
    return UI_ScrollBar::Disable();
#endif
}

    


bool UIPriv_Scroller::MakeVisualElement ()
{
    bool retVal = FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // Windows takes care of creating the scroll bar
    // Do nothing
#elif defined(__OS2__)
    UI_ViewHandle ph = _parent->ViewHandle();
    if (ph)
        _handle = WinWindowFromID
            (WinQueryWindow (ph, QW_PARENT),
             _vertical ? FID_VERTSCROLL : FID_HORZSCROLL);
    retVal = (_handle != 0) ? TRUE : FALSE;
#elif defined(__X_MOTIF__)
    retVal = UI_ScrollBar::MakeVisualElement();    
    XtVaSetValues (_xwidget, XmNresizable, TRUE, NULL);
    if (!_visible)
        MakeInvisible();
#endif
    return retVal;
}


bool UIPriv_Scroller::DestroyVisualElement ()
{
    return UI_ScrollBar::DestroyVisualElement ();
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
void UIPriv_Scroller::_SetPosition (long pos)
{
    SetScrollPos (_parent->ViewHandle(), _vertical ? SB_VERT : SB_HORZ,
                  pos, TRUE);
}
void UIPriv_Scroller::_SetRange ()
{
    CL_Interval& interval = *(CL_Interval*) _model;
    SetScrollRange (_parent->ViewHandle(), _vertical ? SB_VERT :
                    SB_HORZ, _range.Low(), 
		    _range.High() - interval.Length() + 1, TRUE);
}
#endif













enum {
    HSCROLLER_ID = 32700,
    VSCROLLER_ID
};


UI_ScrollableWindow::UI_ScrollableWindow (UI_VObjCollection* parent,
                     const UI_Rectangle& shape,
                     UI_ViewID id)
: UI_VObjCollection (parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style |= WS_HSCROLL | WS_VSCROLL;
#endif
    _horizontalBar = new UIPriv_Scroller (this, HSCROLLER_ID, FALSE);
    _verticalBar   = new UIPriv_Scroller (this, VSCROLLER_ID, TRUE );
    _bgColor       = UIColor_White;
}


UI_ScrollBar& UI_ScrollableWindow::HorzScrollBar ()
{
    return *_horizontalBar;
}

UI_ScrollBar& UI_ScrollableWindow::VertScrollBar ()
{
    return *_verticalBar;
}


bool UI_ScrollableWindow::Enable ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VObjCollection::Enable ();
#else
    return TRUE; // For now
#endif
}

bool UI_ScrollableWindow::Disable ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VObjCollection::Disable ();
#else
    return TRUE; // For now
#endif
}

    

void UI_ScrollableWindow::MakeInvisible ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_VObjCollection::MakeInvisible ();
#endif
}

    

void UI_ScrollableWindow::MakeVisible ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_VObjCollection::MakeInvisible ();
#endif
}

    

UI_WindowClass UI_ScrollableWindow::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_MOTIF__)
    return yCompositeWidgetClass;
#endif
}

    
#if defined(__X_MOTIF__)
void UI_ScrollableWindow::_SetupStyle (void* p, short& argn)
{
    UI_VObjCollection::_SetupStyle (p, argn);
    Arg* arg = (Arg*) p;
    UI_WindowClass w = WindowClass();
    XtSetArg (arg [argn], XmNresizePolicy, XmRESIZE_ANY); argn++;
   
}
#endif


bool UI_ScrollableWindow::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VObjCollection::MakeVisualElement ();
#elif defined(__OS2__)
    ulong frameFlags = FCF_BORDER | FCF_HORZSCROLL | FCF_VERTSCROLL;
    UI_ViewHandle parentHandle = _parent->ViewHandle();
    _frameHandle = WinCreateStdWindow
        (parentHandle, WS_VISIBLE, &frameFlags,
         WindowClass(), NULL, 0, 0, _id, &_handle);
    long parentHeight = _YACLWindowHeight (parentHandle);
    RECTL boundary;
    long left   = _shape.Left(),   top   = _shape.Top ();
    long height = _shape.Height(), width = _shape.Width ();
    boundary.xLeft   = left;
    boundary.yBottom = parentHeight - top - height;
    boundary.xRight  = left + width - 1;
    boundary.yTop    = parentHeight - top - 1;
    ulong swpFlags = SWP_SIZE | SWP_MOVE;
    if (_visible)
        swpFlags |= SWP_ACTIVATE | SWP_SHOW;
    WinSetWindowPos (_frameHandle, HWND_TOP,
                     boundary.xLeft, boundary.yBottom,
                     boundary.xRight - boundary.xLeft + 1,
                     boundary.yTop   - boundary.yBottom + 1, swpFlags);
    return _frameHandle != 0;
#elif defined(__X_MOTIF__)
    return UI_VObjCollection::MakeVisualElement ();
#endif
}


#if defined(__X_MOTIF__)
void UI_ScrollableWindow::_PrivateInitialize ()
{
    UI_VObjCollection::_PrivateInitialize();
}
#endif


bool UI_ScrollableWindow::DestroyVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VObjCollection::DestroyVisualElement ();
#elif defined (__OS2__)
    WinDestroyWindow (_frameHandle);
    return TRUE;
#elif defined(__X_MOTIF__)
    //    XtDestroyWidget (_scrolledWindow);
    return TRUE;
#endif
}



bool UI_ScrollableWindow::_ShapeRectChanged ()
{
#if defined(__OS2__)
    if (!_handle)
        return TRUE;
    long ht = _YACLWindowHeight (_parent ? _parent->ViewHandle()
                                : HWND_DESKTOP);
    long y = ht - _shape.Top() - _shape.Height();
    WinSetWindowPos (_frameHandle, HWND_TOP, _shape.Left(), y,
                     _shape.Width(), _shape.Height(),
                     SWP_SIZE | SWP_MOVE);
    return TRUE;
#elif defined(__X_MOTIF__)
    XtUnmanageChild (_xwidget); // Another hack
    UI_VObjCollection::_ShapeRectChanged();
    if (_visible)
        XtManageChild (_xwidget);
    ((UIPriv_Scroller*) _horizontalBar)->Reshape ();
    ((UIPriv_Scroller*) _verticalBar)->Reshape ();
    return TRUE;
    
#else
    return UI_VObjCollection::_ShapeRectChanged();
#endif
}


