


#ifndef _region_h_ /* Fri Jan 20 23:22:43 1995 */
#define _region_h_


// A region is a set of points in two-dimensional space. It is used for
// graphic operations.


#if defined(__GNUC__)
#pragma interface
#endif


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
typedef ulong UI_RegionHandle;
#elif defined(__X_MOTIF__)
#include <Xlib.h>
typedef Region UI_RegionHandle;
#endif


#include "ui/point.h"

class YACL_UI UI_Rectangle;

class YACL_UI UI_Region: public CL_Object {

public:
    UI_Region (const UI_Rectangle& r);
    // Create a rectangular region.

    UI_Region (UI_Point p[], short nPoints);
    // Create a polygonal region, whose extremities are the given points in
    // order. If the last point is not the same as the first, a line between
    // the first and last point is implicitly assumed.

    UI_Region (const UI_Region& r);
    // Copy constructor.


    bool Includes (const UI_Point& p);
    // Return TRUE if this region includes {\tt p}, FALSE otherwise.
    
    UI_Region operator+ (const UI_Region&);
    // Union of two regions.

    void operator+= (const UI_Region& r) {*this = *this + r;}
    
    UI_Region operator* (const UI_Region&);
    // Intersection of two regions.

    void operator*= (const UI_Region& r) {*this = *this * r;}
    
    UI_Region operator- (const UI_Region& r);
    // Set difference of two regions: return the region containing those
    // points in this region but not in r.
    
    void operator-= (const UI_Region& r) {*this = *this * r;}
    
    UI_Region operator^ (const UI_Region& r);
    // Exclusive or of two regions: return the region containing those
    // points in this region or in r but not in both.
    
    void operator^= (const UI_Region& r) {*this = *this ^ r;}
    

    void operator= (const CL_Object& o);

    UI_Region& operator= (const UI_Region& r);


    UI_RegionHandle Handle () const {return _handle;};
    // [For YACL internal use only]
    
protected:
    UI_RegionHandle _handle;
   

};

    
#endif /* _region_h_ */

