

#ifndef _pushbtn_h_ /* Fri Mar 11 08:35:35 1994 */
#define _pushbtn_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






// A PushButton is a SimpleVObject displayed as a button. It exhibits the
// behavior of being ``selected'' when either the left mouse button is
// pressed on it, or the space bar or return key is pressed when it has
// focus. When selected, the button sends itself an {\small\tt
// Event_Select}. By default, this event does nothing. The parent
// composite can catch this event (in its {\small\tt HandleChildEvent}
// method) and take the needed action. An event dependent can also be used
// to field this event.
//
// Since it is a SimpleVObject, the PushButton must define the notion of
// model; so it uses its title String as its model.

#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/simple.h"


class YACL_UI UI_PushButton: public UI_SimpleVObject {

public:

    UI_PushButton (UI_VisualObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1);
    // Constructor: create a PushButton as a child of {\tt parent}, with the
    // given shape and view id.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_PushButton(UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h);
    // Constructor used for resource-based construction (MS-Windows only).
    // An application never needs to use this constructor; it is used by
    // CompositeVObject.

#endif

    virtual UI_WindowClass WindowClass () const;
    // Override the inherited method.
    
    const char* ClassName() const {return "UI_PushButton";};
    
protected:

    bool MakeVisualElement ();
    // The inherited method is overridden because we need to set up a
    // callback under X windows. On other platforms, this method simply
    // forwards the call to the inherited method.
    
    bool _ModelChanged ();
    // Called to let this object know when its title changes.
    
    bool Select ();
    // The Select event handler.
   
    ~UI_PushButton () {};
   
#if defined (__X_MOTIF__)
    void  _SetupStyle (void* p, short& argn);
    // [X-windows-specific, for internal use only] Override
    // UI_VisualObject's method. The implementation sets up additional
    // resources for Motif.
    
    
    static void SelectionCallback (struct _WidgetRec*, void *, void *);
    // [X-windows-specific, for internal use only] The callback executed
    // when the Button is selected.

#elif defined (__X_YACL__)
    bool HandleEvent (UI_Event* e);
    // Override the inherited method.

    void DrawVisualElement ();
    
    bool _TitleChanged();

    bool _isDown;
    
#endif
    
};


#endif /* _pushbtn_h_ */
