




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/pushbtn.h"
#include "ui/cntroler.h"
#include "ui/composit.h"

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)

#include <windows.h>
#define PUSH_BUTTON_STYLE  \
    BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP

#elif defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Intrinsic.h>
#    include <Xm/PushB.h>
#    include <Xm/PushBG.h>
#elif defined (__X_YACL__)
#    include "ui/support/x_yacl/window.h"
#elif defined (__OS2__)
#    define PUSH_BUTTON_STYLE BS_PUSHBUTTON |  WS_VISIBLE
#endif

UI_PushButton::UI_PushButton (UI_VisualObject* parent, const UI_Rectangle& shape,
                              UI_ViewID id)
: UI_SimpleVObject (parent, shape, id
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
                    , PUSH_BUTTON_STYLE
#endif
             )
{
    _model = &_title;       // Dirty little trick to share the same string
    _ownModel = FALSE;      // between model and title
#if defined(__OS2__)
    _style = PUSH_BUTTON_STYLE;
#elif defined(__X_YACL__)
    _isDown = FALSE;
#endif
}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_PushButton::UI_PushButton (UI_CompositeVObject* parent,
                              UI_ViewID id, UI_ViewHandle h)
: UI_SimpleVObject (parent, id, h)
{
    _model = &_title;       // Dirty little trick to share the same string
    _ownModel = FALSE;     // between model and title
}
#endif



UI_WindowClass UI_PushButton::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "button";
#elif defined(__X_MOTIF__)
    return xmPushButtonWidgetClass;
#elif defined(__OS2__)
    return WC_BUTTON;
#endif
}


#if defined(__X_MOTIF__)
void UI_PushButton::SelectionCallback (Widget , void* client,
                                       void* call)
{
    UI_PushButton* btn = (UI_PushButton *) client;
    XmPushButtonCallbackStruct* cb = (XmPushButtonCallbackStruct*) call;
    if (cb->reason == XmCR_ACTIVATE) {
        UI_EventType typ = (cb->click_count == 1)
            ? Event_Select : Event_LButtonDblClk;
        // Here we have a problem. The code below dispatches this event
        // immediately; the downside of this is that  the button will look
        // pressed in until the event handler (and, indirectly, the
        // application's response to this event) returns. If, instead, I do
        // this: 
        //         UI_Event* evt = new UI_Event (typ, btn, btn);
        //         _Controller->AddEvent (evt);
        // The result is that modal dialogs do not complete until the first
        // event (e.g., the first mouse move) after this callback, which is
        // worse behavior. So I choose the lesser of the two evils:
        UI_Event evt (typ, btn, btn);
        _Controller->DispatchEvent (&evt);
    }
}

#endif



//
//----------------- Inherited methods ---------------------------
//

bool UI_PushButton::Select ()
{
    return FALSE;
}


bool UI_PushButton::_ModelChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0)
        SendMessage (_handle, WM_SETTEXT, 0, (long)(const char*)_title); 

#elif defined(__X_MOTIF__)

    if (!_xwidget)
        return TRUE;
    Arg arg [2];
    short argn = 0;

    XmString label;

    label = XmStringCreate ((char *) ( (CL_String *)_model )->AsPtr (), 
                            XmSTRING_DEFAULT_CHARSET 
                            );    
    
    XtSetArg (arg [argn], XmNlabelString, label); argn++;
    XtSetValues (_xwidget, arg, argn);

    XmUpdateDisplay (_xwidget);
    XmStringFree (label);
#endif

    return TRUE;
}



#if defined(__X_MOTIF__)
void UI_PushButton::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add another resource spec:
    XtSetArg (arg [argn], XmNrecomputeSize, FALSE); argn++;
}
#endif


bool UI_PushButton::MakeVisualElement ()
{
#if defined(__X_YACL__)
    _visualElement = new YVE_StringWindow (this);
    if (_visualElement)
        _window = _visualElement->Handle();
    return _visualElement && _visualElement->Handle() ? TRUE : FALSE;
#else
    
    bool b = UI_SimpleVObject::MakeVisualElement ();
#if defined(__X_MOTIF__)
    XtVaSetValues (_xwidget, XmNmarginWidth, 0, XmNmarginHeight, 0, NULL);
    XtAddCallback (_xwidget, XmNactivateCallback, 
                   &UI_PushButton::SelectionCallback, (XtPointer) this);
#endif
    return b;
#endif
}


#if defined(__X_YACL__)
void UI_PushButton::DrawVisualElement ()
{
    UI_ReliefStyle r = _isDown ? UIRelief_Recessed : UIRelief_Raised;
    ((YVE_StringWindow*) _visualElement)->Draw (_title, r, UIText_Center);
}

bool UI_PushButton::HandleEvent (UI_Event* e)
{
    if (!e)
        return FALSE;
    UI_EventType type = e->Type();
    switch  (type) {
    case Event_LButtonPress: {
        if (!_visible || !_enabled)
            break;
        _isDown = TRUE;
        DrawVisualElement();
        break;
    }
        
    case Event_LButtonRelease: {
        if (!_visible || !_enabled)
            break;
        _isDown = FALSE;
        DrawVisualElement();
        // We dispatch the select event on the up event rather than the
        // down event, because otherwise, in some cases, this event is
        // dispatched too late, e.g., if the application disables this
        // button on the select event.
        UI_Event e (Event_Select, this, this);
        _Controller->DispatchEvent (&e);
        break;
    }
        
    case Event_Paint:
        if (!_visible)
            break;
        // Have to take care of drawing in disabled state
        DrawVisualElement();
        break;
        
    default:
        break;
    }
    return ProcessEvent (e);
}

bool UI_PushButton::_TitleChanged ()
{
    if (_visualElement && !_isDown)
        DrawVisualElement();
    return TRUE;
}


#endif
