


#ifndef _orbtngrp_h_ /* Tue Nov 22 09:04:24 1994 */
#define _orbtngrp_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




// An  OrButtonGroup is a SimpleVObject that has an IntegerSet as model. The
// set contains the ViewID's of those buttons in the group that are chosen
// (i.e., checked). The contained buttons are required to be ToggleButtons.
// The ExOrButtonGroup must be used for exclusive-or groups.

#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/btngroup.h"
#include "ui/composit.h"

class YACL_UI UI_OrButtonGroup: public UI_ButtonGroup {

public:

    UI_OrButtonGroup (UI_VObjCollection* parent, 
                      const UI_Rectangle& shape, 
                      UI_ViewID id = -1,
                      UI_ViewDescriptor* vd = NULL);
    // Constructor: creates an empty ButtonGroup as a child of {\tt
    // parent}, with the given shape and view ID.

    
    virtual CL_IntegerSet& Selection ();
    // Return the current state of the selections, as a set of integers
    // containing the id's of the selected buttons. The return value may be
    // modified via the Set methods, and this results in modification of the
    // display.

    CL_Object& Model () {return Selection();};
    // This method overrides the inherited method. Its implementation
    // returns a reference to the same object as does the {\tt Selection}
    // method.


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_OrButtonGroup (UI_CompositeVObject* parent,  UI_ViewID id,
                    UI_ViewHandle h);
    // Resource-based construction (only under MS-Windows). This assumes
    // that (1) all (and only) the buttons in the group are geometrically
    // contained within the button group box's rectangle,  (2) the
    // contained buttons occur immediately after the group box in the
    // resource file ordering, and (3) the group box has a valid id.
    // Therefore, this does not allow (in particular) for groups within groups.

#endif

    
protected:
    CL_IntegerSet _selection;

    bool _ModelChanged ();
    // Override the inherited method.

    bool Select ();
    // The Select event handler. The implementation calls {\tt
    // _UpdateSelection}.
    
private:
    void _Init ();

    void _UpdateSelection ();
    // Update the {\tt _selection} instance variable.
    
};



#endif /* _orbtngrp_h_ */
