




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/orbtngrp.h"
#include "ui/cntroler.h"
#include "ui/toglbtn.h"
#include "base/integer.h"

typedef CL_Binding0 <UI_OrButtonGroup> Bind;

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_OrButtonGroup>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_OrButtonGroup>;
#endif

UI_OrButtonGroup::UI_OrButtonGroup
    (UI_VObjCollection* parent, const UI_Rectangle& shape,
     UI_ViewID id, UI_ViewDescriptor* vd)
: UI_ButtonGroup (parent, shape, id)
{
    if (vd) {
        char* fmt = "UI_OrButtonGroup constructor: invalid type %d "
            "at index %d";
        for (short i = 0; vd[i].type != View_None; i++) {
            if (vd[i].type != View_ToggleButton) {
                CL_Error::Warning (fmt, vd[i].type, i);
                break;
            }
            UI_ToggleButton* p = new UI_ToggleButton
                (this, vd[i].shape, vd[i].id);
            p->Title() = vd[i].title;
        }
    }
    _Init ();
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_OrButtonGroup::UI_OrButtonGroup
    (UI_CompositeVObject* parent,  UI_ViewID id, UI_ViewHandle h)
: UI_ButtonGroup (parent, id, h)
{
    _Init ();
}

#endif



void UI_OrButtonGroup::_Init ()
{
    Bind bind (this, &UI_OrButtonGroup::_ModelChanged);
    _selection.AddDependent (bind);
}




CL_IntegerSet& UI_OrButtonGroup::Selection ()
{
    _UpdateSelection ();
    return _selection;
}

void UI_OrButtonGroup::_UpdateSelection ()
{
    // We're going to modify _selection, so we must first remove ourselves
    // from its dependent set
    Bind bind (this, &UI_OrButtonGroup::_ModelChanged);
    _selection.RemoveDependent (bind); // So we don't get notified

    // Now fix it up:
    _selection.MakeEmpty ();
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        UI_ViewID id = assoc.key;
        CL_Integer value =  (CL_Integer&) ((*this)[id]->Model());
        if (value)
            _selection.Add (id);
    }
    _selection.AddDependent (bind); // Add us back as dependent
}





bool UI_OrButtonGroup::_ModelChanged ()
{
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        UI_ViewID id = assoc.key;
        CL_Integer value = _selection.Includes (id) ? 1 : 0;
        (*this)[id]->Model() = value;
    }
    return TRUE;
}


bool UI_OrButtonGroup::Select()
{
    _UpdateSelection ();
    _Controller->AddEvent (new UI_Event (Event_Select, this, this));
    return TRUE;
}


        


