




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/monthcal.h"
#include "ui/dsplsurf.h"
#include "ui/dsinmem.h"
#include "ui/composit.h"
#include "ui/stddlg.h"
#include "ui/shadorec.h"
#include "ui/shadolin.h"

#if defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/DrawingA.h>
#endif


// ----------------  Look-and-feel configuration parameters -----------------

// Labels for the week day columns:
static char* days[7] = {"S", "M", "T", "W", "T", "F", "S"};

// Top left corner of the month label: (the label rectangle spans the width
// of the calendar, and the name of month is centered in this rectangle)
static UI_Point CalendarOrigin (10,5);

// Vertical gap between month label and row of day labels:
static short GapBelowMonthLabel = 8;

// Vertical gap between row of day labels and 6x7 rectangle of dates:
static short GapBelowDayNames = 3;

// Gaps between cells in the 6x7 rectangular array:
static short HorzGap=5, VertGap = 3;

// ----------------- End configuration parameters --------------------------


UI_MonthCalendar::UI_MonthCalendar
    (UI_VisualObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_SimpleVObject (parent,  shape, id)
{
    _model  = new CL_Date;
    *_model = CL_Date::Today();
    CL_Date* dt = (CL_Date*) _model;
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = WS_CHILD | WS_VISIBLE;
#elif defined(__OS2__)
    _style = WS_VISIBLE;
#endif
    _month = dt->Month();
    _year = dt->Year();
    _daysInMonth = dt->DaysInMonth();
    TabStop (FALSE); // We're not a tab stop
}




void UI_MonthCalendar::AdvanceMonth ()
{
    CL_Date& our_model = *(CL_Date*) _model;
    _SetModelValue (our_model.AddMonths (1));
    _Repaint ();
}



void UI_MonthCalendar::PreviousMonth()
{
    CL_Date& our_model = *(CL_Date*) _model;
    _SetModelValue (our_model.AddMonths (-1));
    _Repaint ();
}



bool UI_MonthCalendar::Paint (const UI_Rectangle&)
{
    UI_DisplaySurface& sfc = CreateDisplaySurface();
    UI_DwgSurfaceInMemory memDS (_shape.Width(), _shape.Height());
    memDS.Font() = sfc.Font();
    _Draw (memDS);
    memDS.CopyTo (sfc, UI_Point(0,0));
    DestroyDisplaySurface();
    return FALSE;
}


void UI_MonthCalendar::_Draw (UI_DrawingSurface& dc)
{
    CL_Date dt (*(CL_Date*) _model);
    UI_Rectangle area = dc.DrawingArea ();
    dc.ColorRectangle (area, UIColor_MediumGray);
    _charWidth = dc.Font().Width();
    _charHeight = dc.Font().Height();
    _cellWidth = 3*_charWidth+4;
    _cellHeight = _charHeight+4;

    UI_Rectangle monthNameRect (CalendarOrigin, 7*(_cellWidth+HorzGap),
                                _cellHeight);
    UI_Rectangle dayNamesRect  =
        monthNameRect + UI_Vector(0, _cellHeight + GapBelowMonthLabel);
    UI_Point displayRectOrigin = dayNamesRect.Origin() +
        UI_Vector (0, _cellHeight + GapBelowDayNames);
    _displayRect = UI_Rectangle  (displayRectOrigin, dayNamesRect.Width(),
                                  6*(_cellHeight + VertGap));

    // Draw the outer rectangle
    // UI_ShadowRectangle rect (_displayRect);
    // rect.DrawOn (dc);
    UI_ShadowedLine vline (_displayRect.Left(), _displayRect.Top() + 1,
                          _displayRect.Height()-2, UI_ShadowedLine::Recessed,
                          UI_ShadowedLine::Vertical);
    short i;
    for (i = _displayRect.Width(); i >= 0; i -= _cellWidth + HorzGap) {
        vline.DrawOn (dc, UI_Point (i-2, 0));
    }
    UI_ShadowedLine hline (_displayRect.Left()+1, _displayRect.Top(),
                          _displayRect.Width()-2, UI_ShadowedLine::Recessed,
                          UI_ShadowedLine::Horizontal);
    for (i = _displayRect.Height(); i >= 0; i -= _cellHeight + VertGap) {
        hline.DrawOn (dc, UI_Point (0, i-2));
    }
    
    // Paint the month name
    dc.Pen().Color (UIColor_Black);
    UI_Point topLeft = CalendarOrigin;
    dc.WriteString (CL_Date::MonthName((CL_Date::MonthEnum)_month) + " "
                    + CL_String (_year), monthNameRect, UIText_Center);
    topLeft += UI_Point (0, _cellHeight + GapBelowMonthLabel);

    
    // Paint the names of the weekdays
    UI_PointSequence wkDaySq = dayNamesRect.RowMajor (_cellWidth+HorzGap,
                                                      _cellHeight);
    for (i = 0; i < 7; i++) {
        UI_Rectangle cell (wkDaySq[i],  _cellWidth, _cellHeight);
        dc.WriteString (days[i], cell, UIText_Center);
    }
    topLeft += UI_Point (0, _charHeight + GapBelowDayNames);

    
    // Paint the month's days
    UI_PointSequence displaySq = _displayRect.RowMajor
        (_cellWidth + HorzGap, _cellHeight + VertGap);
    CL_Date firstDay (_year, _month, 1);
    short dayOfWeek = firstDay.DayOfWeek();
    _dayOfFirst = dayOfWeek;
    CL_Date today = CL_Date::Today();
    for (i = 1; i <= _daysInMonth; i++) {
        UI_Point cellOrigin = displaySq[i+_dayOfFirst - 2];
        UI_Rectangle cell (cellOrigin, _cellWidth, _cellHeight);
        dc.WriteString (CL_String (i, 2, ' '), cell, UIText_Right);
        if (i == dt.Day() && _month == today.Month()
            && _year == today.Year()) {
            UI_Rectangle r (cell.Origin() + UI_Vector(2,2),
                            cell.Width() + HorzGap - 4,
                            cell.Height() + VertGap - 4);
            dc.InvertRectangle (r);
        }
        dayOfWeek++;
        if (dayOfWeek > 7) {
            dayOfWeek = 1;
        }
    }
}


bool UI_MonthCalendar::ButtonDown (const UI_Point& p, UI_MouseButton btn,
                                   bool, bool)
{
    if (btn != UIM_Left)
        return FALSE;
    UI_PointSequence displaySq = _displayRect.RowMajor
        (_cellWidth + HorzGap, _cellHeight + VertGap);
    short dayOfWeek = _dayOfFirst;
    for (short i = 1; i <= _daysInMonth; i++) {
        UI_Point cellOrigin = displaySq[i+_dayOfFirst - 2];
        UI_Rectangle cell (cellOrigin, _cellWidth, _cellHeight);
        if (cell.Includes (p)) {
            ClickOnDay (i);
            return TRUE;
        }
        dayOfWeek++;
        if (dayOfWeek > 7) {
            dayOfWeek = 1;
        }
    }
    return TRUE;
}



UI_WindowClass UI_MonthCalendar::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLSimpleClassName;
#elif defined(__X_MOTIF__)
    return xmDrawingAreaWidgetClass;
#endif
}


void UI_MonthCalendar::_Repaint ()
{
    CL_Date& our_model = *(CL_Date*) _model;
    _month = our_model.Month();
    _year  = our_model.Year();
    _daysInMonth = CL_Date::DaysInMonth (_month, _year);
    Paint(Shape());
}


void UI_MonthCalendar::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
#if defined(__OS2__)
    // This shouldn't be necessary, but OS/2 doesn't seem to give me the
    // paint event the first time. So:
    Paint (_shape);
#endif
}


bool UI_MonthCalendar::_ModelChanged ()
{
    _Repaint ();
    return TRUE;
}


void UI_MonthCalendar::ClickOnDay (short /* day */ )
{
}


