




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif


#define MNEMONIC_CHAR '&'  // For alt- functions

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#   include <windows.h>
#   include "base/bytstrng.h"
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#   include <Xm/RowColumn.h>
#   include <Xm/CascadeB.h>
#   include <Xm/PushB.h>
#   include <Xm/CascadeBG.h>
#   include <Xm/PushBG.h>
#   include <Xm/Separator.h>
#   include <Xm/MainW.h>
#   include <Xm/ToggleB.h>
#   include <iostream.h> //DEBUG
#endif

#include "ui/menu.h"
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/font.h"

#include "base/binding.h"
#include "base/treewalk.h"



UI_MenuItem::UI_MenuItem (UI_Menu* container, const char*
                          label, UI_ViewID id)
: UI_SimpleVObject ((UI_CompositeVObject*) container->Parent(),
    // --------------^^^^^^^^^^^^^^^^^^^^
    // We can safely cast down, because the constructor of UI_Menu insists
    // on a Composite for its parent.
                    UI_Rectangle (), id,  -1),                    
    _container (container)
{
    _SetTitle (label);
    _ownModel   = FALSE;
    _checkState = NotCheckable;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _handle    = 0;
    _parentHandle = 0;
#elif defined(__OS2__)
    _handle    = 0;
#elif defined(__X_MOTIF__)
    _xitemw = NULL;
#endif
}


UI_WindowClass UI_MenuItem::WindowClass () const
{
    // This method is not used for widget creation, only for run-time type
    // identification
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "";
#elif defined(__OS2__)
    return NULL;
#elif defined (__X_MOTIF__)
    return NULL; 
#endif
}




bool UI_MenuItem::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // The actual visual element for a popup menu is created by the UI_Menu
    // object, so if we are a popup, our handle is already set
    return FALSE; // We don't register menu items under Windows 
#elif defined(__OS2__)
    return _handle ? TRUE : FALSE;
    // Only non-leaf items have non-zero handles, and those are the ones we
    // register.
#elif defined (__X_MOTIF__)
    return FALSE; // We don't register  menu items under X
#endif
}

void UI_MenuItem::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize();
    if (!_enabled)
        Disable ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // Under Windows,  the Controller maintains a map of menu id's
    // for each window, and the MenuItemCreated method updates this map.
    if (_id > 0 && !_Controller->MenuItemCreated (this))
        CL_Error::Warning ("MenuItem constructor: duplicate view id %ld",
                           _id);
#endif
}


bool UI_MenuItem::DestroyVisualElement ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle > 0) {
        DestroyMenu (_handle);
        return TRUE;
    }
    return FALSE;
#elif defined(__OS2__)
    return UI_SimpleVObject::DestroyVisualElement ();
    
#elif defined (__X_MOTIF__)
    return TRUE;
#endif
}


#if defined (__X_MOTIF__)
void UI_MenuItem::Destroy ()
{
    if (!_id) {
        //  This is the dummy menu item at the root; it doesn't have a
        //  visual element.
        return;
    }
    if (_xitemw)
        XtDestroyWidget (_xitemw);
    if (_xwidget)
        XtDestroyWidget (_xwidget);
    _xitemw = _xwidget = 0;
    Finalize ();
    _PrivateFinalize ();
}
#endif


bool UI_MenuItem::Enable ()
{
    _enabled = TRUE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _SetState ();
    return TRUE;
#elif defined(__X_MOTIF__)
    if (_xitemw)
        XtSetSensitive (_xitemw, TRUE);
    if (_xwidget)
        XtSetSensitive (_xwidget, TRUE);
    return TRUE;
#endif
}



bool UI_MenuItem::Disable ()
{
    _enabled = FALSE;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _SetState ();
    return TRUE;
#elif defined(__X_MOTIF__)
    if (_xitemw)
        XtSetSensitive (_xitemw, FALSE);
    if (_xwidget)
        XtSetSensitive (_xwidget, FALSE);
    return TRUE;
#endif
}

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
void UI_MenuItem::_SetState ()
{
    if (!_parentHandle)
        return;
    UINT state = GetMenuState (_parentHandle, _container->Index(_id),
                               MF_BYPOSITION);
    if (state == (UINT) -1)
        CL_Error::Fatal ("MenuItem::_SetState: GetMenuState failed: "
                         "parent handle %ld item id %ld", _parentHandle, _id);
    state &= 0xff; // Mask out the number of children if this is a popup
    state = IsEnabled() ? ((state & ~MF_GRAYED) | MF_ENABLED)
        : ((state & ~MF_ENABLED) | MF_GRAYED);
    state = (_checkState == Checked) ? ((state & ~MF_UNCHECKED) | MF_CHECKED)
        : ((state & ~MF_CHECKED) | MF_UNCHECKED);
    short pos =  _container->Index(_id);
    if (state & MF_POPUP) {
        short count = GetMenuItemCount (_parentHandle);
        if (count == -1)
            CL_Error::Fatal ("MenuItem::_SetState: GetMenuItemCount failed: "
                             "parent handle %d item id %ld", _parentHandle,
                             _id);
        HMENU h = GetSubMenu (_parentHandle, _container->Index (_id));
        if (!ModifyMenu (_parentHandle, pos, state | MF_BYPOSITION, (UINT) h,
                         _title.AsPtr()))
            CL_Error::Warning ("ModifyMenu call failed: menu item id %ld",
                               _id);
    }
    else {
        if (!ModifyMenu (_parentHandle, _id, state, _id, _title))
            CL_Error::Warning ("ModifyMenu call failed: menu item id %ld",
                               _id);
    }
    DrawMenuBar (_container->Parent()->ViewHandle());
}

#elif defined(__OS2__)
void UI_MenuItem::_SetState ()
{
    if (IsEnabled()) {
        WinSendMsg (_container->ViewHandle(), MM_SETITEMATTR,
                    MPFROM2SHORT (_id, TRUE), MPFROM2SHORT (MIA_DISABLED, 0));
        if (_handle)
            WinEnableWindow (_handle, IsEnabled());
    }
    else {
        WinSendMsg (_parentHandle, MM_SETITEMATTR,
                    MPFROM2SHORT (_id, TRUE),
                    MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
        if (_handle)
            WinEnableWindow (_handle, FALSE);
    }
    if (_checkState == Checked)
        WinSendMsg (_container->ViewHandle(), MM_SETITEMATTR,
                    MPFROM2SHORT (_id, TRUE), MPFROM2SHORT (MIA_CHECKED,
                                                            MIA_CHECKED));
    else
        WinSendMsg (_container->ViewHandle(), MM_SETITEMATTR,
                    MPFROM2SHORT (_id, TRUE), MPFROM2SHORT (MIA_CHECKED, 0));
}
#endif





bool UI_MenuItem::_TitleChanged ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    _SetState ();
    return TRUE;
#elif defined(__OS2__)
    CL_String title = _title;
    title.Replace ("&", "~");
    WinSendMsg (_container->ViewHandle(), MM_SETITEMTEXT, MPFROMSHORT (_id),
                MPFROMP (title.AsPtr()));
    return TRUE;
#elif defined (__X_MOTIF__)
    if (!_xitemw)
        return TRUE; // Not yet set up
    SetLabel ();
    XmUpdateDisplay (_xitemw);
    return TRUE;
#endif
}



bool UI_MenuItem::_FontChanged ()
{
    // Override the inherited method with one that does nothing.
    return TRUE;
}


bool UI_MenuItem::PropagateFontChange (UI_VisualObject*)
{
    // Override the inherited method with one that does nothing.
    return TRUE;
}


UI_ViewHandle UI_MenuItem::ViewHandle () const
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VisualObject::ViewHandle ();

#elif defined(__OS2__)
    return _handle;
    
#elif defined (__X_MOTIF__)
    return UI_ViewHandle (_xitemw);

#endif
}


UI_MenuItem::~UI_MenuItem ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _Controller->MenuItemDestroyed (this);
#endif
}


bool UI_MenuItem::SetCheck (CheckState state)
{
    _checkState = state;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _SetState ();
#elif defined(__X_MOTIF__)
    bool flag = (_checkState == Checked) ? TRUE : FALSE;
    if (_xitemw && _checkState != NotCheckable)
        XtVaSetValues (_xitemw, XmNindicatorOn, TRUE, XmNset, flag, NULL);
#endif
    return TRUE;
}

bool UI_MenuItem::ToggleCheckState ()
{
    if (_checkState == Checked)
        _checkState = NotChecked;
    else
        _checkState = Checked;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _SetState ();
#endif
    return TRUE;
}






#if defined (__X_MOTIF__)
void UI_MenuItem::SetLabel ()
{
    CL_String label = _title;
    if (label == UIMenu_Separator)
        return;
    short mnemonic_pos = label.CharIndex (MNEMONIC_CHAR);
    if (mnemonic_pos >= 0 && mnemonic_pos < label.Size()-1) {
        label(mnemonic_pos,1) = ""; // Remove the mnemonic char
        if (label[mnemonic_pos] == MNEMONIC_CHAR) // Two consecutive?
            mnemonic_pos = -1;
    }
    XmString xmlabel = XmStringCreate ((char*) label.AsPtr(),
                                       XmSTRING_DEFAULT_CHARSET);
    Arg arg[2];
    short argn = 0;
    XtSetArg (arg[0], XmNlabelString, xmlabel); argn++;
    if (mnemonic_pos >= 0) {
        XtSetArg (arg[1], XmNmnemonic, label[mnemonic_pos]);  argn++;
    }
    XtSetValues (_xitemw, arg, argn);
    XmStringFree (xmlabel);
}


void UI_MenuItem::GetFocusCallback (Widget , void* client, void*  )
{
    UI_MenuItem* mi = (UI_MenuItem *) client;
    UI_Event evt (Event_GetFocus, mi, mi);
    _Controller->DispatchEvent (&evt);
}



void UI_MenuItem::LoseFocusCallback (Widget , void* client, void* )
{
    UI_MenuItem* mi = (UI_MenuItem *) client;
    UI_Event evt (Event_LoseFocus, mi, mi);
    _Controller->DispatchEvent (&evt);
}


void UI_MenuItem::SelectionCallback (Widget , void* client, void* )
{
    UI_MenuItem* mi = (UI_MenuItem *) client;
    UI_Event evt (Event_Select, mi, mi);
    _Controller->DispatchEvent (&evt);
}

#endif

// --------------------- UI_Menu methods -----------------------


#if defined(__OS2__)
static const long ROOT_ID = FID_MENU;
#else
static const long ROOT_ID = 0;
#endif

UI_Menu::UI_Menu (UI_CompositeVObject* parent, UI_MenuItemDescriptor* items)
: UI_VisualObject (parent, UI_Rectangle (), -1)
{
    UI_MenuItem* root_item = new UI_MenuItem (this, "", ROOT_ID);
    if (!root_item)
        return;
    _menuTree.NewRoot (ROOT_ID);
    _menuTree.Root()->Content() = (long) root_item;
    _BuildMenuSubtree (items, ROOT_ID);
    _focusItem = NULL;
}


UI_ViewID UI_Menu::RootID () const
{
    return ROOT_ID;
}



short UI_Menu::_BuildMenuSubtree (UI_MenuItemDescriptor* items,
                                 UI_ViewID subtree_root)
{
    if (!items)
        return 0;
    CL_IntegerTreeNode* root = _menuTree.Node (subtree_root);
    if (!root)
        return 0;
    short n = 0;
    for (; items[n].label != NULL; n++) {
        UI_ViewID id;
        if (items[n].id < 0) {
            CL_Error::Warning ("UI_Menu::_Build: negative view id %d for "
                               "menu item", items[n].id);
            return n;
        }
        if (CL_String (UIMenu_Separator) == items[n].label)
            id = _AllocateSeparatorId();
        else
            id = items[n].id;
        UI_MenuItem* new_itm = new UI_MenuItem
            (this, items[n].label, id);
        CL_IntegerTreeNode* node = _menuTree.AddChild (id, subtree_root);
        if (node) {
            node->Content() = (long) new_itm;
            _BuildMenuSubtree (items[n].submenu, items[n].id);
        }
        else
            CL_Error::Warning ("YACL: UI_Menu: invalid (duplicate?) "
                               "menu item id %ld", id);
    }
    return n;
}



bool UI_Menu::Add (UI_ViewID id, const char* label,
                   UI_ViewID parent_id, short rank)
{
    if (id <= 0) {
        CL_Error::Warning ("UI_Menu::Add: negative view id %ld not allowed",
                           id);
        return FALSE; // Cannot add
    }
    CL_IntegerTreeNode* subtree_root = _menuTree.Node (parent_id);
    if (!subtree_root)
        return FALSE;
    UI_MenuItem* new_itm = new UI_MenuItem (this, label, id);
    CL_IntegerTreeNode* node = _menuTree.AddChild (id, parent_id, rank);
    if (node) {
        node->Content() = (long) new_itm;
        if (ViewHandle())
            _CreateMenuItemVisual (*node);
#if defined(__X_MOTIF__)
        if (new_itm->_xwidget)
            _Controller->RealizeWidget (new_itm->_xwidget);
        if (new_itm->_xitemw)
            _Controller->RealizeWidget (new_itm->_xitemw);
#endif
        return TRUE;
    }
    return FALSE;
}



bool UI_Menu::AddSeparator (UI_ViewID parent_id, short rank)
{
    CL_IntegerTreeNode* subtree_root = _menuTree.Node (parent_id);
    if (!subtree_root)
        return FALSE;
    UI_ViewID id =  _AllocateSeparatorId();
    UI_MenuItem* new_itm = new UI_MenuItem (this, UIMenu_Separator, id);
    CL_IntegerTreeNode* node = _menuTree.AddChild (id, parent_id, rank);
    if (node) {
        node->Content() = (long) new_itm;
        if (ViewHandle())
            _CreateMenuItemVisual (*node);
        return TRUE;
    }
    return FALSE;
}

bool UI_Menu::RemoveSeparator (UI_ViewID parent_id, short rank)
{
    CL_IntegerTreeNode* subtreeRoot = _menuTree.Node (parent_id);
    if (!subtreeRoot)
        return FALSE;
    short n = subtreeRoot->ChildCount();
    if (rank < 0 || rank >= n-1)
        return FALSE;
    CL_IntegerTreeNode* itemNode = subtreeRoot->Child (rank+1);
    if (!itemNode)
        return FALSE;
    return _DoRemove (itemNode);
}

bool UI_Menu::Remove (UI_ViewID id)
{
    CL_IntegerTreeNode* node = _menuTree.Node (id);
    if (!node)
        return FALSE;
    return _DoRemove (node);
}



short UI_Menu::ChildCount (UI_ViewID id) const
{
    CL_IntegerTreeNode* node = _menuTree.Node (id);
    return node ? node->ChildCount() : -1;
}


UI_MenuItem* UI_Menu::Child (UI_ViewID id, short i) const
{
    CL_IntegerTreeNode* node = _menuTree.Node (id);
    if (!node)
        return (UI_MenuItem*) NULL;
    node = node->Child(i);
    return (node ? (UI_MenuItem*) node->Content () : (UI_MenuItem*) NULL);
}



short UI_Menu::Index (UI_ViewID id) const
{
    CL_IntegerTreeNode* node = _menuTree.Node (id);
    return node ? node->IndexInParent() : -1;
}

UI_MenuItem* UI_Menu::operator [] (UI_ViewID id)
{
    CL_IntegerTreeNode* node = _menuTree.Node (id);
    return node ? ((UI_MenuItem*) node->Content()) : (UI_MenuItem*) NULL;
}


UI_WindowClass UI_Menu::WindowClass () const
{
    // This method is not used for widget creation, only for run-time type
    // identification
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return "menu";
#elif defined(__OS2__)
    return WC_MENU;
#elif defined (__X_MOTIF__)
    return NULL; 
#endif
}





#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
bool UI_Menu::_CreateMenuItemVisual (CL_IntegerTreeNode& node)
{
    UI_MenuItem*         itm   = (UI_MenuItem *) node.Content ();
    CL_IntegerTreeNode* parent = node.Parent();
    if (!parent)
        return TRUE; // We don't need to create the visual element for the
                     // root, it's already created by the derived class
    UI_MenuItem*        parentItem =  (UI_MenuItem*) parent->Content();
    if (parentItem && !parentItem->_handle) {
        UI_MenuItem* gpItem = (UI_MenuItem*) parent->Parent()->Content();
        UI_ViewHandle gpHandle = gpItem->_handle;
        parentItem->_handle = CreatePopupMenu ();
        ModifyMenu (gpHandle, parentItem->ViewID(),
                    MF_BYCOMMAND | MF_STRING | MF_POPUP,
                    (UINT) parentItem->_handle,  parentItem->Title());
        DrawMenuBar (Parent()->ViewHandle());
    }

    UI_ViewHandle h = parent ? parentItem->ViewHandle() : 0;
    itm->_parentHandle = h;

    short position = node.IndexInParent();
    if ( !node.IsLeaf () ) {
        if (parent) {
            // This is not the root. The root's handle is set by the
            // MakeVisualElement method that is calling us.
            itm->_handle = CreatePopupMenu ();
            if (!InsertMenu (h, position, MF_STRING | MF_POPUP,
                             (UINT) itm->_handle, itm->_title.AsPtr())) {
                CL_String s = CL_String
                    ("Menu::_CreateItemVisual: InsertMenu failed: id ")
                    + CL_String (itm->ViewID());
                s += " " + _Application->ErrorString();
                CL_Error::Warning (s.AsPtr());
            }
            
        }
    }
    else {
        if ( h ) {
            BOOL b = (CL_String (UIMenu_Separator) == itm->_title)
                ? InsertMenu (h, position, MF_SEPARATOR, -1, 0)
                : InsertMenu (h, position, MF_STRING  | MF_BYPOSITION,
                              itm->_id, itm->_title.AsPtr());
            if (!b)
                CL_Error::Warning ("Menu::_CreateItemVisual: InsertMenu "
                                   "failed: id %ld pos %d", itm->ViewID(),
                                   position);
        }
    }
    return TRUE;
}
#endif



#if defined(__OS2__)
bool UI_Menu::_CreateMenuItemVisual (CL_IntegerTreeNode& node)
{
    UI_MenuItem*         itm   = (UI_MenuItem *) node.Content ();
    CL_IntegerTreeNode* parent = node.Parent();
    if (!parent)
        return TRUE; // We don't need to create the visual element for the
                     // root, it's already created by the derived class
    UI_MenuItem*        parentItem = (UI_MenuItem*) parent->Content();
    if (!parent) {
        itm->_handle = _handle;
        itm->_parentHandle = 0;
    }
    else if (parentItem && !parentItem->_handle) {
        // We're adding a submenu to an item that didn't used to have any
        // children.
        UI_MenuItem* gpItem = (UI_MenuItem*) parent->Parent()->Content();
        UI_ViewHandle gpHandle = gpItem->_handle;
        MENUITEM menuItemStruct;
        menuItemStruct.iPosition = parent->IndexInParent();
        menuItemStruct.afStyle = MIS_TEXT | MIS_SUBMENU;
        menuItemStruct.hwndSubMenu = WinCreateWindow
            (gpHandle, WC_MENU, parentItem->Title().AsPtr(),
             WS_VISIBLE, 0, 0, 0, 0, gpHandle,
             HWND_BOTTOM, _id, NULL, NULL);
        menuItemStruct.afAttribute = 0;
        menuItemStruct.id = parentItem->ViewID();
        menuItemStruct.hItem = 0;
        WinSendMsg (gpHandle, MM_SETITEM, 0, (MPARAM) &menuItemStruct);
        parentItem->_handle = menuItemStruct.hwndSubMenu;
    }
    
    HWND frame = WinQueryWindow (_parent->ViewHandle(), QW_PARENT);
    HWND parentHandle = parentItem ? parentItem->ViewHandle() : frame;
    short position = node.IndexInParent();
    if (parent && position >= parent->ChildCount())
        position = MIT_END;
    MENUITEM menuItemStruct;
    menuItemStruct.iPosition = position;
    CL_String title = itm->Title();
    if (title == UIMenu_Separator) {
        menuItemStruct.afStyle = MIS_SEPARATOR;
        menuItemStruct.hwndSubMenu = 0;
    }
    else {
        title.Replace ("&",  "~");
        menuItemStruct.afStyle = MIS_TEXT;
        if (!parentItem) {
            menuItemStruct.afStyle |= MIS_SUBMENU;
            menuItemStruct.hwndSubMenu = _handle;
        }
        else if (node.ChildCount() /* || parentItem->ViewID() == ROOT_ID */) {
            menuItemStruct.afStyle |= MIS_SUBMENU;
            menuItemStruct.hwndSubMenu = WinCreateWindow
                (parentHandle, WC_MENU, title.AsPtr(),
                 WS_VISIBLE, 0, 0, 0, 0, parentHandle,
                 HWND_BOTTOM, _id, NULL, NULL);
        }
        else
            menuItemStruct.hwndSubMenu = 0;
    }
    menuItemStruct.afAttribute = (itm->_enabled ? 0 : MIA_DISABLED) |
        (itm->_checkState == UI_MenuItem::Checked ? MIA_CHECKED : 0);
    menuItemStruct.id = itm->ViewID();
    menuItemStruct.hItem = 0;
    WinSendMsg (parentHandle, MM_INSERTITEM, (MPARAM) &menuItemStruct,
                (MPARAM) title.AsPtr());
    itm->_handle = menuItemStruct.hwndSubMenu;
    itm->_parentHandle = parentHandle;
    return TRUE;
}
#endif



#if defined(__X_MOTIF__)

static bool IsMenuBar (UI_ViewHandle xwidget)
{
    uchar rowColType;
    XtVaGetValues (xwidget, XmNrowColumnType, &rowColType, NULL);
    return rowColType == XmMENU_BAR ? TRUE : FALSE;
}

static short _CurrentWidgetRank = 0; // Using this global var is a terrible
                                     // hack, but there's no other way
                                     // under Motif

int UI_Menu::OrderProc (Widget )
{
    return _CurrentWidgetRank;
}

bool UI_Menu::_CreateMenuItemVisual (CL_IntegerTreeNode& node)
{
    UI_MenuItem*         itm   = (UI_MenuItem *) node.Content ();
    CL_IntegerTreeNode* parent = node.Parent();
    if (!parent) {
        XtVaSetValues (itm->_xwidget, XmNinsertPosition, &OrderProc, NULL);
        return TRUE; // We don't need to create the visual element for the
                     // root, it's already created by the derived class
    }
    _CurrentWidgetRank = node.IndexInParent ();
    UI_MenuItem*        parentItem = (UI_MenuItem*) parent->Content();
    Widget              parentw = parentItem ? parentItem->_xwidget : 0;
    if (parentItem && !parentItem->_xwidget) {
        // This can happen if "node" is a newly-added leaf
        Widget gpWidget = 
            ((UI_MenuItem *) parent->Parent()->Content())->_xwidget;
        CL_String instanceName = InstanceName() + "_pulldown";
        parentItem->_xwidget = XmCreatePulldownMenu
            (gpWidget, (char*) instanceName.AsPtr(), NULL, 0);
        parentw = parentItem->_xwidget;
        if (!parentItem->_xitemw)
            CL_Error::Fatal ("Menu::_CreateMenuItemVisual: internal error:"
                             " NULL _xitemw, item id %ld\n",
                             parentItem->_id);
        XtVaSetValues (parentw, XmNinsertPosition, &OrderProc, NULL);
        XtVaSetValues (parentItem->_xitemw, XmNsubMenuId, parentw,  NULL);
    }


    struct _WidgetClassRec* wclass = NULL;
    if ( !node.IsLeaf () ) {
        if (parent) {
            // This is not the root. The root's handle is set by the
            // MakeVisualElement method that is calling us.
            CL_String instanceName = itm->InstanceName();
            itm->_xwidget = XmCreatePulldownMenu
                (parentw, (char*) (instanceName + "_pulldown").AsPtr(),
                 NULL, 0);
            // Under Motif, the menu bar's buttons must be cascade buttons,
            // and the rest must be push buttons:
            wclass = xmCascadeButtonGadgetClass;
            itm->_xitemw = XtCreateManagedWidget
                ((instanceName + "_button").AsPtr(), wclass, parentw, NULL, 0);
            XtVaSetValues (itm->_xwidget, XmNinsertPosition, &OrderProc, NULL);
            XtVaSetValues (itm->_xitemw, XmNsubMenuId, itm->_xwidget,  NULL);
            itm->SetLabel ();
        }
    }
    else {
        CL_String instance_name = itm->InstanceName();
        char* label    = (char *) instance_name.AsPtr ();
        UI_MenuItem* root_item = (UI_MenuItem *)  
                                  _menuTree.Node (ROOT_ID)->Content();
        UI_MenuItem* parent_item = (UI_MenuItem *) parent->Content ();

        if (CL_String (UIMenu_Separator) != itm->_title) {
//             if (IsMenuBar (_xwidget))
//                 wclass = (parent_item == root_item
//                           ? xmCascadeButtonWidgetClass
//                           : xmToggleButtonWidgetClass);
//             else
//                 wclass = (itm->_checkState == NotCheckable)
//                     ? xmPushButtonWidgetClass
//                     : xmToggleButtonWidgetClass;
            wclass = (parent_item == root_item)
                      ? xmCascadeButtonWidgetClass
                      : ((itm->_checkState == UI_MenuItem::NotCheckable)
                         ? xmPushButtonWidgetClass
                         : xmToggleButtonWidgetClass);
        }
        else
            wclass = xmSeparatorWidgetClass;
        parentw = (parent_item == root_item ? _xwidget : parentw);

        if ( parent_item == root_item ) {
            itm->_xitemw = XtVaCreateManagedWidget
                (label, wclass, parentw,  NULL);
                itm->SetLabel ();
        }
        else {
            itm->_xitemw = XtCreateManagedWidget
                (label, wclass, parentw, NULL, 0);
                itm->SetLabel ();
        }
    }
    if (wclass == xmPushButtonWidgetClass
        || wclass == xmToggleButtonWidgetClass) {
        XtAddCallback (itm->_xitemw, XmNarmCallback, 
                       &(UI_MenuItem::GetFocusCallback), itm);
        XtAddCallback (itm->_xitemw, XmNdisarmCallback, 
                       &(UI_MenuItem::LoseFocusCallback), itm);

        if (wclass == xmToggleButtonWidgetClass) {
            // It's a checkable item
            XtVaSetValues (itm->_xitemw, XmNindicatorOn, TRUE, NULL);
            XtAddCallback (itm->_xitemw, XmNvalueChangedCallback, 
                           &(UI_MenuItem::SelectionCallback), itm);
        }
        else // It's not a checkable item
            XtAddCallback (itm->_xitemw, XmNactivateCallback, 
                           &(UI_MenuItem::SelectionCallback), itm);
    }
    else if (wclass == xmCascadeButtonWidgetClass)  {
        XtAddCallback (itm->_xitemw, XmNcascadingCallback, 
                       &(UI_MenuItem::GetFocusCallback), itm);
        XtAddCallback (itm->_xitemw, XmNactivateCallback, 
                       &(UI_MenuItem::GetFocusCallback), itm);
        XtAddCallback (itm->_xitemw, XmNactivateCallback, 
                       &(UI_MenuItem::SelectionCallback), itm);
    }
    return TRUE;
}
#endif



bool UI_Menu::HandleEvent (UI_Event* e)
{
    if (e->Type() == Event_LoseFocus)
        _focusItem = NULL;
    return ProcessEvent (e);
}


    
bool UI_Menu::MakeVisualElement ()
{
    return UI_VisualObject::MakeVisualElement ();
}

bool UI_Menu::DestroyVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    // We need to walk the tree and destroy the menu items explicitly here;
    // Under MS-Windows, this is 
    // because menu items are not registered with the Controller.
    CL_IntegerTreePostWalker walker (_menuTree.Root());
    for (walker.Reset(); walker.More(); ) {
        UI_MenuItem* m = (UI_MenuItem*) walker.Next()->Content();
        m->DestroyVisualElement();
        delete m;
    }
#elif defined(__OS2__)
    // Non-leaf menu items will be destroyed by the Controller, but we do
    // need to destroy the menu bar or popup menu and the leaf items.
    CL_IntegerTreeNode* root = _menuTree.Root();
    CL_IntegerTreePostWalker walker (root);
    for (walker.Reset(); walker.More(); ) {
        CL_IntegerTreeNode* node = walker.Next();
        if (node->IsLeaf()) {
            UI_MenuItem* m = (UI_MenuItem*) node->Content();
            m->DestroyVisualElement();
            delete m;
        }
    }
    if (!root->IsLeaf()) {
        UI_MenuItem* m = (UI_MenuItem*) root->Content();
        m->DestroyVisualElement();
        delete m;
    }
    WinDestroyWindow (_handle);

#elif defined(__X_MOTIF__)
    CL_IntegerTreePostWalker walker (_menuTree.Root());
    for (walker.Reset(); walker.More(); ) {
        UI_MenuItem* m = (UI_MenuItem*) walker.Next()->Content();
        m->Destroy();
        delete m;
    }
    if (_xwidget)
        XtDestroyWidget (_xwidget);
#endif
    return FALSE;
}


UI_Menu::~UI_Menu()
{
}


bool UI_Menu::_FontChanged ()
{
    // Override the inherited method with one that does nothing.
    return TRUE;
}


bool UI_Menu::PropagateFontChange (UI_VisualObject*)
{
    // Override the inherited method with one that does nothing.
    return TRUE;
}

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
void UI_Menu::MoveFocusTo (UI_MenuItem* itm)
{
    if (_focusItem != itm)
        _focusItem = itm;
}
#endif



bool UI_Menu::_DoRemove (CL_IntegerTreeNode* node)
{
    if (!node)
        return FALSE;
    _focusItem = NULL;
    UI_MenuItem* itm = (UI_MenuItem*) node->Content();
    if (!itm)
        return FALSE;
    UI_ViewID id = itm ->ViewID();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (node == _menuTree.Root())
        return TRUE; // Do nothing
    DeleteMenu (itm->_parentHandle,  node->IndexInParent(), MF_BYPOSITION);
    DrawMenuBar (Parent()->ViewHandle());
    CL_IntegerTreePostWalker walker (_menuTree.Node (id));
    while (walker.More()) {
        CL_IntegerTreeNode* node = walker.Next();
        UI_MenuItem* itm = (UI_MenuItem*) node->Content();
        if (itm) {
            itm->Finalize ();
            itm->_PrivateFinalize ();
            itm->DestroyVisualElement();
            delete itm;
            node->Content() = NULL; // Better safe than sorry
        }
    }
    _menuTree.DestroySubtree (id);
    // Don't use Application->Destroy because, under Windows, menu items are
    // not registered with the Controller.

#elif defined(__X_MOTIF__)
    CL_IntegerTreePostWalker walker (_menuTree.Node (id));
    while (walker.More()) {
        CL_IntegerTreeNode* node = walker.Next();
        UI_MenuItem* itm = (UI_MenuItem*) node->Content();
        itm->Destroy();
        delete itm;
    }
    _menuTree.DestroySubtree (id);
#elif defined(__OS2__)
    WinSendMsg (itm->_parentHandle, MM_DELETEITEM, MPFROM2SHORT (id, TRUE),
                0);
    CL_IntegerTreePostWalker walker (_menuTree.Node (id));
    while (walker.More()) {
        // Under OS/2, leaves are not registered
        CL_IntegerTreeNode* node = walker.Next();
        UI_MenuItem* itm = (UI_MenuItem*) node->Content();
        if (itm) {
            if (node->IsLeaf()) {
                itm->Finalize ();
                itm->_PrivateFinalize ();
                itm->DestroyVisualElement();
                delete itm;
                node->Content() = 0; // Better safe than sorry
            }
            else
                _Application->Destroy (itm);
        }
    }
    _menuTree.DestroySubtree (id);
#endif
    return TRUE;
}


UI_ViewID UI_Menu::_AllocateSeparatorId()
{
    // Look through the menu tree for the first unused id above 32000, and
    // return it.
    long i = 32000;
    while (_menuTree.Node(i))
        i++;
    return i;
}



// ----------------- UI_MenuBar methods -------------------------

UI_MenuBar::UI_MenuBar (UI_CompositeVObject* parent,
                        UI_MenuItemDescriptor* item)
: UI_Menu (parent, item)
{
#if defined(__OS2__)
    _style = MS_ACTIONBAR | WS_VISIBLE;
#endif
    parent->SetMenuBar (this);
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_MenuBar::UI_MenuBar (UI_CompositeVObject* parent, const char* resName)
: UI_Menu (parent, NULL), _resource (resName)
{
    CL_IntegerTreeNode* root =  _menuTree.Node (ROOT_ID);
    UI_MenuItem* root_item = (UI_MenuItem*) root->Content();
    root_item->_handle = LoadMenu (_Application->ProcessId(),
                                   _resource.AsPtr());
    if (!root_item->_handle) {
        CL_String s;
        s.AssignWithFormat ("UI_MenuBar constructor: resource '%s': "
                            "LoadMenu failed ", resName);
        s += _Application->ErrorString();
        CL_Error::Fatal (s.AsPtr());
        return;
    }
    _BuildFromResource (root);
    _handle = root_item->_handle;
    parent->SetMenuBar (this);
}
#endif




#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

void UI_MenuBar::_BuildFromResource (CL_IntegerTreeNode* node)
{
    UI_MenuItem* item = node ? ((UI_MenuItem*) node->Content()) : 0;
    UI_ViewHandle h   = item ? item->_handle : 0;
    if (h == 0)
        return;
    short n = GetMenuItemCount (h);
    if (n <= 0)
        return;
    CL_ByteString label (50);
    for (short i = 0; i < n; i++) {
        UI_ViewID id         = GetMenuItemID (h, i);
        if (id == 0)    // It's a separator
            continue;   // Don't add separators into the menu tree for
                        // resource-based menus
        UI_ViewHandle handle = GetSubMenu    (h, i);
        short length = GetMenuString (h, i, (char*) label.AsPtr(),
                                      label.Size(), MF_BYPOSITION);
        (label.AsPtr())[length] = '\0'; // Dirty hack, since the ByteString's
                                        // op[] does not give an lvalue.
        if ((short) id == -1) {
            // Windows gives us an id of -1 for non-leaf items. So we just
            // use the handle as id. 
            id = (UI_ViewID) handle;
        }
        UI_MenuItem* itm = new UI_MenuItem
            (this, (const char*) label.AsPtr(), id);
        if (!itm)
            return; // No memory
        itm->_handle = handle;
        itm->_parentHandle = h;
        CL_IntegerTreeNode* child = _menuTree.AddChild (id, item->_id);
        if (child) {
            child->Content() = (long) itm;
            _BuildFromResource (child);
        }
    }
}
#endif

bool UI_MenuBar::MakeVisualElement ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_resource.Size() > 0) {
        // If resource.Size > 0, the visual element is created (via
        // resource) by the constructor.
        ((UI_CompositeVObject*) _parent)->MenuBarCreated ();
        // We know that a MenuBar's parent must be a Composite, so we can
        // cast down.
        return TRUE;
    }
    CL_IntegerTreeNode* root =  _menuTree.Node (ROOT_ID);
    UI_MenuItem* root_item = (UI_MenuItem*) root->Content();
    root_item->_handle = CreateMenu ();
    _handle = root_item->_handle;
#elif defined(__OS2__)
    _id = FID_MENU;
    HWND frame = WinQueryWindow (_parent->ViewHandle(), QW_PARENT);
    WinSendMsg (frame, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0);
    _handle = WinCreateWindow
        (frame, WC_MENU, "", _style,
         0, 0, 0, 0, frame, HWND_TOP, _id, NULL, NULL);
    CL_IntegerTreeNode* root =  _menuTree.Node (ROOT_ID);
    UI_MenuItem* root_item = (UI_MenuItem*) root->Content();
    root_item->_handle = _handle;
    ((UI_CompositeVObject*) _parent)->MenuBarCreated ();
    // We know that a MenuBar's parent must be a Composite, so we can cast
    // down.
#elif defined (__X_MOTIF__)
    UI_MenuItem* root_item = (UI_MenuItem*)
        _menuTree.Node (ROOT_ID)->Content();
    
    root_item->_xwidget = XmCreateMenuBar
        (XtParent (_parent->ViewHandle()), (char*) InstanceName().AsPtr(),
         NULL, 0);
    root_item->_xitemw = 0;
    _xwidget = root_item->_xwidget;
    ((UI_CompositeVObject*) _parent)->MenuBarCreated ();
#endif
    CL_IntegerTreePreWalker walk (_menuTree.Root());
    while (walk.More()) {
        CL_IntegerTreeNode* node = walk.Next();
        _CreateMenuItemVisual (*node);
    }
    _created = TRUE;
#if defined(__OS2__)
    WinSendMsg (frame, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0);
#elif defined(__X_MOTIF__)
    Widget w = _parent->ViewHandle();
    while (w && !XtIsSubclass (w, xmMainWindowWidgetClass))
        w = XtParent (w);
    if (w)
        XtVaSetValues (w, XmNmenuBar, _xwidget, NULL);
    XtManageChild (root_item->_xwidget);
    _Controller->RealizeWidget (root_item->_xwidget);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    ((UI_CompositeVObject*) _parent)->MenuBarCreated ();
    // We know that a MenuBar's parent must be a Composite, so we can
    // cast down.
    DrawMenuBar (_parent->ViewHandle());
#endif
    return TRUE;
}


bool UI_MenuBar::Add (UI_ViewID id, const char* label,
                      UI_ViewID parent_id, short rank)
{
    bool b = UI_Menu::Add (id, label, parent_id, rank);
#if defined(__OS2__)
    HWND frame = WinQueryWindow (_parent->ViewHandle(), QW_PARENT);
    WinSendMsg (frame, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0);
#endif
    return b;
}



// ---------------------------- UI_PopupMenu methods ---------------------

UI_PopupMenu::UI_PopupMenu (UI_CompositeVObject* parent,
                            UI_MenuItemDescriptor* item)
: UI_Menu (parent, item)
{
    _visible = FALSE; // Initially invisible
}


UI_PopupMenu::~UI_PopupMenu ()
{
}



bool UI_PopupMenu::MakeVisualElement ()
{
    UI_MenuItem* root_item = (UI_MenuItem*)
        _menuTree.Node (ROOT_ID)->Content();
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    root_item->_handle = CreatePopupMenu ();
    _handle = root_item->_handle;
#elif defined(__OS2__)
    _style = WS_VISIBLE;
    UI_ViewHandle parentHandle = _parent->ViewHandle();
    _handle = WinCreateWindow
        (parentHandle, WC_MENU, "", _style,
         0, 0, 0, 0, parentHandle, HWND_TOP, _id, NULL, NULL);
    root_item->_handle = _handle;
#elif defined (__X_MOTIF__)
    root_item->_visible = FALSE;
    _CurrentWidgetRank = 0; // Stupid hack
    root_item->_xwidget = XmCreatePopupMenu
        ((Widget)_parent->ViewHandle (), (char*) InstanceName().AsPtr(),
         NULL, 0); 
    root_item->_xitemw = 0;
    _xwidget = root_item->_xwidget;
    _Controller->RealizeWidget (root_item->_xwidget);
#endif
    CL_IntegerTreePreWalker walk (_menuTree.Root());
    while (walk.More()) {
        CL_IntegerTreeNode* node = walk.Next();
        _CreateMenuItemVisual (*node);
    }
    _created = TRUE;
    return TRUE;
}

bool UI_PopupMenu::ShowAt (const UI_Point& p)
{
    UI_ViewHandle parentHandle = _parent->ViewHandle();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_Point q = p + _parent->Shape().Origin();
    return TrackPopupMenu (_handle, TPM_LEFTALIGN, q.XCoord(), q.YCoord(), 0,
                           parentHandle, NULL);

#elif defined(__OS2__)
    UI_Point q = p; // + _parent->Shape().Origin();
    WinPopupMenu (parentHandle, parentHandle, _handle, q.XCoord(),
                  _YACLWindowHeight (parentHandle) - q.YCoord() - 1,
                  0, PU_MOUSEBUTTON2 | PU_KEYBOARD | PU_MOUSEBUTTON1);
    return TRUE;
#elif defined(__X_MOTIF__)
    Position x, y;
    XtTranslateCoords (parentHandle, p.XCoord(), p.YCoord(), &x, &y);
    XtVaSetValues (_xwidget, XtNx, x, XtNy, y, NULL);
    XtManageChild (_xwidget); // Display the popup menu
    return TRUE;
#endif
}


