

#ifndef _maskedbitmap_h_ /* Wed Mar 27 12:51:01 1995 */
#define _maskedbitmap_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/bitmap.h"

class UI_DrawingSurface;

class YACL_UI UI_MaskedBitmap: public UI_Bitmap {
    
public:
    
    UI_MaskedBitmap (bool invertBackground = FALSE);

    UI_MaskedBitmap (const char* name, UI_DrawingSurface* s = NULL,
                     bool invertBackground = FALSE);
    // Creates a Bitmap from the given file name.

    UI_MaskedBitmap (const UI_BitmapData& bi, UI_DrawingSurface* s,
                     uchar *andMask, bool invertBackground = FALSE);
    
    ~UI_MaskedBitmap ();

    bool DrawOn (UI_DrawingSurface& s,
                 const UI_Point& p = UI_Point (0, 0)) const;
    
protected:

    uchar*    _andMask;
    bool      _invertBg;     
};



#endif /* _maskedbitmap_h_ */

