



#ifndef _lineseg_h_ /* Sat Oct 29 09:53:51 1994 */
#define _lineseg_h_




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma interface
#endif

// A LineSegment represents a line drawn between two points. LineSegment is
// derived from GraphicObject, and overrides some inherited methods.
//
// Like the other GraphicObjects, the Ellipse views its co-ordinate space as
// an abstract space not tied to any particular device. But its {\tt DrawOn}
// and {\tt Fill} methods view its dimension units as pixels.

#include "ui/point.h"

class YACL_UI UI_LineSegment: public  UI_GraphicObject {

public:
    UI_LineSegment (const UI_Point& p1, const UI_Point& p2);
    // Construct a LineSegment that has the two given points as end points.

    UI_LineSegment (const UI_Point& start, double slope, long length);
    // Construct a LineSegment with the given starting point, slope and
    // length.

    UI_LineSegment ();
    // Default constructor: construct a LineSegment with both end points at
    // the origin.

    UI_LineSegment (const UI_LineSegment& l) {*this = l;};
    // Copy constructor.

    UI_LineSegment& operator= (const UI_LineSegment& o);
    // Assign {\tt o} to this LineSegment.

    bool Intersects (const UI_LineSegment& l) const;
    // Tell whether the given line segment intersects this one.

    void operator= (const CL_Object& o);
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point(0,0)) const;
    // Draw the line segment on the surface {\tt sfc}, translated so that
    // {\tt p} is treated as the origin of the co-ordinate system.

    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Make {\tt p1} and {\tt p2} the end points of this LineSegment.

    bool MoveTo (const UI_Point& p);
    // Move this LineSegment so that the given point is the new center.
    
    bool OnBoundary (const UI_Point& p) const;
    // Return TRUE if {\tt p} is on this LineSegment,  between the two end
    // points, or if {\tt p} equals one of the end points.

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic. This method
    // always returns either Outside or Boundary, never Inside, because
    // there is no ``inside'' of a line segment.
    
    UI_PointPair EndPoints () const;
    // Return the two end points of this LineSegment.

    UI_PointPair PointsAtDistance (const UI_Point &, long) const;

    UI_Point Center () const;
    // Return the mid-point of this LineSegment.

    double Slope () const;
    // Return the slope of the line of which this LineSegment is part.
    
    bool Includes (const UI_Point& p) const {return OnBoundary (p);}
    // Includes is the same as OnBoundary, because this is a line.

    bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Return TRUE if this line segment intersects the periphery of {\tt r}.
    
    bool IsContainedIn (const UI_Rectangle& r) const;
    // Return TRUE if this LineSegment is contained entirely within {\tt r}.

    UI_Rectangle BoundingRectangle() const;
    // Return the bounding rectangle of  this LineSegment.

    UI_LineSegment operator+  (const UI_Vector&) const;
    // Return the LineSegment obtained by translating this LineSegment by the
    // given vector.

    virtual void operator+= (const UI_Vector& p)
        {*this = *this + p; /* Operator= does the notification */};

    const char* ClassName () const {return "UI_LineSegment";};

    CL_Object* Clone () const {return new UI_LineSegment (*this);}
    
protected:
    UI_Point _p1, _p2;

};



#endif /* _lineseg_h_ */
