
#ifndef _interval_h_
#define _interval_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/uidefs.h"     // Include this first.


#include "base/map.h"
#include "base/binding.h"


//  The Interval represents a range of integers, including both
//  endpoints (i.e., a ``closed'' interval). It is used as model for
//  scroll bars, and includes support for dependent notification. The
//  implementation uses {\tt long} values for the two ends of the range.


class YACL_UI CL_Interval: public CL_Object {

public:

    CL_Interval (long from, long to);
    // Construct an interval of the given range.

    CL_Interval ();
    // Construct an interval from $-1$ to $-1$.

    CL_Interval (const CL_Interval&);
    // Copy constructor.

    ~CL_Interval () {};

    long Low () const {return _low;};
    // Return the low value of the interval.

    void Low (long value);
    // Set the low value of the interval. If the given value exceeds our
    // high value, the low value will be set to our high value.

    long High () const {return _hi;};
    // Return the high value of the interval.

    void High (long value);
    // Set the high value of the interval. If the given value is less than our
    // low value, the high value will be set to our low value.

    long Length () const {return High() - Low() + 1;};
    // Return the length of the interval, including both end points.

    bool operator== (const CL_Object& ) const;
    // Override the operator inherited from {\small\tt CL_Object}.
    
    virtual void operator= (const CL_Interval&);
    // Assign the given interval to this one.

    CL_Interval operator+ (long n) const;
    // Return an Interval obtained by ``shifting'' the values of this
    // interval up by $n$, i.e., adding $n$ to both the low and high values.

    virtual void operator+= (long n) {*this = *this + n;};
    // Apply {\tt operator+ (n)} to this object.

    CL_Interval operator- (long n) const;
    // Return an Interval obtained by ``shifting'' the values of this
    // interval down by $n$, i.e., subtracting $n$ from both the low and
    // high values.

    virtual void operator-= (long n) {*this = *this - n;};
    // Apply {\tt operator- (n)} to this object.

    
    void operator= (const CL_Object& o)
        {*this = (const CL_Interval&) o;};
    // Assign {\tt o} to this object after casting it down to an Interval.
    // This method overrides the  one defined in Object.

    CL_Object* Clone () const;
    // Return a copy of this Interval. The caller is responsible for
    // destroying the copy.

    const char* ClassName() const {return "CL_Interval";};

    CL_String AsString () const;
    // Return a String representation of this Interval, e.g., in the form
    // {\tt (33, 72)}.    

protected:

    long _low;
    long _hi;
};



inline CL_Object* CL_Interval::Clone () const
{
    return new CL_Interval (*this);
}

    

#endif

