


LIBRARY = $(YACLLIB)/lib$(UI).a
STATLIB = $(LIBRARY)
UI_SO   = $(YACLPATH)/lib/$(YACLPLATFORM)/libui.so

LIBRARY_SO = $(UI_SO)

include $(YACLPATH)/control/gnuc.ctl



OBJECTS =    \
3dlabel.o     \
applic.o      \
arc.o         \
bitmap.o      \
brush.o       \
bmpbtn.o      \
bmpushbn.o    \
bmtglbtn.o    \
btngroup.o    \
canvas.o      \
chord.o       \
cntroler.o    \
color.o       \
combobox.o    \
composit.o    \
containr.o    \
cursor.o      \
dateedit.o    \
dialog.o      \
dsplrsrc.o    \
dsinmem.o     \
dsplsurf.o    \
dwgsurf.o     \
ellipse.o     \
event.o       \
font.o        \
fontdesc.o    \
graphic.o     \
grutils.o     \
interval.o    \
label.o       \
lineseg.o     \
mainprog.o    \
menu.o        \
monthcal.o    \
numedit.o     \
pen.o         \
piewedge.o    \
point.o       \
pswdedit.o    \
pushbtn.o     \
orbtngrp.o    \
rectangl.o    \
scrolbar.o    \
scrolwin.o    \
shadolin.o    \
shadorec.o    \
shadotrg.o    \
simple.o      \
stddlg.o      \
stencil.o     \
stred.o       \
strseq.o      \
strview.o     \
textedit.o    \
timer.o       \
toglbtn.o     \
vector.o      \
visualob.o    \
vobjcoll.o    \
xrbtngrp.o    \
xrtglbtn.o    \
xmotfevt.o


STATIC_OBJS = statui.o

include support/$(WIDGET_SET)/objlist.ctl


all: $(LIBRARY)  $(BUILD_SHARED_UI)



$(LIBRARY): $(OBJECTS) $(STATIC_OBJS) $(PLATFORM_OBJECTS)
	ar r $(LIBRARY) $(OBJECTS) $(STATIC_OBJS) $(PLATFORM_OBJECTS)
	$(RANLIB) $(LIBRARY)



build_shared_ui: $(OBJECTS) $(STATIC_OBJS)
	rm -rf $(UI_SO)
	$(BUILD_SO_CMD)  -L$(YACLLIB) -o $(UI_SO) $(OBJECTS) \
         $(PLATFORM_OBJECTS) $(STATIC_OBJS)

        
$(STATIC_OBJS): statui.cxx


stddlg.o: support/$(WIDGET_SET)/stddlg.cxx
	$(CC) $(CCOPTS) $(PIC) support/$(WIDGET_SET)/stddlg.cxx
        



#
# Dependencies for x_motif:
#        
mocobox.o: support/x_motif/mocobox.c
	$(CC) $(CCOPTS) $(PIC) support/x_motif/mocobox.c

ycomp.o: support/x_motif/ycomp.c
	$(CC) $(CCOPTS) $(PIC) support/x_motif/ycomp.c




#
# Dependencies for x_yacl:
#        
window.o:   support/x_yacl/window.cxx
	$(CC) $(CCOPTS) $(PIC) support/x_yacl/window.cxx
        


.SUFFIXES:

.SUFFIXES: .cxx .c .o .a


.c.o:
	gcc $(CCOPTS) $(PIC) -D$(WIDGET_SYMBOL) $*.c


.cxx.o:
	$(CC) $(CCOPTS) $(PIC)  $*.cxx
        

clean:
	-rm -f *.o  $(LIBRARY) $(UI_SO)
