

#ifndef _fontdesc_h_ /* Thu Dec 29 10:03:04 1994 */
#define _fontdesc_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/uidefs.h"     // Include this first.

#include "base/string.h"

// A FontDesc object is a ``font descriptor'' that an application program
// can use to describe a font. FontDesc instances are typically used to
// assign to the return value of the VisualObject's or DrawingSurface's {\tt
// Font()}  method.
//
// The platform does not guarantee that a font
// described by a FontDesc exists. An application can use the Font class'
// {\tt AvailableFonts} method to determine what fonts are available.


//[ Global
enum UIFont_Style {UIFont_Italic    = 1,
                   UIFont_Underline = 2,
                   UIFont_BoldFace  = 4,
                   UIFont_StrikeOut = 8
               };
// The elements of this enumeration are bitwise-{\sc or}'ed to represent the
// style parameters for a particular font.
//] Global


class YACL_UI UI_FontDesc: public CL_Object {

public:

    UI_FontDesc (const char* type_face, short point_size = 10,
                 ulong style_enum = 0);
    // Construct a FontDesc with the given type face name, point size and
    // style. The third parameter is a disjunction of {\tt UIFont_Style}
    // values.

    UI_FontDesc ();
    // Default constructor: build a FontDesc with a default font.
    
    ~UI_FontDesc () {};
    // Destructor.
    
    short Compare (const CL_Object&) const;
    // Override the {\tt Compare} method inherited from Object.

    short Compare (const UI_FontDesc&) const;
    // Provide a means for comparing FontDesc objects. This method is needed
    // because the FontDesc class is used as template parameter for
    // instanting a Sequence of FontDesc objects, which is used by Font's
    // {\tt AvailableFonts} method.
    //
    // The implementation of this method uses the type face name, point size
    // and style as primary, secondary and tertiary keys for comparing
    // FontDesc objects.

    void operator= (const CL_Object&);
    // Assignment operator.

    UI_FontDesc& operator= (const UI_FontDesc&);
    // Assign the given FontDesc to this object.

    short PointSize() const    {return _ptSize;};
    // Return this FontDesc's point size.

    CL_String TypeFace() const {return _typeFace;};
    // Return the name of the type face.

    ulong Style () const   {return _style;};
    // Return the style parameters of this FontDesc.

protected:
    short             _ptSize;
    CL_String         _typeFace;
    short             _style;


};


// The FontInfo class represents a font that is available in the platform
// window system. FontInfo is derived from FontDesc class to include
// platform-specific information.

class YACL_UI UI_FontInfo: public UI_FontDesc {

public:
    UI_FontInfo ();
    // Default constructor.
    
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    bool IsFixedWidth() const {return _fixedWidth;};
    // [X-windows-specific] Return TRUE if this FontInfo refers to a
    // fixed-width font.

    CL_String XFontName () const {return _realName;};
    // [X-windows-specific] Return the fully-qualified name of this font
    // in the X convention.
    
#endif

    bool IsScalable () const {return _scalable;};
    // Return TRUE if this is a scalable font (one that is available at
    // arbitrary point sizes).
    
    short Compare (const CL_Object&) const;
    // Cast the parameter down to a FontInfo and invoke the type-specicif
    // {\tt Compare} method.

    short Compare (const UI_FontInfo&) const;
    // Return $-1$, 0 or $+1$ according to whether this object is less
    // than, equal to or greater than the parameter. The method uses the
    // type face name, point size and style as primary, secondary and
    // tertiary keys for comparing FontInfo objects.

    void operator= (const CL_Object&);

    UI_FontInfo& operator= (const UI_FontInfo&);

    CL_String AsString () const;
    // Return a String representation of this object.
    

protected:
    UI_FontInfo (const char* type_face, short point_size = 10,
                 ulong style_enum = 0, bool = FALSE);
    // Under Windows, the last parameter is TRUE for TrueType fonts; under
    // X, it is TRUE for proportional fonts.
    
    bool              _scalable;
    
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    bool              _fixedWidth;
    CL_String         _realName;
#endif

    friend class UI_Font;
};

#endif /* _fontdesc_h_ */
