

#ifndef _event_h_
#define _event_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




/*
  Authors:   M. A. Sridhar
             N. Bhowmik
*/

// This  class represents a YACL event.  An  event is
// characterized  by  its  origin, type  and  destination,  the  origin and
// destination being any VisualObject.  When the window system sends an
// event to a particular VisualObject {\tt v}, the Controller creates an
// Event instance with both origin and destination set to {\tt v} and
// dispatches the event to {\tt v}. If {\tt v}'s event handler returns
// FALSE, the Controller dispatches the event up the view tree until one of
// the event handlers returns TRUE.
//
// An Event can be either {\it hard\/} or {\it soft}. A hard event is any
// event  captured from the underlying
// system, i.e., one that represents a physical event such as mouse movement
// or keyboard input.  A
// soft event is  a conceptual event such as creation of the visual
// element for a VisualObject.  An  Event instance
// contains additional information like the point of occurrence, key pressed
// (if any), and the like.
// 
// The Event class includes an instance variable {\tt _nativeEvent}, which is a
// pointer to the platform-specific event (an {\tt MSG} under Windows, a
// {\tt QMSG} under OS/2 or an
// {\tt XEvent} under X) which was translated to this high-level event. The
// {\tt NativeEvent} method can be used for platform-dependent processing if
// necessary.


#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/rectangl.h"

class YACL_UI UI_VisualObject;

//[ Global
enum UI_EventCategory {Event_Hard,Event_Soft};
enum UI_EventType { // All these are sent from the controller.
    Event_None = 0,

    /* --------------------- Hard Events ----------------------- */
    Event_MouseMove,            /* ------------- Mouse events ----------- */
    Event_LButtonPress,
    Event_MButtonPress,       
    Event_RButtonPress,     
    Event_LButtonRelease,   
    Event_MButtonRelease,   
    Event_RButtonRelease,   
    Event_LButtonDblClk,
    Event_MButtonDblClk,       
    Event_RButtonDblClk,
    
                              /* ------------- Scrolling events ----- */
    Event_Scroll,             // Continuous scroll
    Event_FinishScroll,       // End of continuous scroll
    Event_ScrollToBegin,      // Scroll to the beginning of the interval
    Event_ScrollToEnd,        // Scroll to the end of the interval
    Event_ScrollForwardLine,
    Event_ScrollBackwardLine,
    Event_ScrollForwardPage,
    Event_ScrollBackwardPage,
    Event_ScrollToPosition,   /* For this event, the param field contains */
                              /*  the position to scroll to */
    
    Event_KeyTyped,                 // -------------  Keyboard events -----
    Event_KeyDown,
    Event_KeyUp,
    
                              /* --------------- View events ----------- */
    Event_GetFocus,          
    Event_LoseFocus,         
    Event_Paint,              // View is exposed: needs painting
    Event_GraphicsExpose,
    Event_Reconfigure,        /* View is moved or resized: curPos contains */
                              /* the new shape rectangle */
    Event_ViewEnter,          // Mouse enters this view
    Event_ViewLeave,          // Mouse leaves this view
    Event_Iconify,
    Event_Deiconify,

    // ------------------------ Soft Events ---------------------

    Event_FirstSoftEvent,     // Used only for deciding event category
                              /* New soft events must be added AFTER this! */
    Event_ChildCreated,       // A SimpleVObject creation event.
    Event_CloseDown,          // Close down a VisualObject if it is ready
    Event_MakeInterface,      // 
    Event_Quit,               // Unequivocal destroy. 
    Event_Select,             /* The recipient of the event has changed in
                                 some way; e.g., the recipient is a
                                 button, and it has been clicked, or it is a
                                 menu item that has been selected */
    Event_StrEdChanged,       // User typed a key in a StringEditor
    Event_Other
        
};
//] Global





class YACL_UI UI_Event: public CL_Object {

public:

    UI_Event (UI_EventType type,UI_VisualObject* origin,
              UI_VisualObject* dest = NULL,
              NativeEventStruct* nativeEvent = NULL);
    // Constructor. If {\tt dest == NULL}, it is set to {\tt origin}.
    
    UI_Event (const UI_Event&);

    ~UI_Event ();

    UI_VisualObject* Origin () const {return _origin;};
    // Return the originator of the event, i.e., the VisualObject at which
    // the Event was initially targeted.

    UI_VisualObject* Destination () const {return _dest;};
    // Return the destination of the event. The destination is either the
    // same as the origin or an ancestor of the origin in the view tree.

    UI_EventType Type () const {return _type;};
    // Return the type of the event.

    UI_EventCategory Category () const {return _category;};
  
    void operator= (const UI_Event& e);
    // Assign the given event {\tt e} to this one. This method makes a copy
    // of {\tt e}'s native event structure.

    void operator= (const CL_Object& o)
        {*this = (const UI_Event&) o;};
    // Cast {\tt o} down to an Event and perform assignment.


    NativeEventStruct* NativeEvent() { return _nativeEvent;};
    // Return a pointer to the platform event that caused this YACL event. The
    // method returns NULL if this event was not caused by a platform event.

    const UI_Point& Position () const {return curPos.Origin();};
    // Position at which this event occurred, if relevant.

    void SetPosition (const UI_Point& pos);
    
    const UI_Rectangle& Shape () const {return curPos;};
    // ``Shape'' relevant only for Reconfigure events.

    short Key () const {return key;};
    // The keyboard key that caused this event, if any.

    bool  ShiftKeyPressed () const {return _shiftKey;};
    // Was the shift key pressed when this event occurred?

    bool  CtrlKeyPressed () const {return _ctrlKey;};
    // Was the control key pressed when this event occurred?

    bool  MetaKeyPressed () const {return _metaKey;};
    // Was the meta (alt) key pressed when this event occurred?

    long&  ScrollAmount () {return param;};
    // Return the scroll amount, if this was a scroll event.

    CL_String AsString () const;
    
protected:
    
    //
    //-------------------Attributes-------------------
    //

    UI_Rectangle   curPos;    // Position of the event. The meaning of
                              // this inst var depends on the kind of
                              // event.
    ulong          duration;
    short          key;       // ASCII value of key pressed if any
    long           param;     // Additional info if any
    bool           _shiftKey; // Was the shift key pressed?
    bool           _metaKey;  // Was the meta (alt) key pressed?
    bool           _ctrlKey;  // Was the control key pressed?
    
    UI_VisualObject*   _origin;    // View where event occured 
    UI_VisualObject*   _dest;      // View for whom event is intended
    UI_EventType       _type;
    UI_EventCategory   _category;
    NativeEventStruct* _nativeEvent; // Pointer to actual event structure
                                     // received from underlying system

    friend class YACL_UI UI_Controller;
};

#endif
