




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/event.h"
#include "ui/rectangl.h"
#include "ui/visualob.h"

UI_Event::UI_Event(UI_EventType t, UI_VisualObject* tg,
                   UI_VisualObject* cl, NativeEventStruct* native)
{
    _type = t;
    _origin = tg;
    if (cl == NULL)
        _dest = _origin;
    else
        _dest = cl;
    // Now assign category
    if(_type < Event_FirstSoftEvent)
        _category = Event_Hard;
    else
        _category = Event_Soft;
    _nativeEvent = native;
    _shiftKey = FALSE;
    _ctrlKey  = FALSE;
    _metaKey  = FALSE;
}

UI_Event::UI_Event(const UI_Event& e)
{
    *this = e;
}

UI_Event::~UI_Event()
{
    if (_nativeEvent)
        delete _nativeEvent;
}


void UI_Event::operator= (const UI_Event& e)
{
    _origin = e._origin;
    _dest = e._dest;
    _type = e._type;
    _category = e._category;

    curPos = e.curPos;
    duration  = e.duration;
    key = e.key;
    param = e.param;

    _nativeEvent = new NativeEventStruct;
    if (_nativeEvent && e._nativeEvent)
        *(NativeEventStruct*) _nativeEvent = *(NativeEventStruct*)
            e._nativeEvent;
}
      


void UI_Event::SetPosition (const UI_Point& pos)
{
    curPos.Origin (pos);
}


static char* _EventType[] = {
"Event_None",
"Event_MouseMove",
"Event_LButtonPress",
"Event_MButtonPress",       
"Event_RButtonPress",     
"Event_LButtonRelease",   
"Event_MButtonRelease",   
"Event_RButtonRelease",   
"Event_LButtonDblClk",
"Event_MButtonDblClk",       
"Event_RButtonDblClk",
"Event_Scroll",
"Event_FinishScroll",
"Event_ScrollToBegin",
"Event_ScrollToEnd",
"Event_ScrollForwardLine",
"Event_ScrollBackwardLine",
"Event_ScrollForwardPage",
"Event_ScrollBackwardPage",
"Event_ScrollToPosition",
"Event_KeyTyped",
"Event_KeyDown",
"Event_KeyUp",
"Event_GetFocus",          
"Event_LoseFocus",         
"Event_Paint",
"Event_GraphicsExpose",
"Event_Reconfigure",
"Event_ViewEnter",
"Event_ViewLeave",
"Event_Iconify",
"Event_Deiconify",
"Event_FirstSoftEvent",
"Event_ChildCreated",
"Event_CloseDown",
"Event_MakeInterface",
"Event_Quit",
"Event_Select",
"Event_StrEdChanged",
"Event_Other"
};

CL_String UI_Event::AsString () const
{
    CL_String s;
    s.AssignWithFormat
        ("%s from id %d (%s) to id %d",
         _type >= Event_None && _type <= Event_Other ? _EventType[_type]
         : "Unknown type",
         _origin ? _origin->ViewID() : -1000,
         _origin ? _origin->ClassName() : "??",
         _dest ? _dest->ViewID() : -1000);
    if (_type == Event_Reconfigure)
        s += " shape " + curPos.AsString();
    else if (_type == Event_MouseMove)
        s += " position " + curPos.Origin().AsString();
    else if (_type == Event_Scroll)
        s += " amount " + CL_String (param);
    return s;
}
