#ifndef _dsplsurf_h_
#define _dsplsurf_h_

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



/*
   Authors:   M. A. Sridhar
              N. Bhowmik
*/

// DisplaySurface is derived from DrawingSurface, and encapsulates
// drawing capabilities on the visual element of a  VisualObject.  The
// VisualObject to which a DisplaySurface belongs is called the {\it
// client\/} of the DisplaySurface. The DisplaySurface inherits its abstract
// behavior from the DrawingSurface, and overrides appropriate methods to
// provide drawing facilities on a window.
// Each DisplaySurface object maintains default Font,
// Brush and Pen objects.
//
// The DisplaySurface is implemented using the platform's window-specific
// graphics facility (called the {\it device context\/} under MS Windows,
// the {\it graphics context\/} under X windows and the {\it presentation
// space\/} under OS/2). It is important that a
// DisplaySurface not be kept active for very long, because device contexts
// of window systems are usually expensive shared data structures.



#if defined(__GNUC__)
#pragma interface
#endif


#include "base/intseq.h"

#include "ui/uidefs.h"
#include "ui/dwgsurf.h"
#include "ui/stencil.h"

class YACL_UI UI_VisualObject;

class YACL_UI UI_DisplaySurface: public UI_DrawingSurface {


public:

    UI_VisualObject& Client () const;
    // Return a reference to this DisplaySurface's client.

    double HorzPixelsPerMM () const {return _horzPPM / 1000.0;};
    // Return the number of pixels per millimeter in the horizontal direction.

    double VertPixelsPerMM () const {return _vertPPM / 1000.0;};
    // Return the number of pixels per millimeter in the vertical direction.
    
    UI_Rectangle DrawingArea () const;
    // Return the drawing area rectangle in pixels.

    UI_Rectangle DrawingAreaInMM () const;
    // Return the drawing area rectangle in millimeters.

    // UI_ColorMap& ColorMap () const;
    

    // ------------------------ Graphic modes ----------------------
    //[ Local
    enum GraphicsMode {
        GMode_Clear = 0,     GMode_And,         GMode_AndReverse,
        GMode_Copy,          GMode_AndInverted, GMode_NoOp,
        GMode_Xor,           GMode_Or,          GMode_Nor,
        GMode_Equiv,         GMode_Invert,      GMode_OrReverse,
        GMode_CopyInverted,  GMode_OrInverted,  GMode_Nand,
        GMode_Set
    };
    // This enumeration lists the sixteen basic graphics modes supported by
    // the DisplaySurface. Of these, the ost frequently used ones are {\tt
    // GMode_Invert} and {\tt GMode_Xor}.
    //] Local
    
    virtual GraphicsMode Mode () const;
    // Return the current graphics mode.

    virtual void Mode (GraphicsMode mode);
    // Set the current graphics mode.
    
    virtual bool SaveState();

    virtual bool RestoreState ();

    // 
    // Draw  operations:
    // 


    void DrawPolygon (UI_Point pointArray[], short numPoints,
                      ushort opt = UID_Outline);
    // Draw a closed polygon by connecting the points in the array with
    // line segments, in the order of occurrence of the points.  The second
    // parameter specifies the outline and fill options.
    // The first point in the array is taken as the starting point.

    void ClearDisplay();
    // Paint client window with current background color.

    bool DrawBitmap (const UI_Bitmap& b, const UI_Point& p);
    // Override the method inherited from DrawingSurface.
    
    bool Invert (const UI_Stencil& mask, const UI_Point& p);
    // Given a binary {\tt mask}, position
    // the mask against this DisplaySurface so that its top left corner is
    // at {\tt p}. Invert the DisplaySurface pixels under 1-bits in the
    // mask, and leave the rest unaltered.
    
    bool Draw (const UI_Bitmap& map, const UI_Stencil& s, const UI_Point& p);
    // Draw the given Bitmap on this DisplaySurface with top left corner at
    // the given point, but leave unaltered the pixels corresponding to
    // 0-bits in the Stencil.

    // 
    // Text operations:
    // 

    UI_Font& Font();
    // Override the inherited method. The implementation returns the Font
    // instance associated with the client VisualObject.
    
    void WriteString (const char* str, const UI_Rectangle& text_rect,
                      UI_TextStyle style = UIText_Left);
    // Draw the given character string within the given rectangle, with
    // justification as specified by the third parameter. The font used is
    // the one returned by the {\tt Font} method. {\tt WriteString} does
    // not perform word filling or line breaking.

    
    const char* ClassName () const {return "UI_DisplaySurface";};

protected:

    UI_DisplaySurface  (UI_VisualObject* o);
    // Protected constructor. A DisplaySurface cannot be created explicitly
    // by an application program; the VisualObject's {\tt
    // CreateDisplaySurface} method must be used for this purpose.

    ~UI_DisplaySurface ();
    // Protected destructor. A DisplaySurface cannot be destroyed explicitly
    // by an application program; the VisualObject's {\tt
    // DestroyDisplaySurface} method must be used for this purpose.


    void _Init ();

    void SetFont (UI_Font*);
    // SetFont: called only by UI_VisualObject and no one else.
    
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    long _BitBltROP () const;
    // [Windows/OS2-specific, YACL internal use only] Overrides the
    // inherited method.
    
#endif


    friend class UI_VisualObject;


    

protected:
    
    UI_VisualObject&    _client;
    long                _horzPPM;  // Pixels per meter (NOT pixels per mm)
    long                _vertPPM;

    CL_IntegerSequence  _modeStack;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    PAINTSTRUCT         _paintStruct;
#endif

    bool                _ownFont;

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    bool                _forPaintEvent; // Was this Surface created for a
                                        // Paint event?
#endif
    
    
    //    UI_ColorMap*     _colorMap;

    
#if defined(__X_MOTIF__)  || defined(__X_YACL__)
    void _DrawFontLine (const UI_Point& p1, const UI_Point& p2);
    // [X-windows-specific; internal use only]

public:
    Drawable _Drawable () const;
    // [X-windows-specific; internal use only]
   
 
#endif
};





// inline UI_ColorMap& UI_DisplaySurface::ColorMap () const
// {
//     return *_colorMap;
// }
 



#endif

