




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include <iostream.h> // DEBUG

#include "base/bytstrng.h"

#include "ui/cntroler.h"
#include "ui/bitmap.h"
#include "ui/dsplsurf.h"
#include "ui/visualob.h"
#include "ui/color.h"
#include "ui/arc.h"
#include "ui/chord.h"
#include "ui/ellipse.h"
#include "ui/piewedge.h"
#include "ui/containr.h"
#include "ui/stencil.h"


#if defined(__X_YACL__) || defined(__X_MOTIF__)
static GC TheGC = 0; // TRY THIS
#endif


#if defined(__OS2__)
static int _DrawMode [] = {
    FM_ZERO,           //  GMode_Clear:        0
    FM_AND,            //  GMode_And:          SRC & DEST
    FM_MASKSRCNOT,     //  GMode_AndReverse:   SRC & ~DEST
    FM_OVERPAINT,      //  GMode_Copy:         SRC
    FM_SUBTRACT,       //  GMode_AndInverted:  ~SRC & DEST
    FM_LEAVEALONE,     //  GMode_NoOp:         DEST
    FM_XOR,            //  GMode_Xor:          SRC ^ DEST
    FM_OR,             //  GMode_Or:           SRC | DEST
    FM_NOTMERGESRC,    //  GMode_Nor:          ~(SRC | DEST)
    FM_NOTXORSRC,      //  GMode_Equiv:        ~(SRC ^ DEST)
    FM_INVERT,         //  GMode_Invert:       ~DEST
    FM_MERGESRCNOT,    //  GMode_OrReverse:    SRC | ~DEST
    FM_NOTCOPYSRC,     //  GMode_CopyInverted: ~SRC
    FM_MERGENOTSRC,    //  GMode_OrInverted:   ~SRC | DEST
    FM_NOTMASKSRC,     //  GMode_Nand:         ~(SRC & DEST)
    FM_ONE             //  GMode_Set:          1
};
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
static int _DrawMode [] = {
    R2_BLACK,          //  GMode_Clear = 0
    R2_MASKPEN,        //  GMode_And
    R2_MASKNOTPEN,     //  GMode_AndReverse
    R2_COPYPEN,        //  GMode_Copy
    R2_MASKPENNOT,     //  GMode_AndInverted
    R2_NOP,            //  GMode_NoOp
    R2_XORPEN,         //  GMode_Xor
    R2_MERGEPEN,       //  GMode_Or
    R2_NOTMERGEPEN,    //  GMode_Nor
    R2_NOTXORPEN,      //  GMode_Equiv
    R2_NOT,            //  GMode_Invert
    R2_MERGENOTPEN,    //  GMode_OrReverse
    R2_NOTCOPYPEN,     //  GMode_CopyInverted
    R2_MERGEPENNOT,    //  GMode_OrInverted
    R2_NOTMASKPEN,     //  GMode_Nand
    R2_WHITE           //  GMode_Set
};

#elif defined(__X_MOTIF__) || defined(__X_YACL__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Xlib.h>
#    include <X11/Xatom.h>
#    include <X11/Intrinsic.h>
#    include <X11/StringDefs.h>

static int _DrawMode [] = {
    GXclear,                // 0 
    GXand,                  // src AND dst
    GXandReverse,           // src AND NOT dst
    GXcopy,                 // src 
    GXandInverted,          // NOT src AND dst 
    GXnoop,                 // dst
    GXxor,                  // src XOR dst
    GXor,                   // src OR dst
    GXnor,                  // NOT src AND NOT dst
    GXequiv,                // NOT src XOR dst
    GXinvert,               // NOT dst
    GXorReverse,            // src OR NOT dst
    GXcopyInverted,         // NOT src
    GXorInverted,           // NOT src OR dst
    GXnand,                 // NOT src OR NOT dst
    GXset                   // 1
}; 

#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_DisplaySurface>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_DisplaySurface>;
#endif

typedef CL_Binding0<UI_DisplaySurface> DSBind;




UI_DisplaySurface::UI_DisplaySurface (UI_VisualObject* v)
    : _client (*v)
{
    _Init ();
    _ownFont = FALSE;
}


#if defined(__OS2__)
static void _Exclude (UI_DwgSurfHandle hSfc, UI_ViewHandle hClient)
{
    HENUM hEnum = WinBeginEnumWindows (hClient);
    HWND hNext;
    while ((hNext = WinGetNextWindow (hEnum)) != 0) {
        RECTL rect;
        WinQueryWindowRect (hNext, &rect);
        WinMapWindowPoints (hNext, hClient, (PPOINTL) &rect, 2);
        GpiExcludeClipRectangle (hSfc, &rect);
    }
}
#endif

void UI_DisplaySurface::_Init ()
{
    _font = NULL;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    const double MM_PER_INCH = 25.4;
//     UI_Event* evt = YACLApp()->Controller().CurrentEvent();
//     NativeEventStruct* native = NULL;
//     if (evt && ((native = evt->NativeEvent()) != NULL) &&
//         native->message == WM_PAINT) {
//         _handle = BeginPaint (_client.ViewHandle(), &_paintStruct);
//         _forPaintEvent = TRUE;
//     }
//     else {
        _handle  = GetDC (_client.ViewHandle ());
        _forPaintEvent = FALSE;
//     }
    if (_handle) {
        _horzPPM    = ((float) GetDeviceCaps (_handle, LOGPIXELSX))
            * 1000.0 / MM_PER_INCH;
        _vertPPM    = ((float) GetDeviceCaps (_handle, LOGPIXELSY))
            * 1000.0 / MM_PER_INCH;
        _horzPixels = GetDeviceCaps (_handle, HORZRES);
        _vertPixels = GetDeviceCaps (_handle, VERTRES);
    }
    SetBkColor (_handle, _client.Background().NativeForm());
#elif defined(__OS2__)
    HWND clientHandle = _client.ViewHandle();
    _handle = WinGetPS (clientHandle);
    _forPaintEvent = FALSE;
    GpiCreateLogColorTable (_handle, LCOL_RESET, LCOLF_RGB, 0, 0, NULL);
    // For the moment, we don't support colormaps under OS/2
    Mode (GMode_Copy);
    // Set the clip region to exclude all child windows
    _Exclude (_handle, clientHandle);
#elif defined(__X_YACL__)
    XGCValues xvalues;
    UI_ViewHandle w = _client.ViewHandle();
    Display* dpy  = YACLApp()->AppDisplay();
    short screen  = DefaultScreen (dpy);
    xvalues.background = _client.Background().XPixel();
    xvalues.foreground = _client.Foreground().XPixel();
    // ---------------------------- TRY ---------------------
    // _handle  = XCreateGC (dpy, w, GCForeground|GCBackground, &xvalues);
    if (!TheGC)
        TheGC =  XCreateGC (dpy, RootWindow (dpy, screen),
                            GCForeground|GCBackground, &xvalues);
    _handle = TheGC;
    // --------------------------- END TRY -----------------
    _horzPPM      = (long) (1000.0 * DisplayWidth (dpy, screen)
        / DisplayWidthMM(dpy, screen));
    _vertPPM      = (long) (1000.0 * DisplayHeight (dpy, screen)
        / DisplayHeightMM(dpy, screen));
#elif defined(__X_MOTIF__)
    XGCValues xvalues;
    Widget w = _client.ViewHandle ();
    if (!w) {
        CL_Error::Warning ("UI_DisplaySurface::_Init: No widget defined"
                           "for VisualObject instanceName '%s'.",
                           _client.InstanceName());
        return;
    }
    if (!XtWindow(w)){
        CL_Error::Warning ("UI_DisplaySurface::_Init: No window defined"
                           "for VisualObject instanceName '%s'.",
                           _client.InstanceName());
        return;
    }
        
    Display* dpy  = XtDisplay (w); 
    short screen  = DefaultScreen (dpy);
    XtVaGetValues (w, XtNbackground, &xvalues.background, XtNforeground,
                   &xvalues.foreground, NULL);
    _handle       = XCreateGC (dpy, XtWindow (w), GCForeground|GCBackground,
                               &xvalues);
    _horzPPM      = (long) (1000.0 * DisplayWidth (dpy, screen)
        / DisplayWidthMM(dpy, screen));
    _vertPPM      = (long) (1000.0 * DisplayHeight (dpy, screen)
        / DisplayHeightMM(dpy, screen));
#endif

    _brush  = new UI_Brush (this, _client.Background(), UIBrush_Solid);
    _pen    = new UI_Pen   (this);
    // _colorMap = new UI_ColorMap (*this);
}




UI_DisplaySurface::~UI_DisplaySurface()
{
    if (_pen)
        delete _pen;
    if (_font) {
        if (_ownFont)
            delete _font;
        else {
            _font->UseClient (NULL);
            DSBind pre  (this, (DSBind::MethodPtr)
                         &UI_DisplaySurface::_FontWillChange);
            _font->RemovePreChangeDependent (pre);
            DSBind post (this, (DSBind::MethodPtr)
                         &UI_DisplaySurface::_FontChanged);
            _font->RemoveDependent (post);
        }
    }
    if (_brush)
        delete _brush;
//     if (_colorMap)
//         delete _colorMap;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SelectObject (_handle, (HPEN) NULL_PEN);
    SelectObject (_handle, (HBRUSH) NULL_BRUSH);
    if (_forPaintEvent)
        EndPaint (_handle, &_paintStruct);
    else
        ReleaseDC (_client.ViewHandle (), _handle);
#elif defined(__OS2__)
    if (_forPaintEvent)
        WinEndPaint (_handle);
    else
        WinReleasePS (_handle);
#elif defined(__X_YACL__) || defined(__X_MOTIF__)
    //    XFreeGC (YACLApp()->AppDisplay(), _handle); TRY!
#endif
}



UI_Rectangle UI_DisplaySurface::DrawingArea () const
{
    return _client.Shape();
}


UI_Rectangle UI_DisplaySurface::DrawingAreaInMM () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return UI_DisplaySurface::DrawingAreaInMM ();
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    return _client.Shape();
#endif
}



UI_DisplaySurface::GraphicsMode UI_DisplaySurface::Mode () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    int mode = GetROP2 (_handle);

#elif defined(__X_MOTIF__)
    XGCValues xvalues;

    XGetGCValues (XtDisplay (_client), _handle, GCFunction, &xvalues);
    int mode = xvalues.function;
#elif defined(__X_YACL__)
    XGCValues xvalues;
    XGetGCValues (YACLApp()->AppDisplay(), _handle, GCFunction, &xvalues);
    int mode = xvalues.function;
#elif defined(__OS2__)
    long mode = GpiQueryMix (_handle);

#endif
    for (short i = 0; i < sizeof (_DrawMode)/sizeof (int); i++) {
        if (mode == _DrawMode [i])
            return (GraphicsMode) i;
    }
    // Something wrong: it's not in the table!
    return (GraphicsMode) 0;
}



void UI_DisplaySurface::Mode (GraphicsMode mode)
{
    if (mode < GMode_Clear || mode > GMode_Set) {
        CL_Error::Warning ("UI_DisplaySurface::Mode: invalid parameter %d",
                           mode);
        return;
    }
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SetROP2 (_handle, _DrawMode [mode]);

#elif defined(__OS2__)
    GpiSetMix (_handle, _DrawMode[mode]);

#elif defined (__X_MOTIF__) || defined(__X_YACL__)
    XGCValues xvalues;
    xvalues.function   = _DrawMode [mode];
    XChangeGC (YACLApp()->AppDisplay (), _handle, GCFunction, &xvalues);

#endif
}





               
void UI_DisplaySurface::ClearDisplay ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    DWORD color = _client.Has3DLook() ? GetSysColor (COLOR_BTNFACE)
        : GetSysColor (COLOR_WINDOW);
    HANDLE hbr = CreateSolidBrush (color);
    HANDLE old = SelectObject (_handle, hbr);
    UI_Rectangle r = DrawingArea();
    r.Origin (UI_Point (0, 0));
    RECT rect = r.AsMSRect();
    rect.bottom++; rect.right++; // Because FillRect doesn't fill the bottom
                                 // and right pixels
    FillRect (_handle, &rect, hbr);
    if (old) 
        SelectObject (_handle, old);
    DeleteObject (hbr);

#elif defined(__OS2__)
    GpiErase (_handle);

#elif defined(__X_MOTIF__)
    Widget w = _client.ViewHandle ();
    Display *dpy = XtDisplay (w);
    XClearWindow (dpy, XtWindow (w));

#elif defined(__X_YACL__)
    Window w = _client.ViewHandle ();
    Display *dpy = YACLApp()->AppDisplay();
    XClearWindow (dpy, w);

#endif
}

void UI_DisplaySurface::SetFont (UI_Font* fnt)
{
    if (!fnt || fnt == _font)
        return;
    DSBind pre  (this, (DSBind::MethodPtr)
                 &UI_DrawingSurface::_FontWillChange);
    fnt->AddPreChangeDependent (pre);
    DSBind post (this, (DSBind::MethodPtr)
                 &UI_DrawingSurface::_FontChanged);
    fnt->AddDependent (post);
    if (_font) {
        _font->RemoveDependent (post);
        _font->RemovePreChangeDependent (pre);
    }
    _font = fnt;
    _font->UseClient (this);

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    SelectObject (_handle, _font->Handle());
#elif defined(__OS2__)
    GpiSetCharSet (_handle, _font->Handle());
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    UI_ResourceHandle h = _font->Handle();
    if (h)
        XSetFont (YACLApp()->AppDisplay(), _handle, h);
#endif
}



#if defined(__X_MOTIF__) || defined(__X_YACL__)
class ColorSaver {
public:
    ColorSaver (UI_VisualObject& v, const UI_Color& c);
    ~ColorSaver ();

protected:
    UI_VisualObject& _vObj;
    UI_Color         _tmpColor;
};


ColorSaver::ColorSaver (UI_VisualObject& v, const UI_Color& c)
: _vObj (v)
{
    _tmpColor = v.Foreground();
    v.Foreground (c);
}


ColorSaver::~ColorSaver ()
{
    _vObj.Foreground (_tmpColor);
}
#endif


void UI_DisplaySurface::DrawPolygon (UI_Point parr[], short numpts,
                                     ushort opt)
{
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    UI_Color c;

    if (opt & UID_Fill)
        c = _brush->Color();
    else if (opt & UID_Outline)
        c = _pen->Color();
    
    ColorSaver save (_client, c);

#endif
    UI_DrawingSurface::DrawPolygon (parr, numpts, opt);
}



#if defined(__X_MOTIF__) || defined(__X_YACL__)

// This is  a table of bytes with their bit reversals. Reverse[i] is the
// value obtained by reading off the bits of i from right to left.

static uchar Reverse[] = {
/* 00 */ 0x00, /* 01 */ 0x80, /* 02 */ 0x40, /* 03 */ 0xc0,
/* 04 */ 0x20, /* 05 */ 0xa0, /* 06 */ 0x60, /* 07 */ 0xe0,
/* 08 */ 0x10, /* 09 */ 0x90, /* 0a */ 0x50, /* 0b */ 0xd0,
/* 0c */ 0x30, /* 0d */ 0xb0, /* 0e */ 0x70, /* 0f */ 0xf0,
/* 10 */ 0x08, /* 11 */ 0x88, /* 12 */ 0x48, /* 13 */ 0xc8,
/* 14 */ 0x28, /* 15 */ 0xa8, /* 16 */ 0x68, /* 17 */ 0xe8,
/* 18 */ 0x18, /* 19 */ 0x98, /* 1a */ 0x58, /* 1b */ 0xd8,
/* 1c */ 0x38, /* 1d */ 0xb8, /* 1e */ 0x78, /* 1f */ 0xf8,
/* 20 */ 0x04, /* 21 */ 0x84, /* 22 */ 0x44, /* 23 */ 0xc4,
/* 24 */ 0x24, /* 25 */ 0xa4, /* 26 */ 0x64, /* 27 */ 0xe4,
/* 28 */ 0x14, /* 29 */ 0x94, /* 2a */ 0x54, /* 2b */ 0xd4,
/* 2c */ 0x34, /* 2d */ 0xb4, /* 2e */ 0x74, /* 2f */ 0xf4,
/* 30 */ 0x0c, /* 31 */ 0x8c, /* 32 */ 0x4c, /* 33 */ 0xcc,
/* 34 */ 0x2c, /* 35 */ 0xac, /* 36 */ 0x6c, /* 37 */ 0xec,
/* 38 */ 0x1c, /* 39 */ 0x9c, /* 3a */ 0x5c, /* 3b */ 0xdc,
/* 3c */ 0x3c, /* 3d */ 0xbc, /* 3e */ 0x7c, /* 3f */ 0xfc,
/* 40 */ 0x02, /* 41 */ 0x82, /* 42 */ 0x42, /* 43 */ 0xc2,
/* 44 */ 0x22, /* 45 */ 0xa2, /* 46 */ 0x62, /* 47 */ 0xe2,
/* 48 */ 0x12, /* 49 */ 0x92, /* 4a */ 0x52, /* 4b */ 0xd2,
/* 4c */ 0x32, /* 4d */ 0xb2, /* 4e */ 0x72, /* 4f */ 0xf2,
/* 50 */ 0x0a, /* 51 */ 0x8a, /* 52 */ 0x4a, /* 53 */ 0xca,
/* 54 */ 0x2a, /* 55 */ 0xaa, /* 56 */ 0x6a, /* 57 */ 0xea,
/* 58 */ 0x1a, /* 59 */ 0x9a, /* 5a */ 0x5a, /* 5b */ 0xda,
/* 5c */ 0x3a, /* 5d */ 0xba, /* 5e */ 0x7a, /* 5f */ 0xfa,
/* 60 */ 0x06, /* 61 */ 0x86, /* 62 */ 0x46, /* 63 */ 0xc6,
/* 64 */ 0x26, /* 65 */ 0xa6, /* 66 */ 0x66, /* 67 */ 0xe6,
/* 68 */ 0x16, /* 69 */ 0x96, /* 6a */ 0x56, /* 6b */ 0xd6,
/* 6c */ 0x36, /* 6d */ 0xb6, /* 6e */ 0x76, /* 6f */ 0xf6,
/* 70 */ 0x0e, /* 71 */ 0x8e, /* 72 */ 0x4e, /* 73 */ 0xce,
/* 74 */ 0x2e, /* 75 */ 0xae, /* 76 */ 0x6e, /* 77 */ 0xee,
/* 78 */ 0x1e, /* 79 */ 0x9e, /* 7a */ 0x5e, /* 7b */ 0xde,
/* 7c */ 0x3e, /* 7d */ 0xbe, /* 7e */ 0x7e, /* 7f */ 0xfe,
/* 80 */ 0x01, /* 81 */ 0x81, /* 82 */ 0x41, /* 83 */ 0xc1,
/* 84 */ 0x21, /* 85 */ 0xa1, /* 86 */ 0x61, /* 87 */ 0xe1,
/* 88 */ 0x11, /* 89 */ 0x91, /* 8a */ 0x51, /* 8b */ 0xd1,
/* 8c */ 0x31, /* 8d */ 0xb1, /* 8e */ 0x71, /* 8f */ 0xf1,
/* 90 */ 0x09, /* 91 */ 0x89, /* 92 */ 0x49, /* 93 */ 0xc9,
/* 94 */ 0x29, /* 95 */ 0xa9, /* 96 */ 0x69, /* 97 */ 0xe9,
/* 98 */ 0x19, /* 99 */ 0x99, /* 9a */ 0x59, /* 9b */ 0xd9,
/* 9c */ 0x39, /* 9d */ 0xb9, /* 9e */ 0x79, /* 9f */ 0xf9,
/* a0 */ 0x05, /* a1 */ 0x85, /* a2 */ 0x45, /* a3 */ 0xc5,
/* a4 */ 0x25, /* a5 */ 0xa5, /* a6 */ 0x65, /* a7 */ 0xe5,
/* a8 */ 0x15, /* a9 */ 0x95, /* aa */ 0x55, /* ab */ 0xd5,
/* ac */ 0x35, /* ad */ 0xb5, /* ae */ 0x75, /* af */ 0xf5,
/* b0 */ 0x0d, /* b1 */ 0x8d, /* b2 */ 0x4d, /* b3 */ 0xcd,
/* b4 */ 0x2d, /* b5 */ 0xad, /* b6 */ 0x6d, /* b7 */ 0xed,
/* b8 */ 0x1d, /* b9 */ 0x9d, /* ba */ 0x5d, /* bb */ 0xdd,
/* bc */ 0x3d, /* bd */ 0xbd, /* be */ 0x7d, /* bf */ 0xfd,
/* c0 */ 0x03, /* c1 */ 0x83, /* c2 */ 0x43, /* c3 */ 0xc3,
/* c4 */ 0x23, /* c5 */ 0xa3, /* c6 */ 0x63, /* c7 */ 0xe3,
/* c8 */ 0x13, /* c9 */ 0x93, /* ca */ 0x53, /* cb */ 0xd3,
/* cc */ 0x33, /* cd */ 0xb3, /* ce */ 0x73, /* cf */ 0xf3,
/* d0 */ 0x0b, /* d1 */ 0x8b, /* d2 */ 0x4b, /* d3 */ 0xcb,
/* d4 */ 0x2b, /* d5 */ 0xab, /* d6 */ 0x6b, /* d7 */ 0xeb,
/* d8 */ 0x1b, /* d9 */ 0x9b, /* da */ 0x5b, /* db */ 0xdb,
/* dc */ 0x3b, /* dd */ 0xbb, /* de */ 0x7b, /* df */ 0xfb,
/* e0 */ 0x07, /* e1 */ 0x87, /* e2 */ 0x47, /* e3 */ 0xc7,
/* e4 */ 0x27, /* e5 */ 0xa7, /* e6 */ 0x67, /* e7 */ 0xe7,
/* e8 */ 0x17, /* e9 */ 0x97, /* ea */ 0x57, /* eb */ 0xd7,
/* ec */ 0x37, /* ed */ 0xb7, /* ee */ 0x77, /* ef */ 0xf7,
/* f0 */ 0x0f, /* f1 */ 0x8f, /* f2 */ 0x4f, /* f3 */ 0xcf,
/* f4 */ 0x2f, /* f5 */ 0xaf, /* f6 */ 0x6f, /* f7 */ 0xef,
/* f8 */ 0x1f, /* f9 */ 0x9f, /* fa */ 0x5f, /* fb */ 0xdf,
/* fc */ 0x3f, /* fd */ 0xbf, /* fe */ 0x7f, /* ff */ 0xff
};
#endif


#if defined(__BORLANDC__) && defined(__OS2__)
#pragma argsused // For the time being, for OS/2
#endif

bool UI_DisplaySurface::Invert (const UI_Stencil& dataMask, const UI_Point& p)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    HDC hMem  = CreateCompatibleDC (_handle);
    short m = dataMask.Width(), n = dataMask.Height ();
    HBITMAP mapHandle = CreateBitmap (m * 8, n, 1, 1,
                                      dataMask.AsPtr());
    HANDLE hOld = SelectObject (hMem, mapHandle);
    BitBlt (_handle, p.XCoord(), p.YCoord(), m, n, hMem, 0, 0, SRCINVERT);
    SelectObject (hMem, hOld);
    DeleteObject (mapHandle);
    DeleteDC (hMem);

#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    Display *dpy  = YACLApp()->AppDisplay();
#if defined(__X_MOTIF__)
    Window    win = XtWindow  (_client);
#else
    Window    win = _client.ViewHandle();
#endif
    UI_Stencil data = dataMask;
    short m = data.Width(), n = data.Height ();
    if (BitmapBitOrder (dpy) == LSBFirst) {
        // Reverse the bit order in each byte
        for (short i = 0; i < m; i++)
            for (short j = 0; j < n; j++) {
                char& c = data.Byte (j, i);
                c = Reverse [(uchar) c];
            }
    }
    XGCValues values;
    XtGCMask mask = GCForeground | GCBackground | GCFunction
        | GCSubwindowMode | GCFillStyle;
    GC gc = _handle;
    XGCValues oldValues;
    XGetGCValues   (dpy, gc, mask, &oldValues);

    Pixmap stipple = XCreateBitmapFromData (dpy, win, data.AsPtr(), m, n);
    if (!stipple)
        return FALSE;
    values.foreground     = 1;
    values.background     = 0;
    values.function       = GXxor;
    values.subwindow_mode = IncludeInferiors;
    values.fill_style     = FillOpaqueStippled;
    XChangeGC      (dpy, gc, mask, &values);
    XSetStipple    (dpy, gc, stipple);
    XSetTSOrigin   (dpy, gc, p.XCoord(), p.YCoord());
    XFillRectangle (dpy, win, gc, p.XCoord(), p.YCoord(), m, n);
    XChangeGC      (dpy, gc, mask, &oldValues);
    XFreePixmap    (dpy, stipple);

#else
    NotImplemented ("Invert");

#endif
    return TRUE;
}






#if defined(__OS2__)
static int _BitmapDrawMode [] = {
    // I computed the constants here by looking in the Borland on-line
    // documentation for GpiBitBlt. It's also described on page 238 of
    // Petzold's OS/2 book.
    ROP_ZERO,          //  GMode_Clear:        0
    ROP_SRCAND,        //  GMode_And:          SRC & DEST
    ROP_SRCERASE,      //  GMode_AndReverse:   SRC & ~DEST
    ROP_SRCCOPY,       //  GMode_Copy:         SRC
    0x0022,            //  GMode_AndInverted:  ~SRC & DEST
    0x00aa,            //  GMode_NoOp:         DEST
    ROP_SRCINVERT,     //  GMode_Xor:          SRC ^ DEST
    ROP_SRCPAINT,      //  GMode_Or:           SRC | DEST
    ROP_NOTSRCERASE,   //  GMode_Nor:          ~(SRC | DEST)
    0x0099,            //  GMode_Equiv:        ~(SRC ^ DEST)
    ROP_DSTINVERT,     //  GMode_Invert:       ~DEST
    0x00dd,            //  GMode_OrReverse:    SRC | ~DEST
    ROP_NOTSRCCOPY,    //  GMode_CopyInverted: ~SRC
    ROP_MERGEPAINT,    //  GMode_OrInverted:   ~SRC | DEST
    0x0077,            //  GMode_Nand:         ~(SRC & DEST)
    ROP_ONE            //  GMode_Set:          1
};
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
static int _BitmapDrawMode [] = {
    BLACKNESS,         //  GMode_Clear = 0
    SRCAND,            //  GMode_And
    SRCERASE,          //  GMode_AndReverse
    SRCCOPY,           //  GMode_Copy
    0x0022,            //  GMode_AndInverted
    0x00AA,            //  GMode_NoOp
    SRCINVERT,         //  GMode_Xor
    SRCPAINT,          //  GMode_Or
    NOTSRCERASE,       //  GMode_Nor
    0x0099,            //  GMode_Equiv
    DSTINVERT,         //  GMode_Invert
    0x00dd,            //  GMode_OrReverse
    NOTSRCCOPY,        //  GMode_CopyInverted
    MERGEPAINT,        //  GMode_OrInverted
    0x0077,            //  GMode_Nand
    WHITENESS          //  GMode_Set
};
#endif

bool UI_DisplaySurface::DrawBitmap (const UI_Bitmap& b, const UI_Point& p)
{
#if defined(__OS2__)
    const UI_Rectangle& shape = _client.Shape();
    POINTL pt[4];
    pt[0].x = p.XCoord();
    pt[0].y = shape.Height() - p.YCoord() - b.Height() + 1;
    pt[1].x = pt[0].x + b.Width ()  - 1;
    pt[1].y = pt[0].y + b.Height () - 1;
    pt[2].x = pt[2].y = 0;
    pt[3].x = b.Width ()  - 1;
    pt[3].y = b.Height () - 1;
    UI_PaletteHandle h = b.PaletteHandle(), oldPalette = 0;
    if (h) {
        GpiSelectPalette (_handle, h);
        ULONG palSize = 1 << (b.BitsPerPixel());
        WinRealizePalette (_client.ViewHandle(), _handle, &palSize);
    }
    GpiWCBitBlt (_handle, b.Handle(), 4, pt, _BitmapDrawMode[Mode()], BBO_AND);
//     extern CL_String PrintForm (RECTL*);
//     CL_Error::Warning ("DwgSurface DrawBitmap: dest %s src %s\n",
//                        PrintForm ((RECTL*) &pt).AsPtr(),
//                        PrintForm ((RECTL*) &pt[2]).AsPtr()); //DEBUG
    if (h && oldPalette)
        GpiSelectPalette (_handle, oldPalette);
    return TRUE;
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    
    UI_PaletteHandle h = b.PaletteHandle();
    HPALETTE oldPalette = 0;
    if (h) {
        oldPalette = SelectPalette  (_handle, h, FALSE);
        RealizePalette (_handle);
    }
    UI_BitmapHandle bmpHandle = b.Handle();
    if (!bmpHandle)
        return FALSE;
    HDC destdc = Handle ();
    if (!destdc)
        return FALSE;
    HDC hdc = CreateCompatibleDC (destdc);
    if (!hdc)
        return FALSE;
    HANDLE oldh = SelectObject (hdc, bmpHandle);
    SetMapMode (hdc, GetMapMode (destdc));

    BITMAP bm;
    POINT ptsize, ptorg;

    GetObject (bmpHandle, sizeof (BITMAP), (LPSTR) &bm);
    ptsize.x = bm.bmWidth;
    ptsize.y = bm.bmHeight;
    DPtoLP (destdc, &ptsize, 1);

    ptorg.x = 0; ptorg.y = 0;
    DPtoLP (hdc, &ptorg, 1);
                
    BitBlt (destdc, p.XCoord(), p.YCoord(), b.Width(), b.Height(), hdc,
            0, 0, // SRCCOPY)
            _BitmapDrawMode [Mode()]);
    SelectObject (hdc, oldh);
    DeleteDC (hdc);
    if (h)
        SelectPalette  (_handle, oldPalette, FALSE);
    return TRUE;
    
#else
    return UI_DrawingSurface::DrawBitmap (b, p);
#endif
}


#if defined(__BORLANDC__)
#pragma argsused // For the time being
#endif

bool UI_DisplaySurface::Draw (const UI_Bitmap& map, const UI_Stencil& s,
                              const UI_Point& p)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    Display *dpy  = YACLApp()->AppDisplay();
#if defined(__X_MOTIF__)
    Window    win = XtWindow  (_client);
#else
    Window win = _client.ViewHandle();
#endif
    int format = DefaultDepth (dpy, DefaultScreen(dpy)) == 1 ? XYPixmap
        : ZPixmap;
    struct _XImage* r, *q;
    long w = map.Width();
    long h = map.Height();
    r = XGetImage (dpy, win, p.XCoord(), p.YCoord(), w, h, AllPlanes, format);
    q = map.Handle();
    for (long i = 0; i < h; i++) {
        for (long j = 0; j < w; j++)
            if (s.Bit (i, j))
                XPutPixel (r, i, j, XGetPixel (q, i, j));
    }
    XPutImage (dpy, win, _handle, r, 0, 0, p.XCoord(), p.YCoord(), w, h);

#else
    NotImplemented ("Draw");

#endif
    return TRUE;
}



void UI_DisplaySurface::WriteString
    (const char* str, const UI_Rectangle& tRect, UI_TextStyle tStyle)
{
#if defined (__X_MOTIF__)
    ColorSaver save (_client, _pen->Color());
#endif
    UI_DrawingSurface::WriteString (str, tRect, tStyle);
}



UI_Font& UI_DisplaySurface::Font ()
{
    return _client.Font();
}


UI_VisualObject& UI_DisplaySurface::Client () const
{
    return _client;
}


bool UI_DisplaySurface::SaveState ()
{
    if (!UI_DrawingSurface::SaveState())
        return FALSE;
    _modeStack.Add (Mode());
    return TRUE;
}


bool UI_DisplaySurface::RestoreState ()
{
    if (!UI_DrawingSurface::RestoreState())
        return FALSE;
    Mode ((GraphicsMode) _modeStack.ExtractRightmost());
    return TRUE;
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
long UI_DisplaySurface::_BitBltROP () const
{
    return 0;
}
#endif




#if defined(__X_MOTIF__) || defined(__X_YACL__)
void UI_DisplaySurface::_DrawFontLine (const UI_Point& p1, const UI_Point& p2)
{
    // ColorSaver save (_client, _pen->Color());
    UI_DrawingSurface::_DrawFontLine (p1, p2);
}


#if defined(__X_YACL__)
Drawable UI_DisplaySurface::_Drawable() const
{ 
    return _client.ViewHandle();
}
#else
Drawable UI_DisplaySurface::_Drawable() const
{ 
    return (XtWindow (_client.ViewHandle()));
}
#endif

#endif





