
#ifndef _resource_h_
#define _resource_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



/*
  Authors:   M. A. Sridhar
             N. Bhowmik
*/


#if defined(__GNUC__)
#pragma interface
#endif

#include "base/map.h"
#include "base/binding.h"
#include "ui/uidefs.h"

#if defined(__MS_WIN32__)
typedef HANDLE UI_ResourceHandle;
#else
typedef long UI_ResourceHandle;
#endif

class YACL_UI UI_DrawingSurface;

// DisplayResource is an abstraction of a resource used for drawing on a
// DrawingSurface. Specializations of this class include the Font, the
// Pen and the Brush.


class YACL_UI UI_DisplayResource: public CL_Object {
    
public:

    UI_DisplayResource (UI_DrawingSurface* ctxt = NULL);
    // Set up this resource to work with the given display context.

    UI_DisplayResource (const UI_DisplayResource&);
    
    ~UI_DisplayResource () {};
    // Destructor.
    
    void Initialize ()
        {_Setup();};
    
    UI_ResourceHandle  Handle() { return _handle;};
    // Return the platform-specific handle for this DisplayResource.

    const char* ClassName() const { return "UI_DisplayResource";};



protected:
    

    // ------------------- Instance variables ------------------------
    
    UI_ResourceHandle  _handle;
    UI_DrawingSurface* _clientCtxt;

    // ------------------- Protected methods -------------------------
    virtual void       _Setup () = 0;
    // Set up the handle for this resource. Must be defined by derived
    // class. 


public:
    void UseClient (UI_DrawingSurface* client);
    // [YACL Internal use only]
    
};

#endif
