
#ifndef _dsinmem_h_ /* Fri Apr 21 12:21:23 1995 */
#define _dsinmem_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




// DwgSurfaceInMemory represents an in-memory drawing surface, i.e., a block
// of memory that remembers the information created by a series of drawing
// operations. It can be used by  applications that need to draw a complex
// graphic several times. The usual scheme is to draw the necessary complex
// graphic on a DwgSurfaceInMemory once, and then use the {\tt CopyTo}
// method to copy the entire contents onto a DisplaySurface. Currently,
// the only kind of DrawingSurface that the contents of a DwgSurfaceInMemory 
// can be copied onto is a DisplaySurface.
//
// Caveat: Under X windows, you may only create a DwgSurfaceInMemory after
// the application's main window has been created and visible, i.e., after
// the main window's MakeVisualElement has been executed and the main window
// has been realized. (Yes, this is a messy limitation, but I don't know of
// a way around it.)

#include "ui/uidefs.h"
#include "ui/dwgsurf.h"

#if defined (__MS_WINDOWS__)
typedef long UI_DwgSurfInMemoryHandle;
#elif defined(__MS_WIN32__)
typedef HANDLE UI_DwgSurfInMemoryHandle;
#elif defined (__OS2__)
typedef ulong UI_DwgSurfInMemoryHandle;
#elif defined (__X_MOTIF__)
typedef Pixmap UI_DwgSurfInMemoryHandle;
#endif



class YACL_UI UI_DisplaySurface;

class YACL_UI UI_DwgSurfaceInMemory: public UI_DrawingSurface {

public:
    UI_DwgSurfaceInMemory (long width, long height);
    // Create an in-memory drawing surface with the given width and height.
    
    ~UI_DwgSurfaceInMemory ();
    // Destructor.

    double HorzPixelsPerMM () const;
    // Return the number of pixels per millimeter in the horizontal
    // direction.

    double VertPixelsPerMM () const;
    // Return the number of pixels per millimeter in the vertical direction.

    UI_Rectangle DrawingArea() const
        { return UI_Rectangle (0, 0, _width, _height);};
    // Returns the rectangle enclosing the drawing surface, in pixels. The
    // origin is (0, 0).

    UI_Rectangle DrawingAreaInMM () const;
    // Returns the drawing area, in millimeters. The origin is (0, 0).

    void CopyTo (UI_DisplaySurface& sfc, const UI_Point& p = UI_Point (0, 0));
    // Draw the contents on the given DisplaySurface with top left corner
    // at the given point.
    
protected:

    long      _width;
    long      _height;
    long      _horzPPM;
    long      _vertPPM;

#if defined (__X_MOTIF__) || defined(__X_YACL__)
public:
    Drawable _Drawable() const { return _pixmap; };
    // [X-windows-specific; YACL internal use only]

protected:
    Pixmap   _pixmap;
    
#elif defined(__OS2__)
protected:
    HDC      _hdc;
    HBITMAP  _hbm;

#elif defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
protected:
    HBITMAP  _hbm;

#endif

};

#endif /* _dsinmem_h_ */



