



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/dialog.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    if defined(USE_CTL3D)
#        include <ctl3d.h>
#    endif
#    if defined(__MS_WIN32__)
#        include <string.h>
#    endif
#endif

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding0<UI_Dialog>;
template class UI_EventBinding1<UI_Dialog>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_Dialog>;
template UI_EventBinding1<UI_Dialog>;
#endif

#if defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#    include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/BulletinB.h>
#    include <X11/Shell.h>
#    include <Xm/Xm.h>
#    include <Xm/Protocols.h>
#    include <Xm/AtomMgr.h>
#    include <Xm/MwmUtil.h>
#    include <Xm/MainW.h>

#    include <X11/keysym.h>
#endif

typedef CL_Binding0<UI_Dialog> DialogBind0;
typedef UI_EventBinding1<UI_Dialog> DialogBind1;

class YACL_UI DialogEvent: public CL_Object {

    // An encapsulation of a visual-object/event-type pair
    
public:
    DialogEvent (UI_ViewID id, UI_EventType type)
    : _id (id), _type (type) {};

    ~DialogEvent () {};
    
    short Compare (const CL_Object& o) const;

    void operator = (const CL_Object& o)
        { _id = ((const DialogEvent&) o)._id;
          _type = ((const DialogEvent&) o)._type;};

    const char* ClassName() const {return "DialogEvent";};
    
protected:
    UI_ViewID     _id;
    UI_EventType  _type;
};


short DialogEvent::Compare (const CL_Object& o) const
{
    const DialogEvent& d = (const DialogEvent&) o;
    if (_id == d._id) {
        if (_type == d._type)
            return 0;
        return _type < d._type ? -1 : 1;
    }
    return _id < d._id ? -1 : 1;
}





UI_Dialog::UI_Dialog
    (UI_CompositeVObject* parent, UI_ViewDescriptor* vd,
     const UI_Rectangle& shape,   UI_DialogEventDescriptor* qd,
     UI_ViewID defaultPB,         CL_AbstractBinding* valid
    )
: UI_CompositeVObject (parent, vd, FALSE, shape)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = WS_CLIPCHILDREN | WS_VISIBLE | WS_SYSMENU |
        WS_CAPTION | DS_MODALFRAME;
#if !defined(USE_CTL3D)
    // For Win95/NT4.0
    _style |= 4L;
#endif
    Set3DLook();
#elif defined(__OS2__)
    _style = FCF_TITLEBAR | FCF_SYSMENU | FCF_DLGBORDER;
#endif
    _Init (qd, defaultPB, valid);
}


void UI_Dialog::_Init (UI_DialogEventDescriptor* qd, UI_ViewID defaultPB,
                       CL_AbstractBinding* valid)
{
    _defaultPushBtn = defaultPB;
    _validator      = (CL_AbstractBinding*) (valid ? valid->Clone() : NULL);
    _closed         = FALSE;
    _modalState     = FALSE;
    if (!qd) {
        AddDialogEvent (UI_IDOK,     Event_Select);
        AddDialogEvent (UI_IDCANCEL, Event_Select);
    }
    else {
        for (short i = 0; qd[i].id != -1 && qd[i].type != View_None; i++) 
            AddDialogEvent (qd[i].id, qd[i].type);
    }
    _lastEvent.id = -1;

}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
UI_Dialog::UI_Dialog (UI_CompositeVObject* parent, const char* rsrc,
                      UI_DialogEventDescriptor* qd, UI_ViewID defaultPB,
                      CL_AbstractBinding* valid)
: UI_CompositeVObject(parent, rsrc)
{
    Set3DLook ();
    _Init (qd, defaultPB, valid);
}
#endif



UI_Dialog::~UI_Dialog()
{
    _dialogEvents.DestroyContents();
    if (_validator)
        delete _validator;
}




#if defined(__MS_WINDOWS__)
struct DialogBoxHeader {
    DWORD s; BYTE n; WORD x, y, cx, cy;
    char mnu[1];
    char cls[1];
    char caption[1];
    WORD pt;
    char face[1];
};
#endif


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
void UI_Dialog::SetStyle ()
{
    _style = WS_CLIPCHILDREN | WS_VISIBLE | WS_SYSMENU |
        WS_CAPTION | DS_MODALFRAME;
    _style &= ~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX);
}

ulong UI_Dialog::ExtendedStyle () const
{
    return WS_EX_ACCEPTFILES | WS_EX_DLGMODALFRAME;
}


// struct SysFontStruct {
//     short width, height;
// };
// 
// static SysFontStruct _SysFontSizes ()
// {
//     HFONT hFont = GetStockObject (SYSTEM_FONT);
//     HDC dc = CreateDC ("DISPLAY", NULL, NULL, NULL);
//     HFONT old = SelectObject (dc, hFont);
//     TEXTMETRIC tm;
//     GetTextMetrics (dc, &tm);
//     SelectObject (dc, old);
//     DeleteObject (hFont);
//     DeleteDC (dc);
//     SysFontStruct st;
//     st.width  = tm.tmAveCharWidth;
//     st.height = tm.tmHeight;
//     return st;
// }
// 
// static SysFontStruct _SysFont = _SysFontSizes();
#endif


bool UI_Dialog::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_rname.Size()) {
        // If this is a resource-based dialog, its visual element has already
        // been created by the Composite's constructor. So:
        return TRUE;
    }
    
    if (_defaultPushBtn > 0) {
        UI_VisualObject* btn = (*this)[_defaultPushBtn];
        if (btn) 
            btn->Style() |= BS_DEFPUSHBUTTON;
    }

    long x, y, w, h;

    x = _shape.Origin().XCoord();
    y = _shape.Origin().YCoord();
    w = _shape.Width();
    h = _shape.Height();

    RECT rect;
    rect.left    = x;
    rect.top     = y;
    rect.right   = x + w;
    rect.bottom  = y + h;
    AdjustWindowRect (&rect, _style, FALSE);
    if (!_visible)
        _style &= ~WS_VISIBLE;
//     short fontWidth = _SysFont.width;
//     if (fontWidth <= 0)
//         fontWidth = 4;
//     short fontHeight = _SysFont.height;
//     if (fontHeight <= 0)
//         fontHeight = 8;
    short fontWidth = 4, fontHeight = 8;
#if defined(__MS_WINDOWS__)
    HGLOBAL hMem = GlobalAlloc (GHND, sizeof (DialogBoxHeader) +
                                _title.Size() + 1);
    DialogBoxHeader* hdr = (DialogBoxHeader*) GlobalLock (hMem);
    if (!hdr) {
        CL_Error::Warning ("UI_Dialog::MakeVisualElement: GlobalLock failed"); 
        return FALSE;
    }
    hdr->n = 0;
    hdr->x = rect.left * 4 / fontWidth;
    hdr->y = rect.top * 8 / fontHeight;
    hdr->cx = (rect.right - rect.left + 1) * 4 / fontWidth;
    hdr->cy = (rect.bottom - rect.top + 1) * 8 / fontHeight;
    hdr->cls[0] = 0;
    hdr->mnu[0] = 0;
    hdr->caption[0] = 0;
    hdr->pt = 0;
    hdr->face[0] = 0;
    // For some reason, the dimensions set up in the hdr structure
    // don't match up on all displays. So we make the dialog
    // initially invisible, call SetWindowPos, and then let the
    // controller make it visible.
    hdr->s = _style & ~WS_VISIBLE;
    const void FAR* tmpl = hdr;
#else // Win32
    short blockSize = sizeof (DLGTEMPLATE) + 10
        //                                   ^^
        // For the menu, class and font arrays
        + _title.Size() + 1;
    HGLOBAL hMem = GlobalAlloc (GHND, blockSize);
    DLGTEMPLATE* hdr = (DLGTEMPLATE*) GlobalLock (hMem);
    if (!hdr) {
        CL_Error::Warning ("UI_Dialog::MakeVisualElement: GlobalLock failed"); 
        return FALSE;
    }
    memset (hdr, blockSize, 0);
    hdr->style           = _style & ~WS_VISIBLE;
    hdr->dwExtendedStyle = 0;
    hdr->cdit            = 0;
    hdr->x               = rect.left * 4 / fontWidth;
    hdr->y               = rect.top * 8 / fontHeight;
    hdr->cx              = (rect.right - rect.left + 1) * 4 / fontWidth;
    hdr->cy              = (rect.bottom - rect.top + 1) * 8 / fontHeight;
    
    USHORT* menuArray  = (USHORT*) (((char*) hdr) + sizeof (DLGTEMPLATE));
    *menuArray = 0;
    
    USHORT* classArray = (USHORT*) (((char*) hdr) + sizeof (DLGTEMPLATE) + 2);
    *classArray = 0;
    
    char* titleArray   = (char*) (((char*) hdr) + sizeof (DLGTEMPLATE) + 4);
    lstrcpy (titleArray, (char*) _title.AsPtr());
  
    LPCDLGTEMPLATE tmpl  = hdr;
#endif
     _handle = CreateDialogIndirectParam (_Application->ProcessId(), tmpl,
         _parent ? _parent->ViewHandle() : NULL, (FARPROC) YACLDialogProc, 0L);
    if (!_handle) {
        CL_Error::Warning ("Dialog creation failed: id %ld class %s",
                           ViewID(), ClassName());
        return FALSE;
    }
#if defined(USE_CTL3D)
    Ctl3dSubclassDlgEx (_handle, CTL3D_ALL);
#endif
    long xOffset = 0, yOffset = 0;
    if (_parent) {
        xOffset += _parent->Shape().Left();
        yOffset += _parent->Shape().Top ();
    }
    SetWindowPos (_handle, NULL, rect.left + xOffset, rect.top + yOffset,
                  rect.right - rect.left + 1,
                  rect.bottom - rect.top + 1, 0);
    SendMessage (_handle, WM_SETTEXT,  0, (LPARAM)_title.AsPtr());
//     CL_Error::Warning ("UI_Dialog: Handle %08x title %s", _handle,
//                        _title.AsPtr());//DEBUG
    GlobalUnlock (hMem);
    GlobalFree (hMem);
    return TRUE;

#elif defined (__OS2__)
    if (_defaultPushBtn > 0) {
        UI_VisualObject* btn = (*this)[_defaultPushBtn];
        if (btn) 
            btn->Style() |= BS_DEFAULT;
    }

    return UI_CompositeVObject::MakeVisualElement ();
#elif defined(__X_MOTIF__)
    bool b = UI_CompositeVObject::MakeVisualElement ();
    if (b && _defaultPushBtn > 0) {
        UI_VisualObject* btn = (*this)[_defaultPushBtn];
        if (btn) 
            XtVaSetValues (_xwidget, XmNdefaultButton, btn->ViewHandle(), 0);
    }
    return b;
    
#elif defined(__X_YACL__)
    bool b = UI_CompositeVObject::MakeVisualElement ();
    if (_parent)
        XSetTransientForHint (_Application->AppDisplay(), _window,
                              _parent->ViewHandle());
    return b;
#endif
}



UI_DialogEventDescriptor UI_Dialog::ExecuteModal ()
{
    _lastEvent.id = -1;
    _modalState   = TRUE;
    _closed = FALSE;
// #ifdef __MS_WINDOWS__
//     // Gray out the "Close" in the system menu
//     HMENU h = GetSystemMenu (_handle, FALSE);
//     if (h)
//         EnableMenuItem (h, SC_CLOSE, FALSE);
// #endif

    _Controller->DispatchPendingEvents (); // Flush the event queue
    // _Controller->GiveMouseTo (this);
    DialogBind1 filterBind (this, &UI_Dialog::EventFilter);
    DialogBind0 finishBind (this, &UI_Dialog::RunFinished);

    _Controller->EventLoop (&finishBind, &filterBind);
    _modalState = FALSE;
    _Controller->ReleaseMouse();
    return _lastEvent;
}



bool UI_Dialog::_DialogEventOccurred (UI_Event& e)
{
    DialogEvent t (e.Origin()->ViewID(), e.Type());
    if (_dialogEvents.Includes (&t)) {
        _lastEvent.id   = e.Origin()->ViewID();
        _lastEvent.type = e.Type();
        if (_lastEvent.id == _defaultPushBtn) {
            if (_validator && !_validator->Execute (*this))
                _lastEvent.id = -1; // Validation failed; pretend that the
                                    // dialog event did not occur
        }
    }
    return TRUE;
}



static bool IsAncestor (UI_VisualObject* a, UI_VisualObject* b)
{
    // Check if a is an ancestor of b
    if (!a || !b)
        return FALSE;
    while (b && b != a)
        b = b->Parent();
    return b == a;
}


#include <iostream.h> // DEBUG
bool UI_Dialog::EventFilter (UI_Event& e)
{
    if (!_modalState)
        return TRUE; // Dispatch everything
    
    UI_VisualObject* origin = e.Origin();
    UI_VisualObject* dest = e.Destination();
    UI_EventType typ = e.Type();
    bool b = (origin == this || dest == this || !origin || !dest
              || typ == Event_MouseMove
#if !defined(__X_MOTIF__)
              || typ == Event_LButtonRelease // Don't allow under Motif
#endif
              || typ == Event_ViewEnter
              || typ == Event_ViewLeave
              || typ == Event_None
              || typ == Event_Other
              || typ == Event_Paint
              || typ == Event_Reconfigure);
    b |=  IsAncestor (this, origin);
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!b && e.Type() == Event_LButtonRelease)
        _Controller->Beep();
#endif
//     cout << "EventFilter: event " << e << " VObj " <<
//         origin->ClassName() << " label '" <<
//         origin->Title() << "' returns " << b << endl; // DEBUG

    if (origin == this && dest == this && e.Type() == Event_CloseDown) {
        _closed = TRUE;
        if (!_parent)
            _Application->Destroy (this);
    }
    return b;
}



bool UI_Dialog::RunFinished ()
{
    return (_lastEvent.id != -1 || _closed);
}

#if defined(__X_MOTIF__) || defined(__X_YACL__)
static const short RETURN_KEY = XK_Return;
#else
#define RETURN_KEY 0x0d
#endif


bool UI_Dialog::_EventOccurred (UI_Event& evt)
{
    if (evt.Type() == Event_KeyTyped) {
        if (evt.Key() == RETURN_KEY && _defaultPushBtn != -1 &&
            (*this)[_defaultPushBtn]) {
            // Return key was hit and we have a default push button
            _lastEvent.id   = _defaultPushBtn;
            _lastEvent.type = Event_Select;
        }
    }
    return UI_CompositeVObject::_EventOccurred (evt);
}


bool UI_Dialog::AddDialogEvent (UI_ViewID id, UI_EventType type)
{
    DialogBind1 bind   (this, &UI_Dialog::_DialogEventOccurred);
    AddEventDependent (type, bind);
    DialogEvent* d = new DialogEvent (id, type);
    if (_dialogEvents.Add (d))
        return TRUE;
    delete d;
    return FALSE;
}


bool UI_Dialog::RemoveDialogEvent (UI_ViewID id, UI_EventType type)
{
    DialogBind1 bind      (this, &UI_Dialog::_DialogEventOccurred);
    RemoveEventDependent (type, bind);
    DialogEvent d (id, type);
    DialogEvent* p = (DialogEvent*) _dialogEvents.Remove (&d);
    if (p) {
        delete p;
        return TRUE;
    }
    return FALSE;
}



void UI_Dialog::CloseDown ()
{
//    CL_Error::Warning ("Close down"); // DEBUG
    if (InModalState()) {
        if (WantToQuit ())
            _closed = TRUE;
    }
    else  if (WantToQuit()) {
        if (_parent)
            _parent->TakeFocus();
        _Application->Destroy (this);
    }
}



#if defined(__OS2__)
void UI_Dialog::_ComputeWindowShape (RECTL& boundary)
{
    HWND parentHandle = ParentHandle();
    long parentHeight = _YACLWindowHeight (parentHandle);
    long left   = _shape.Left(),   top   = _shape.Top ();
    long height = _shape.Height(), width = _shape.Width ();

    long xOffset = 0, yOffset = 0;
    if (_parent) {
        xOffset += _parent->Shape().Left();
        yOffset -= _parent->Shape().Top ();
    }
    boundary.xLeft   = left + xOffset;
    boundary.yBottom = parentHeight - top - height + yOffset;
    boundary.xRight  = left + width - 1 + xOffset;
    boundary.yTop    = parentHeight - top + yOffset;
    WinMapWindowPoints (_handle, parentHandle, (PPOINTL) &boundary, 2);
    WinCalcFrameRect   (_frameHandle, &boundary, FALSE);
}
#endif

