




#ifndef _cursor_h_ /* Fri Apr  1 10:23:43 1994 */
#define _cursor_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




/*
  Author: M. A. Sridhar
*/


// This is an encapsulation of a cursor, which is the shape displayed at
// the position of the mouse pointer ({\it sprite,} in X-windows
// terminology). This value of this object may be modified via the
// assignment operator it provides, thus changing
// the shape displayed. An application program never creates a cursor
// instance. The way to set cursors is to assign to VisualObject's {\tt
// Cursor} method.


#if defined(__GNUC__)
#pragma interface
#endif

//[ Global
enum UI_CursorType {
    UICursor_Default
  , UICursor_Arrow
  , UICursor_Wait
  , UICursor_CrossHairs
  , UICursor_IBeam
  , UICursor_NorthSouthArrows
  , UICursor_EastWestArrows
  , UICursor_UpArrow
};
// Types of supported cursors.
//] Global

#   include "ui/uidefs.h"
#if defined(__MS_WIN32__)
    typedef HCURSOR UI_CursorHandle;
#else
    typedef long UI_CursorHandle;
#endif


#include "base/string.h"

class YACL_UI UI_Cursor: public CL_Object {

public:

    // ------------------ Construction and destruction --------------------
    
    UI_Cursor (UI_CursorType type = UICursor_Default);
    // Create a cursor with the given type.

    ~UI_Cursor ();
    // Destructor.


    // ------------------------ Querying ---------------------------
    
    inline UI_CursorHandle Handle () const;
    // Return the platform-specific handle for the cursor.
    
    UI_CursorType Type () const {return _type;};
    
    // -----------------------  Comparison -------------------------

    bool operator== (const UI_Cursor& c) const;
    // Return TRUE if this represents the same cursor shape as does {\tt c}.

    inline bool operator== (UI_CursorType c) const;
    // Return TRUE if this represents the same cursor shape as does {\tt c}.
    
    inline bool operator== (const CL_Object&) const;
    // Cast the parameter down to Cursor and test for equality.
    
    inline bool operator!= (const UI_Cursor& c) const;

    inline bool operator!= (UI_CursorType t) const;
    
    inline bool operator!= (const CL_Object& o) const;
    
    // --------------------- Modification --------------------
    
    void operator= (UI_CursorType type);
    // Change this cursor to be the given predefined type.
    
    void operator= (const char* cursor_name);
    // Change this cursor to be the one with the given name.
    // [Not yet available under OS/2 or Motif.]

    void operator= (const UI_Cursor&)
        {NotImplemented ("op = (UI_Cursor&)");};

    void operator= (const CL_Object&)
        {NotImplemented ("op = (CL_Object&)");};
    
protected:

    void _Destroy ();
    
    UI_CursorType   _type;
    CL_String       _name;
    UI_CursorHandle _handle;
};




inline UI_CursorHandle UI_Cursor::Handle () const
{
    return _handle;
}


inline bool UI_Cursor::operator== (const CL_Object& o) const
{
    return operator== ((const UI_Cursor&) o);
}

inline bool UI_Cursor::operator== (UI_CursorType t) const
{
    return _type == t;
}

inline bool UI_Cursor::operator!= (const UI_Cursor& c) const
{
    return ! (*this == c);
}

inline bool UI_Cursor::operator!= (UI_CursorType t) const
{
    return ! (*this == t);
}

inline bool UI_Cursor::operator!= (const CL_Object& o) const
{
    return ! (*this == o);
}

#endif /* _cursor_h_ */
