




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif


#include "base/map.h"
#include "ui/cursor.h"
#include "ui/applic.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#include <windows.h>
#elif defined(__OS2__)
#include <string.h>
#endif

#if defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/cursorfont.h>
#    include <X11/Xlib.h>
#    include <X11/Intrinsic.h>
#    include <iostream.h> // DEBUG
#endif



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
static struct CodeAssoc {
    LPSTR code;
    UI_CursorType type;
} CursorCode [] = {
    (LPSTR) IDC_ARROW,      UICursor_Arrow,
    (LPSTR) IDC_WAIT,       UICursor_Wait,
    (LPSTR) IDC_CROSS,      UICursor_CrossHairs,
    (LPSTR) IDC_IBEAM,      UICursor_IBeam,
    (LPSTR) IDC_SIZENS,     UICursor_NorthSouthArrows,
    (LPSTR) IDC_SIZEWE,     UICursor_EastWestArrows,
    (LPSTR) IDC_UPARROW,    UICursor_UpArrow
};
#endif



#if defined(__OS2__)
static BYTE CrossHairBitmap[] = {
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,

    0x00, 0xff, 0xff, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,

    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff

};

static BYTE UpArrowBitmap[] = {
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x80, 0x00,
    0x00, 0x01, 0x80, 0x00,
    0x00, 0x01, 0x80, 0x00,
    0x00, 0x01, 0x80, 0x00,
    0x00, 0x01, 0x80, 0x00,
    0x00, 0x61, 0x86, 0x00,
    0x00, 0x31, 0x8c, 0x00,
    0x00, 0x19, 0x98, 0x00,
    0x00, 0x0d, 0xb0, 0x00,
    0x00, 0x01, 0x80, 0x00,
    
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff
        
};

static HBITMAP _MakeCursorBitmap (BYTE bitmap[])
{
    BITMAPINFO2       *pbmi;
    BITMAPINFOHEADER2  bmi ;
    memset (&bmi, 0, sizeof bmi);

    bmi.cbFix     = sizeof (BITMAPINFOHEADER2); 
    bmi.cx        = 32;
    bmi.cy        = 64;
    bmi.cPlanes   = 1;
    bmi.cBitCount = 1;

    pbmi = (BITMAPINFO2 *) new uchar [sizeof (BITMAPINFO2) + sizeof (RGB2)];
    memset (pbmi, 0, sizeof (BITMAPINFO2));
    pbmi->cbFix     = sizeof (BITMAPINFOHEADER2);
    pbmi->cx        = 32;
    pbmi->cy        = 64;
    pbmi->cPlanes   = 1;
    pbmi->cBitCount = 1;
    pbmi->cclrUsed  = 2;
    pbmi->argbColor [0].bBlue  = 0;
    pbmi->argbColor [0].bGreen = 0;
    pbmi->argbColor [0].bRed   = 0;
    pbmi->argbColor [1].bBlue  = 255;
    pbmi->argbColor [1].bGreen = 255;
    pbmi->argbColor [1].bRed   = 255;

    
    HPS  hps = WinGetPS (HWND_DESKTOP);
    HBITMAP hbm = GpiCreateBitmap
        (hps, &bmi, CBM_INIT,  bitmap, pbmi);

    WinReleasePS (hps);
    delete [] pbmi;
    return hbm;
}

static HBITMAP _MakeCrossHair ()
{
    return _MakeCursorBitmap (CrossHairBitmap);
}

static HBITMAP _MakeUpArrow   ()
{
    return _MakeCursorBitmap (UpArrowBitmap);
}

#endif

static UI_CursorHandle MakeCursor (UI_CursorType type)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    HCURSOR h;
    if (type == UICursor_Default)
        return 0;
    short n = sizeof CursorCode / sizeof (CodeAssoc);
    short i;
    for (i = 0; i < n; i++) {
        if (CursorCode[i].type == type)
            break;
    }
    h = 0;
    if (i < n)
        h = LoadCursor (NULL, CursorCode[i].code);
    if (!h)
        CL_Error::Warning ("YACL: UI_Cursor Init: Invalid cursor %d",
                           type);
    return h;
#elif defined(__OS2__)
    if (type == UICursor_CrossHairs) {
        HBITMAP hbm = _MakeCrossHair ();
        HPOINTER pt = WinCreatePointer (HWND_DESKTOP, hbm, TRUE, 16, 16);
        GpiDeleteBitmap (hbm);
        return pt;
    }
    if (type == UICursor_UpArrow) {
        HBITMAP hbm = _MakeUpArrow ();
        HPOINTER pt = WinCreatePointer (HWND_DESKTOP, hbm, TRUE, 16, 16);
        GpiDeleteBitmap (hbm);
        return pt;
    }
    ULONG c;
    switch (type) {
    case UICursor_Wait:
        c = SPTR_WAIT;
        break;
        
    case UICursor_IBeam:
        c = SPTR_TEXT;
        break;

    case UICursor_NorthSouthArrows:
        c = SPTR_SIZENS;
        break;
        
    case UICursor_EastWestArrows:
        c = SPTR_SIZEWE;
        break;
        
    case UICursor_UpArrow:
        c = SPTR_SIZE;  // Not sure??
        break;
        
    case UICursor_Arrow:
    case UICursor_Default:
    default:
        c = SPTR_ARROW;
        break;
    };
        
    UI_CursorHandle h = WinQuerySysPointer (HWND_DESKTOP, c, FALSE);
    return h;
#elif defined(__X_MOTIF__)
    if (type == UICursor_Default)
        return 0;
    
    Cursor c;
    switch (type) {
    case UICursor_NorthSouthArrows:
        c = XC_sb_v_double_arrow;
        break;
        
    case UICursor_EastWestArrows:
        c = XC_sb_h_double_arrow;
        break;
        
    case UICursor_UpArrow:
        c = XC_sb_up_arrow;
        break;
        
    case UICursor_Wait:
        c = XC_watch;
        break;
        
    case UICursor_CrossHairs:
        c = XC_crosshair;
        break;
        
    case UICursor_IBeam:
        c = XC_xterm;
        break;
        
    case UICursor_Arrow:
    default:
        c = XC_top_left_arrow;
        break;
    };
        
    UI_CursorHandle h = XCreateFontCursor (YACLApp()->AppDisplay(), c);
    return h;
#endif
}



UI_Cursor::UI_Cursor (UI_CursorType type)
{
    _type = type;
    _handle = MakeCursor (type);
}



UI_Cursor::~UI_Cursor ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_type == UICursor_Default && _handle)
        DestroyCursor (_handle);
#elif defined(__OS2__)
    if (_type == UICursor_CrossHairs)
        WinDestroyPointer (_handle);
#endif
}







void UI_Cursor::operator= (UI_CursorType type)
{
    if (type == _type || !PrepareToChange())
        return;
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    HCURSOR h = MakeCursor (type);
    if (h) {
        _Destroy ();
        _handle = h;
        _type   = type;
    }
    else
        CL_Error::Warning ("YACL: UI_Cursor::op=: cursor type %d: "
                           "unknown type", type);
#elif defined(__OS2__) || defined(__X_MOTIF__)
    _type = type;
    _handle = MakeCursor (type);
#endif
    Notify();
}


// Change this cursor to be the one with the given name
void UI_Cursor::operator= (const char* cursor_name)
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!PrepareToChange())
        return;
    HCURSOR h = LoadCursor (YACLApp()->ProcessId(), cursor_name);
    if (h) {
        _Destroy();
        _handle = h;
        _name = cursor_name;
        _type = UICursor_Default;
    }
    else 
        CL_Error::Warning ("YACL: Cursor::op= (string): LoadCursor "
                           "%s failed", cursor_name);
    Notify();
#else
    CL_Error::Warning ("Cursor::op= ('%s'): "
                       "not yet implemented", cursor_name);
#endif
}


void UI_Cursor::_Destroy ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle)
        DestroyCursor (_handle);
    _handle = 0;
    _name = "";
    _type = UICursor_Default;
#endif
}



bool UI_Cursor::operator== (const UI_Cursor& c) const
{
    return (_type != UICursor_Default) ? (_type == c._type)
        : (_name == c._name);
}




