



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#    include <string.h>
#    include "ui/uidefs.h"
     BOOL CALLBACK YACL_UI EnumCallback (HWND hwnd, LPARAM param);
#    define WINDOW_STYLE WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CLIPCHILDREN | \
     WS_BORDER | WS_MINIMIZEBOX | WS_MAXIMIZEBOX
#elif defined(__OS2__)
#    define DEFAULT_COMPOSITE_STYLE \
     FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MINMAX
#    include <stdlib.h>
#elif defined(__X_YACL__)
#    include <iostream.h> // DEBUG only
#    include <X11/Xlib.h>
#    include <X11/Xutil.h>
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/BulletinB.h>
#    include <X11/Shell.h>
#    include <Xm/Xm.h>
#    include <Xm/Protocols.h>
#    include <Xm/AtomMgr.h>
#    include <Xm/MwmUtil.h>
#    include <Xm/MainW.h>
#    include <iostream.h> // DEBUG only

#    include "ui/support/x_motif/ycomp.h"
#endif


#include "base/bytstrng.h"

#include "ui/composit.h"
#include "ui/bmpushbn.h"
#include "ui/bmtglbtn.h"
#include "ui/cntroler.h"
#include "ui/pushbtn.h"
#include "ui/combobox.h"
#include "ui/toglbtn.h"
#include "ui/xrtglbtn.h"
#include "ui/stred.h"
#include "ui/dialog.h"
#include "ui/font.h"
#include "ui/label.h"
#include "ui/strview.h"
#include "ui/textedit.h"
#include "ui/scrolbar.h"
#include "ui/menu.h"
#include "ui/orbtngrp.h"
#include "ui/xrbtngrp.h"


// ---------------------- UI_CompositeVObject code --------------------


#if defined(__OS2__) && defined(__IBMCPP__)
inline MRESULT EXPENTRY CallBackFrameProc( HWND hWnd, ULONG msg,
                                           MPARAM p1, MPARAM p2)
{
    return UI_CompositeVObject::FrameProc( hWnd, msg, p1, p2);
}
#endif


UI_CompositeVObject :: UI_CompositeVObject 
     ( UI_CompositeVObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_VObjCollection (parent, shape, id)
{
    _stickToParent = FALSE; // Non-sticky by default
    _Init ();
}

UI_CompositeVObject :: UI_CompositeVObject 
     ( UI_CompositeVObject* parent, UI_ViewDescriptor* vd, bool sticky,
       const UI_Rectangle& shape, UI_ViewID id
     )
: UI_VObjCollection (parent, shape, id)
{
    _stickToParent = sticky;
    _Init ();
    if (vd) {
        for (short i = 0; vd[i].type != View_None; i++) {
            if ( !CreateChild (vd[i]) )
                break;
        }
    }
}


typedef UI_EventBinding1<UI_CompositeVObject> CompositeBind;

#if defined(__GNUC__)
template class UI_EventBinding1<UI_CompositeVObject>;
#elif defined(_MSC_VER)
template UI_EventBinding1<UI_CompositeVObject>;
#endif


void UI_CompositeVObject::_Init ()
{
    _menuBar       = NULL;
    _currentChild  = -1;
    _isTabStop     = _stickToParent; 
    _iconified     = FALSE;
    _minWidth      = 0;
    _minHeight     = 0;
    _maxWidth      = 32767;
    _maxHeight     = 32767;
    if (!_stickToParent) {
        _borderShown = TRUE;
        _font        = NULL; // Don't retain copy of parent's font
    }
    CompositeBind bind (this, &UI_CompositeVObject::_EventOccurred);
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _3dLook = _stickToParent ? _parent->Has3DLook() : FALSE;
    if (_3dLook)
        _bgColor = UIColor_MediumGray;
    else {
        COLORREF clr = GetSysColor (COLOR_WINDOW);
        _bgColor = UI_Color (((double) GetRValue (clr)/255.0),
                             ((double) GetGValue (clr)/255.0),
                             ((double) GetBValue (clr)/255.0));
    }
    if (_parent == NULL) {
        // Set the style of the root window
        _style = WINDOW_STYLE;
    }
    else {
        // Non-root window
        if (_stickToParent) {
            _style = WS_CHILD;
            if (_visible)
                _style |=  WS_VISIBLE;
            if (_borderShown)
                _style |= WS_BORDER;
        }
        else
            _style = WINDOW_STYLE;
    }
#if !defined(USE_CTL3D)
    // For Win95/NT4.0
    _style |= 4L;
#endif
    if (!_parent || !_stickToParent)
        _id = 0;
    _titleBarShown = _style & WS_CAPTION ? TRUE : FALSE;

#elif defined(__OS2__)
    long clr     = WinQuerySysColor (HWND_DESKTOP, SYSCLR_WINDOW, 0L);
    _bgColor     = UI_Color
        (((double) ((clr & 0xff0000) >> 16)) / UI_MAXCOLORS,
         ((double) ((clr & 0x00ff00) >>  8)) / UI_MAXCOLORS,
         ((double) ((clr & 0x0000ff)      )) / UI_MAXCOLORS);
    _frameHandle        = 0;
    _cursor             = UICursor_Arrow;
    _style              = _stickToParent ?  WS_VISIBLE | WS_CLIPCHILDREN : 0;
    _frameCreationFlags = DEFAULT_COMPOSITE_STYLE;
    _frameStyle         = WS_ANIMATE;
    _titleBarShown      = _stickToParent ? FALSE : TRUE;
#elif defined(__X_MOTIF__)
    _titleBarShown = _stickToParent ? FALSE : TRUE;
    _mainWindow = NULL;
    _shell = _parent ? (Widget) NULL : _Controller->RootShell();
#endif

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    // Need focus management under Windows and OS/2
    AddEventDependent (Event_LButtonRelease, bind);
#endif

    AddEventDependent (Event_KeyTyped,       bind);
    AddEventDependent (Event_ChildCreated,   bind);
    AddEventDependent (Event_Iconify,        bind);
    AddEventDependent (Event_Deiconify,      bind);
    _model = new CL_IntPtrMap;
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
static UI_VObjCollection* _CurrentGroup = NULL;
static UI_ViewID          _CurrentGroupId = 0;
static UI_ViewHandle      _CurrentGroupHandle = 0;


UI_CompositeVObject::UI_CompositeVObject
  (UI_CompositeVObject* parent, const char *rsrc, UI_ViewID id)
: UI_VObjCollection (parent, UI_Rectangle(), id)
{
    // Resource-based construction
    _menuBar       = NULL;
    _stickToParent = FALSE;
    _currentChild  = -1;
    _rname = rsrc;
    _CurrentGroup = NULL; // Used only in CreateResourceChild
    _CurrentGroupId = 0;  // Ditto
    _model = new CL_IntPtrMap;
    _3dLook = FALSE;

    HANDLE hInst = _Application->ProcessId();
    _handle = CreateDialogParam
        (hInst, (char*) _rname.AsPtr(), _parent ? _parent->ViewHandle() : NULL,
         (FARPROC) YACLDialogProc, 0L);
    const short MAX_TITLE_LEN = 1000;
    CL_ByteString titleStrg (MAX_TITLE_LEN); // Big  enough for most titles
    SendMessage (_handle, WM_GETTEXT, MAX_TITLE_LEN, (long) titleStrg.AsPtr());
    _SetTitle ((char*) titleStrg.AsPtr());
    _style = GetWindowLong (_handle, GWL_STYLE);
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
    if (_handle)
        EnumChildWindows (_handle, (FARPROC) EnumCallback, (long) this);

    CompositeBind bind (this, &UI_CompositeVObject::_EventOccurred);
    AddEventDependent (Event_ChildCreated,   bind);
    AddEventDependent (Event_LButtonRelease, bind);
    AddEventDependent (Event_KeyTyped,       bind);
    AddEventDependent (Event_Iconify,        bind);
    AddEventDependent (Event_Deiconify,      bind);
}
#endif


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
void UI_CompositeVObject::Set3DLook ()
{
    _3dLook = TRUE;
}

bool UI_CompositeVObject::Has3DLook () const
{
    return     _3dLook ? TRUE : (_parent ? _parent->Has3DLook() : FALSE);
}


#endif


CL_Object& UI_CompositeVObject::Model ()
{
    // Update all the models. This is needed so that the component objects
    // can update their model values from the underlying window system.
    CL_IntPtrMap& model_map = *(CL_IntPtrMap*) _model;
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        UI_VisualObject* v = (UI_VisualObject*) assoc.value;
        UI_ViewID id = v->ViewID();
        if (model_map.IncludesKey (id))
            model_map[id] = & (v->Model());
    }
    return *_model;
}



#if defined(__OS2__)
MRESULT
#if !defined(__IBMCPP__)
EXPENTRY
#endif
UI_CompositeVObject::FrameProc (HWND hWnd, ULONG msg,
                                MPARAM p1, MPARAM p2)
{
    HWND hClient = WinWindowFromID (hWnd, FID_CLIENT);
    UI_CompositeVObject* v = (UI_CompositeVObject*) (*_Controller)[hClient];
    if (!v)
        return WinDefWindowProc (hWnd, msg, p1, p2);
    if (msg == WM_QUERYTRACKINFO) {
        MRESULT res = (*(v->_oldFrameProc)) (hWnd, msg, p1, p2);
            // Do default  processing 
        TRACKINFO* p = (TRACKINFO*) p2;
        p->ptlMinTrackSize.x = v->MinWidth();
        p->ptlMinTrackSize.y = v->MinHeight();
        p->ptlMaxTrackSize.x = v->MaxWidth();
        p->ptlMaxTrackSize.y = v->MaxHeight();
        return res;
    }
    return (*(v->_oldFrameProc)) (hWnd, msg, p1, p2);
}
#endif



#if defined(__X_YACL__)
static void  _SetWindowTitle (Window w, const char* title)
{
    char* text = (char*) title;
    XTextProperty textProp;
    if (XStringListToTextProperty (&text, 1, &textProp))
        XSetWMName (YACLApp()->AppDisplay(), w, &textProp);
}
#elif defined(__X_MOTIF__)
void _SetWindowTitle (Widget xWidget, const CL_String& title)
{
    // Need to do this only for non-sticky children under X: they have a
    // shell, and its title must be changed, not that of the Composite.
    Arg args [3];
    XmString xmtitle;

    xmtitle = XmStringCreate ((char*)title.AsPtr(), XmSTRING_DEFAULT_CHARSET);

    XtSetArg    (args [0], XmNdialogTitle, xmtitle);
    XtSetArg    (args [1], XmNlabelString, xmtitle);
    XtSetArg    (args [2], XmNtitle,       title.AsPtr());
    Widget w = xWidget;
    while (w && !XtIsVendorShell (w)) {
        xWidget = w;
        w = XtParent (w);
    }
    if (w)
        XtSetValues (w, args, 3);
    if (xWidget)
        XtSetValues (xWidget, args, 1);
    XmStringFree (xmtitle); // No leaks allowed
}


bool UI_CompositeVObject::_CursorChanged ()
{
    _Controller->ChangeCursor (_shell, _cursor);
} 
#endif



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
void UI_CompositeVObject::SetStyle ()
{
    if (!_visible)
        _style &= ~WS_VISIBLE;
    if (!_stickToParent) {
        if (!_titleBarShown) {
            _style &= ~(WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX |
                        WS_MAXIMIZEBOX);
            _style |= WS_POPUP | WS_BORDER;
        }
        if (!_borderShown) {
            _style &= ~(WS_DLGFRAME | WS_THICKFRAME);
            _style |= WS_BORDER;
        }
    }
}

ulong UI_CompositeVObject::ExtendedStyle () const
{
    return WS_EX_ACCEPTFILES;
}

#elif defined(__OS2__)
void UI_CompositeVObject::SetStyle ()
{
    if (!_titleBarShown)
        _frameCreationFlags &= ~(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX);
    if (!_borderShown) {
        _frameCreationFlags &= ~(FCF_MINMAX | FCF_SIZEBORDER);
        if (!_stickToParent)
            _frameCreationFlags |=  FCF_BORDER;
    }
    if (!_parent) // This is the main window
        _frameCreationFlags |= FCF_TASKLIST;
}
#endif

bool UI_CompositeVObject::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    HANDLE hInst = _Application->ProcessId();
    const char* label = (_title.Length() > 0) ? _title.AsPtr() : NULL;
    if(_rname.Size ())
        // Resource-based dialog
        return TRUE;
    // Generic window
    int x = CW_USEDEFAULT, y = CW_USEDEFAULT, w = CW_USEDEFAULT,
        h = CW_USEDEFAULT;
    if (_shape != UI_Rectangle (0, 0, 0, 0)) {
        RECT shapeRect = _shape.AsMSRect ();
        if (!_parent || !_stickToParent)
            AdjustWindowRect (&shapeRect, _style, _menuBar ? TRUE : FALSE);
        x = shapeRect.left;
        y = shapeRect.top;
        if (_parent) {
            // Position it with respect to its parent
            x += _parent->Shape().Left();
            y += _parent->Shape().Top();
        }
        w = shapeRect.right - shapeRect.left;
        h = shapeRect.bottom - shapeRect.top;
        if (!w)
            w = CW_USEDEFAULT;
        if (!h)
            h = CW_USEDEFAULT;
    }
    const char* class_name = WindowClass ();
    SetStyle ();
    HWND parentHandle = _parent ? _parent->ViewHandle() : 0;
    _handle = CreateWindowEx
        (ExtendedStyle(), class_name, label, (_style & ~WS_VISIBLE),
         //                                  ^^^^^^^^^^^^^^^^^^^^^^
         // Keep it initially invisible: the controller code (in
         // winevt.cxx) will later make it visible. This is necessary so
         // that the dialog is correctly drawn in 3d.
         x, y, w, h,
         parentHandle, (HMENU) (_stickToParent ? _id : 0), (HANDLE) hInst,
         NULL);
    if (!_handle) {
        CL_String s;
        s.AssignWithFormat
            ("CompositeVObject CreateWindow failed:\nClass %s ID %d: %s",
             class_name, _id, _Application->ErrorString().AsPtr());
        CL_Error::Warning (s.AsPtr());
        return FALSE;
    }

#elif defined(__X_MOTIF__)
    Arg args [9];
    short argn = 0;
    
    CL_String xname(InstanceName());
    
    _SetupStyle (args, argn);
    XtSetArg (args[argn], XmNresizePolicy, XmRESIZE_NONE); argn++;
    
    if (!_parent && !_shell)
        CL_Error::Fatal ("CompositeVObject::MakeVisualElement: "
                         "Root window creation failed");
                         
    // Create a sticky child (BulletinBoard)                     
    if (_stickToParent) { 
        _xwidget = _mainWindow = XtCreateWidget
            (xname.AsPtr(), yCompositeWidgetClass, // xmBulletinBoardWidgetClass, 
             _parent->ViewHandle(), args, argn);
    }
    else {
        // Set the title of the shell widget
        // Do not destroy the shell widget in response to user
        // requests; the library will take care of it.
        
        XtSetArg (args [argn], XmNtitle, (char*) _title.AsPtr()); argn++;
        XtSetArg (args [argn], XmNdeleteResponse, XmDO_NOTHING); argn++;
        if (_shell == NULL) {
            _shell = XtAppCreateShell
                (YACLApp()->Name().AsPtr(), (const char*)(xname + "_shell"),
                 topLevelShellWidgetClass, // vendorShellWidgetClass,
                 XtDisplay(YACLApp()->Controller().RootShell()),
                 args, argn);
        }
        _mainWindow = XtCreateWidget
            ((xname + "_main").AsPtr(), xmMainWindowWidgetClass, _shell,
             args, argn-1);
        _xwidget = XtCreateWidget
            (xname.AsPtr(), yCompositeWidgetClass, //xmBulletinBoardWidgetClass,
             _mainWindow, 0, 0);
        XtVaSetValues (_xwidget, XmNresizePolicy, XmRESIZE_ANY, NULL);
        XtVaSetValues (_mainWindow, XmNworkWindow, _xwidget, NULL);
        if (_parent)
            XtVaSetValues (_shell,
                           XmNx, _shape.Left() + _parent->Shape().Left(),
                           XmNy, _shape.Top() + _parent->Shape().Top(),
                           XmNmappedWhenManaged, FALSE,
                           NULL);
        if (_visible)
            XtManageChild (_mainWindow);
    };
    _SetWindowTitle(_xwidget, _title); //  Initial setting
    if (!_stickToParent) {
        long decorFlags = MWM_DECOR_BORDER;
        if (_borderShown)
            decorFlags |= MWM_DECOR_RESIZEH;
        if (_titleBarShown)
            decorFlags |= MWM_DECOR_TITLE | MWM_DECOR_MENU |
                MWM_DECOR_MAXIMIZE | MWM_DECOR_MINIMIZE;
        long funcFlags = 0;
        if (_borderShown)
            funcFlags |= MWM_FUNC_RESIZE;
        if (_titleBarShown)
            funcFlags |= MWM_FUNC_MOVE |
                MWM_FUNC_MAXIMIZE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
        XtVaSetValues (_shell,
                       XmNminWidth,       _minWidth,
                       XmNmaxWidth,       _maxWidth,
                       XmNminHeight,      _minHeight,
                       XmNmaxHeight,      _maxHeight,
                       XmNmwmDecorations, decorFlags,
                       XmNmwmFunctions,   funcFlags,
                       NULL
                      );
    }
#elif defined(__X_YACL__)
    if (!_parent || !_stickToParent) {
        Display* dp = _Controller->AppDisplay();
        int screenNo = DefaultScreen (dp);
        _window = XCreateSimpleWindow
            (dp, RootWindow (dp, screenNo), _shape.Left(), _shape.Top(),
             _shape.Width(), _shape.Height(), 0,
             BlackPixel (dp, screenNo), _bgColor.XPixel());
        XSelectInput (dp, _window,
                      EnterWindowMask | LeaveWindowMask |
                      PointerMotionMask |
                      Button1MotionMask | Button2MotionMask |
                      Button3MotionMask |
                      ExposureMask |
                      KeyPressMask | KeyReleaseMask |
                      ButtonPressMask | ButtonReleaseMask |
                      StructureNotifyMask);

        Atom dele = XInternAtom (dp, "WM_DELETE_WINDOW", False);
        XSetWMProtocols (dp, _window, &dele, 1);
        _SetWindowTitle(_window, _title); //  Initial setting
        XSizeHints hints;
        hints.flags = PPosition | PSize | PMinSize | PMaxSize;
        hints.min_width  = _minWidth;
        hints.max_width  = _maxWidth;
        hints.min_height = _minHeight;
        hints.max_height = _maxHeight;
        hints.width      = _shape.Width();
        hints.height     = _shape.Height();
        XSetWMProperties (dp, _window, NULL, NULL, 0, 0, &hints, NULL, NULL);
        if (_visible)
            XMapWindow (dp, _window);
    }
#elif defined(__OS2__)
    if (_parent && _stickToParent)
        return UI_VObjCollection::MakeVisualElement ();

    // So now let's worry about stand-alone windows
    HWND parentHandle = ParentHandle();
    SetStyle();
    _frameHandle = WinCreateStdWindow
        (parentHandle, _frameStyle, &_frameCreationFlags,
         WindowClass(), _title.AsPtr(), _style, 0, _id, &_handle);
    // Fix due to Tony T. Ton:
//     _frameHandle = WinCreateStdWindow
//         (HWND_DESKTOP, WS_SYNCPAINT | WS_ANIMATE | WS_CLIPCHILDREN |
//          WS_CLIPSIBLINGS,
//          &_style,
//          WindowClass(), _title.AsPtr(),
//          WS_CLIPCHILDREN | WS_CLIPSIBLINGS, 0, _id, &_handle);
    
    if (!_frameHandle || !_handle) {
        UI_Application::PMError ();
        CL_Error::Warning ("YACL: CompositeVObject CreateWindow failed");
        return FALSE;
    }

    if (_shape != UI_Rectangle (0, 0, 0, 0)) {
        // Compute the required frame rectangle; remember that _shape is
        // specified assuming that YACL uses origin at top left corner, but
        // OS/2 uses origin at bottom left corner.
        RECTL boundary;
        _ComputeWindowShape (boundary);
        ulong swpFlags = SWP_SIZE | SWP_MOVE;
        if (_visible)
            swpFlags |= SWP_ACTIVATE | SWP_SHOW;
        WinSetWindowPos (_frameHandle, HWND_TOP,
                         boundary.xLeft, boundary.yBottom,
                         boundary.xRight - boundary.xLeft + 1,
                         boundary.yTop   - boundary.yBottom + 1, swpFlags);
    }
#if defined(__IBMCPP__)
    _oldFrameProc = WinSubclassWindow (_frameHandle, CallBackFrameProc);
#else
    _oldFrameProc = WinSubclassWindow (_frameHandle,
                                       UI_CompositeVObject::FrameProc);
#endif
#endif
    return TRUE;
}



#if defined(__OS2__)
void UI_CompositeVObject::_ComputeWindowShape (RECTL& boundary)
{
    HWND parentHandle = ParentHandle();
    long parentHeight = _YACLWindowHeight (parentHandle);
    long left   = _shape.Left(),   top   = _shape.Top ();
    long height = _shape.Height(), width = _shape.Width ();
    boundary.xLeft   = left;
    boundary.yBottom = parentHeight - top - height;
    boundary.xRight  = left + width - 1;
    boundary.yTop    = parentHeight - top;
    WinMapWindowPoints (_handle, parentHandle, (PPOINTL) &boundary, 2);
    WinCalcFrameRect   (_frameHandle, &boundary, FALSE);
}

HWND UI_CompositeVObject::ParentHandle () const
{
    return HWND_DESKTOP;
}
#endif


void UI_CompositeVObject::MakeVisible ()
{
#if defined(__OS2__)
    if (_stickToParent)
        WinShowWindow (_handle, TRUE);
    else if (_frameHandle)
        WinSetWindowPos (_frameHandle, HWND_TOP, 0, 0, 0, 0,
                         SWP_SHOW | SWP_ACTIVATE); 
#elif defined(__X_MOTIF__)
    if (!_stickToParent && _shell && XtIsRealized (_shell)) {
        XtManageChild (_mainWindow);
        XtMapWidget(_shell);
    }
#endif
    UI_VObjCollection::MakeVisible ();
}



void UI_CompositeVObject::MakeInvisible ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_VObjCollection::MakeInvisible ();
#elif defined(__OS2__)
    UI_VObjCollection::MakeInvisible ();
    if (_frameHandle)
        WinShowWindow (_frameHandle, FALSE);
#elif defined(__X_MOTIF__)
    UI_VObjCollection::MakeInvisible();
    if (!_stickToParent && _shell && XtIsRealized (_shell)) {
        XtUnmanageChild (_mainWindow);
        XtUnmapWidget(_shell);
    }
#endif
}



void UI_CompositeVObject::SetMinWidth (short w)
{
    _minWidth = w;
#if defined(__X_MOTIF__)
    if (!_stickToParent && _xwidget)
        XtVaSetValues (XtParent (_xwidget), XmNminWidth, w, NULL);
#endif
}

void UI_CompositeVObject::SetMinHeight (short h)
{
    _minHeight = h;
#if defined(__X_MOTIF__)
    if (!_stickToParent && _xwidget)
        XtVaSetValues (XtParent (_xwidget), XmNminHeight, h, NULL);
#endif
}

void UI_CompositeVObject::SetMaxWidth (short w)
{
    _maxWidth = w;
#if defined(__X_MOTIF__)
    if (!_stickToParent && _xwidget)
        XtVaSetValues (XtParent (_xwidget), XmNmaxWidth, w, NULL);
#endif
}

void UI_CompositeVObject::SetMaxHeight (short h)
{
    _maxHeight = h;
#if defined(__X_MOTIF__)
    if (!_stickToParent && _xwidget)
        XtVaSetValues (XtParent (_xwidget), XmNmaxHeight, h, NULL);
#endif
}

UI_Rectangle UI_CompositeVObject::WindowShape () const
{
#if defined(__OS2__)
    if (_stickToParent)
        return _shape;
    RECTL rect;
    WinQueryWindowRect (_frameHandle, &rect);
    return _Application->YACLRect (_parent ? _parent->ViewHandle()
                                   : HWND_DESKTOP,
                                   rect);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!_handle)
        return UI_Rectangle ();
    RECT msrec;
    GetWindowRect (_handle, &msrec);
    return UI_Rectangle (msrec.left, msrec.top, msrec.right - msrec.left + 1,
                         msrec.bottom - msrec.top + 1);
#else
    return _shape;
#endif
}


bool UI_CompositeVObject::DestroyVisualElement ()
{
    DestroyDisplaySurface ();

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (_handle) {
        DestroyWindow (_handle);
        return TRUE;
    }
    return FALSE;

#elif defined(__X_MOTIF__)
    if(!_stickToParent)
        XtDestroyWidget(_xwidget);
    if (_mainWindow)
        XtDestroyWidget(_mainWindow);
    if(_shell)
        XtDestroyWidget(_shell);
        
    _mainWindow = _xwidget = _shell = NULL;
    return TRUE;
#elif defined(__OS2__)
    if (!_parent) {
        HSWITCH hSw = WinQuerySwitchHandle (_frameHandle, 0);
        WinRemoveSwitchEntry (hSw);
    }
    WinDestroyWindow (_frameHandle);
    return TRUE;
#elif defined(__X_YACL__)
    XDestroyWindow (_Controller->AppDisplay(), _window);
#endif

}

    


UI_VisualObject* UI_CompositeVObject::CreateChild (const UI_ViewDescriptor& vd)
{
    if (_objMap.IncludesKey (vd.id)) {
        CL_Error::Warning ("YACL: Duplicate child id %ld for composite",
                           vd.id);
        return NULL;
    }
    UI_VisualObject* p;
    UI_Rectangle shape (vd.shape.x, vd.shape.y, vd.shape.w, vd.shape.h);
    switch (vd.type) {

    case View_OrButtonGroup:
        p = new UI_OrButtonGroup (this, shape, vd.id, vd.enclosed);
        p->Title () = vd.title;
        break;

    case View_ExOrButtonGroup:
        p = new UI_ExOrButtonGroup (this, shape, vd.id, vd.enclosed);
        p->Title () = vd.title;
        break;

    case View_PushButton:
        p = new UI_PushButton (this, shape, vd.id);    
        p->Title()= vd.title;
        break;

    case View_ToggleButton:
        p = new UI_ToggleButton (this, shape, vd.id);  
        p->Title() = vd.title;
        break; 

    case View_ExOrToggleButton:
        p = new UI_ExOrToggleButton (this, shape, vd.id);  
        p->Title() = vd.title;
        break; 

      
    case View_Label:
        p = new UI_Label (this, shape, vd.id);
        ((UI_Label*) p)->Title () = vd.title;
        break;

    case View_StringEditor:
        p = new UI_StringEditor (this, shape, vd.id);
        ((CL_String&) (((UI_SimpleVObject*) p)->Model ())) = vd.title;
        break;


    case View_TextView:
        p = new UI_TextEditor (this, shape, vd.id);
        ((CL_String&) (((UI_SimpleVObject*) p)->Model ())) = vd.title;
        break;

    case View_StringViewSingle:
        p = new UI_StringViewSingleSel (this, shape, vd.id);
        break;
    
    case View_HScrollBar:
        p = new UI_HScrollBar (this, shape, vd.id);
        break;

    
    case View_VScrollBar:
        p = new UI_VScrollBar (this, shape, vd.id);
        break;


    case View_StringViewMulti:
        p = new UI_StringViewMultiSel (this, shape, vd.id);
        break;

    case View_ComboBox:
        p = new UI_ComboBox (this, shape, vd.id, shape.Height());
        break;

    case View_Composite:
        p = new UI_CompositeVObject (this, vd.enclosed, TRUE, shape,
                                     vd.id);
        break;

    case View_BitmapPushButton:
        p = new UI_BitmapPushButton (this, shape, vd.id);
        break;

    case View_BitmapToggleButton:
        p = new UI_BitmapToggleButton (this, shape, vd.id);
        break;


    default:
        p = NULL;
        break;
    } // end of switch

    if ( p && vd.type != View_Composite ) {
        UI_ViewID id = p->ViewID();

        if (id > 0 && id <= 32767) {
            ((CL_IntPtrMap*) _model)->Add (id, &(p->Model()));
            if (vd.type != View_OrButtonGroup &&
                vd.type != View_ExOrButtonGroup)
                ((UI_SimpleVObject*) p)->TabStop (vd.tab_stop);
        }
    }
    return p;
}




UI_CompositeVObject::~UI_CompositeVObject()
{
    if (_model)
        delete _model;
}







void UI_CompositeVObject::ShowTitleBar ()
{
    if (!_stickToParent)
        return;
    _titleBarShown = TRUE;
    if (!ViewHandle())
        return;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = GetWindowLong (_handle, GWL_STYLE);
    _style |= (WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);
    _style &= ~WS_POPUP;
    SetWindowLong (_handle, GWL_STYLE, _style);
    SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | 
                   SWP_NOSIZE | SWP_NOMOVE | 
                   SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
#elif defined(__OS2__)
    _style = WinQueryWindowULong (_frameHandle, QWL_STYLE);
    _style |= (FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX);
    WinSetWindowULong (_frameHandle, QWL_STYLE, _style);
    WinUpdateWindow   (_frameHandle);
#elif defined(__X_MOTIF__)
    if (_stickToParent && _xwidget) {
        XtVaSetValues (_xwidget, XtNtransient, TRUE, 0);
        XtVaSetValues (_shell, XtNtransient,     FALSE,
                       XmNmwmDecorations, -1,
                       XmNmwmFunctions,   -1, 0);
    }
#endif
}


void UI_CompositeVObject::HideTitleBar ()
{
    if (_stickToParent)
        return;
    _titleBarShown = FALSE;
    if (!ViewHandle())
        return;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = GetWindowLong (_handle, GWL_STYLE);
    _style &= ~(WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);
    _style |= WS_POPUP | WS_BORDER;
    SetWindowLong (_handle, GWL_STYLE, _style);
    SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | 
                   SWP_NOSIZE | SWP_NOMOVE | 
                   SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
#elif defined(__OS2__)
    ulong style = WinQueryWindowULong (_frameHandle, QWL_STYLE);
    style &= ~(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX);
    WinSetWindowULong (_frameHandle, QWL_STYLE, style);
    WinUpdateWindow   (_frameHandle);
#elif defined(__X_MOTIF__)
    XtVaSetValues (_shell, XtNtransient,     FALSE, 0);
    XtVaSetValues (_shell, XmNmwmDecorations,
                   MWM_DECOR_BORDER, 0);
    XtVaSetValues (_shell, XmNmwmFunctions,   0, 0);
#endif
}


bool UI_CompositeVObject::IsTitleBarShown ()
{
    return !_stickToParent && _titleBarShown;
}


bool UI_CompositeVObject::_DoShowBorder (bool show)
{
    _borderShown = show;
    if (!ViewHandle() || !_stickToParent)
        return TRUE;
#if defined(__X_MOTIF__)
    if (!UI_VisualObject::_DoShowBorder(show))
        return FALSE;
    long val = 0;
    if (show) {
        XtVaGetValues (_shell, XmNmwmDecorations, &val, 0);
        val |= MWM_DECOR_RESIZEH;
        XtVaSetValues (_shell, XmNmwmDecorations, val, 0);
        
        XtVaGetValues (_shell, XmNmwmFunctions, &val, 0);
        val |= MWM_FUNC_RESIZE;
        XtVaSetValues (_shell, XmNmwmFunctions,   val, 0);
    }
    else {
        XtVaGetValues (_shell, XmNmwmDecorations, &val, 0);
        val &= ~MWM_DECOR_RESIZEH;
        XtVaSetValues (_shell, XmNmwmDecorations, val, 0);
        
        XtVaGetValues (_shell, XmNmwmFunctions, &val, 0);
        val &= ~MWM_FUNC_RESIZE;
        XtVaSetValues (_shell, XmNmwmFunctions,   val, 0);
    }
    return TRUE;
#elif defined(__OS2__)
    ulong style = WinQueryWindowULong (_frameHandle, QWL_STYLE);
    if (show)
        style |= _stickToParent ? FCF_BORDER : FCF_SIZEBORDER;
    else {
        style &= ~(FCF_MINMAX | FCF_SIZEBORDER);
        if (!_stickToParent)
            style |= FCF_BORDER;
    }
    WinSetWindowULong (_frameHandle, QWL_STYLE, style);
    WinUpdateWindow   (_frameHandle);
    return TRUE;
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = GetWindowLong (_handle, GWL_STYLE);
    if (show)
        _style |= (WS_DLGFRAME | WS_THICKFRAME | WS_BORDER);
    else {
        _style &= ~(WS_DLGFRAME | WS_THICKFRAME);
        if (!_stickToParent)
            _style |= WS_BORDER;
    }
    SetWindowLong (_handle, GWL_STYLE, _style);
    SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | 
                   SWP_NOSIZE | SWP_NOMOVE | 
                   SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
    return TRUE;
#endif
}






void UI_CompositeVObject::_PrivateInitialize()
{
    UI_VisualObject::_PrivateInitialize ();
    if (_menuBar) {
        // Tell my children that I have a MenuBar, so that they can adjust
        // their positions
        CL_IntPtrMapIterator itr (_objMap);
        while (itr.More()) {
            CL_IntPtrAssoc assoc = itr.Next();
            UI_VisualObject* child = (UI_VisualObject*) assoc.value;
            child->AdjustPosition ();
        }
    }
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if ( _menuBar && _menuBar->ViewHandle() > 0 )
        DrawMenuBar ( _menuBar->ViewHandle() );
#elif defined(__X_MOTIF__)

    Arg args [2];
    XmString xmtitle;

    xmtitle = XmStringCreate ((char*)_title.AsPtr(), XmSTRING_DEFAULT_CHARSET);

    XtSetArg    (args [0], XmNdialogTitle, xmtitle);
    XtSetArg    (args [1], XmNlabelString, xmtitle);
    XtSetValues (_xwidget, args, 2);
    XtVaSetValues (_xwidget, XmNmarginWidth, 0, XmNmarginHeight, 0, NULL);
    if (!_parent || !_stickToParent) {
        Atom a = XmInternAtom (XtDisplay(_shell), "WM_DELETE_WINDOW",
                               FALSE);
        XmAddWMProtocolCallback
            (_shell, a,
             (XtCallbackProc)  &UI_CompositeVObject::DeleteWindowCallback,
             (XtPointer) this);
        XtVaSetValues (_shell, XmNmappedWhenManaged, FALSE, NULL);
    }
    XmStringFree (xmtitle); // No leaks allowed
#endif
    if (!_visible)
        MakeInvisible();
}


#if defined (__X_MOTIF__)
void UI_CompositeVObject::DeleteWindowCallback
    (Widget , void* client, void* )
{
    UI_CompositeVObject* v = (UI_CompositeVObject*) client;
    v->_Controller->AddEvent (new UI_Event (Event_CloseDown, v, v));
}
#endif




//
//------------------Composite Methods------------------------------
//




bool UI_CompositeVObject::HandleChildEvent (const UI_Event& /* e */)
{
    return FALSE;
}


bool UI_CompositeVObject::_EventOccurred (UI_Event& e)
{
    UI_EventType type = e.Type();
    UI_VisualObject* v = e.Origin();
    switch (type) {
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    // Focus management is only needed under Windows and OS/2
    case Event_ChildCreated: {
        if (v->Parent() != this)
            break;
        short pos = -1;
        if (v->IsTabStop()) {
            pos = _tabSequence.Add (v);
            if (_currentChild == -1 && v->IsVisible() && v->IsEnabled()) {
                _currentChild = pos;
                v->TakeFocus();
            }
        }
        break;
    }
    
    case Event_LButtonRelease: {
        // Mouse was clicked on some descendant of this vObj in the view
        // tree.
        if (v == this)  // Wasn't a descendant, it was me
            break;
        // Find the child whose descendant got the click
        UI_VisualObject* obj = v;
        UI_VisualObject* parent = obj->Parent();
        while (parent != this) {
            obj = parent;
            parent = parent->Parent();
        }
        // Move focus to the child
        MoveFocusTo (obj);
        break;
    }
        
    case Event_KeyTyped:
        if (e.Type () == Event_KeyTyped && e.Key() == '\011') {
            if (e.Destination() == this) 
                return !AdvanceFocus (e.ShiftKeyPressed() ? -1 : 1);
            else
                return FALSE;
        }
        else
            return TRUE;
            
#endif // Windows or OS2

    case Event_Iconify:
        _iconified = TRUE;
        break;

    case Event_Deiconify:
        _iconified = FALSE;
        break;

    default:
        break;
    };

    return TRUE;
}



UI_WindowClass UI_CompositeVObject::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_MOTIF__)
    return (_stickToParent) ? yCompositeWidgetClass
       : xmMainWindowWidgetClass;
#endif
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

BOOL CALLBACK YACL_UI EnumCallback (HWND hwnd, LPARAM param)
{
    if (!hwnd)
        return FALSE;
    char buffer[30];
    if ((GetClassName (hwnd, buffer, 30)) == 0)
        return FALSE;
    ((UI_CompositeVObject*) param)->CreateResourceChild (hwnd, buffer);
    return TRUE;
}

bool UI_CompositeVObject::CreateResourceChild
    (UI_ViewHandle hndl, const CL_String& ctrl_name)
{
    long n;
    n = GetWindowTextLength (hndl);
    char* buf = "";
    CL_String mdl;   
    if (n) {
        buf = new char[n+1];
        GetWindowText (hndl,buf,n+1);
        mdl = buf;
        delete buf;
    }
  
    // Begin construction:

#if defined(__MS_WIN32__)
    UI_ViewID id = GetWindowLong (hndl, GWL_ID);
#else
    UI_ViewID id = GetWindowWord (hndl, GWW_ID);
#endif
    CL_String name = ctrl_name.InLowerCase ();
    long ctrl_style = GetWindowLong (hndl, GWL_STYLE);
    RECT clientRect;
    GetClientRect (hndl, &clientRect);
    UI_Rectangle shape (clientRect.left, clientRect.top,
                        clientRect.right  - clientRect.left+1,
                        clientRect.bottom - clientRect.top + 1);
    if (name == "button") {
        long style_bits = 0xff; // Depends on Windows 3.1!!
        long style = ctrl_style & style_bits;
        if (style != BS_GROUPBOX &&
            style != BS_RADIOBUTTON && style != BS_AUTORADIOBUTTON &&
            style != BS_CHECKBOX && style != BS_AUTOCHECKBOX) {
            _CurrentGroup = NULL;
            _CurrentGroupId = 0;
        }
        if (style == BS_GROUPBOX) {
            _CurrentGroup = NULL;
            _CurrentGroupId = id;
            _CurrentGroupHandle = hndl;
        }
        else if (style == BS_AUTOCHECKBOX || style == BS_CHECKBOX) {
            if (!_CurrentGroup && _CurrentGroupId) {
                _CurrentGroup = new UI_OrButtonGroup
                    (this, _CurrentGroupId, _CurrentGroupHandle);
                initSimple (_CurrentGroup);
            }
            UI_ToggleButton* v = new UI_ToggleButton
                (_CurrentGroup ? _CurrentGroup : this, id, hndl);    
            initSimple (v);
        }
        else if (style == BS_AUTORADIOBUTTON || style == BS_RADIOBUTTON) {
            if (!_CurrentGroup && _CurrentGroupId) {
                _CurrentGroup = new UI_ExOrButtonGroup
                    (this, _CurrentGroupId, _CurrentGroupHandle);
                initSimple (_CurrentGroup);
            }
            UI_ExOrToggleButton* v = new UI_ExOrToggleButton
                (_CurrentGroup ? (UI_CompositeVObject*) _CurrentGroup :
                 this, id, hndl);
            initSimple (v);
        }
        else {
            // Must be a push button
            UI_PushButton *v;
            v = new UI_PushButton (this, id, hndl);
            initSimple (v);
        } 
    }
    else if (name == "static") {
        UI_Label* v = new UI_Label (this, id, hndl);
        initSimple (v);
    }
    else if (name == "edit") {
        UI_StringEditor* v = new UI_StringEditor (this, id, hndl);
        initSimple (v);
    }
    else if (name == "listbox") {
        UI_StringView* v;
        if (ctrl_style & LBS_MULTIPLESEL)
            v = new UI_StringViewMultiSel  (this, id, hndl);
        else
            v = new UI_StringViewSingleSel (this, id, hndl);
        initSimple (v);
    }
    return TRUE;
}
#endif


void UI_CompositeVObject::initSimple (UI_VisualObject* s)
{
    if (s) {
        ((UI_SimpleVObject*) s)->SetStyleParam();
        if (s->Parent() == this) {
            UI_ViewID id = s->ViewID();
            if (id > 0 && id <= 32767) {
                _objMap.Add (id, s);
                ((CL_IntPtrMap*) _model)->Add (id, &(s->Model()));
            }
            if (s->IsTabStop()) {
                long pos = _tabSequence.Add (s);
                if (_currentChild == -1)
                    _currentChild = pos;
            }
        }
    }
}




void UI_CompositeVObject::SetMenuBar  (UI_MenuBar* menu)
{
    if (_menuBar) {
        CL_Error::Warning ("CompositeVObject::SetMenuBar: title '%s':"
                           " but I already HAVE a menu bar!", _title.AsPtr());
    }
    _menuBar = menu;
#if defined(__OS2__)
    _shape.AddToHeight (OS2_MENU_BAR_HEIGHT); // Hard-wired: OS/2 uses 24
                                              // pixels for menu bar height
#endif
}



bool UI_CompositeVObject::MenuBarCreated ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    RECT rect = _shape.AsMSRect();
    AdjustWindowRect (&rect, _style, TRUE);
    UI_ViewHandle hmenu = _menuBar ? _menuBar->ViewHandle() : 0;
    if (hmenu) {
        SetMenu (_handle, hmenu);
        // Now recompute the client rectangle
        RECT msrec;
        GetClientRect (_handle, &msrec);
        POINT ms_pt;
        ms_pt.x = ms_pt.y = 0;
        ClientToScreen (_handle, &ms_pt);
        UI_Rectangle rec (ms_pt.x, ms_pt.y, msrec.right - msrec.left + 1,
                          msrec.bottom - msrec.top + 1);
        _SetShapeRectangle (rec);
        DrawMenuBar (_handle);
    }
#endif
    return TRUE;
}

    

// Return the menu used by this composite. Return NULL if there is no
// associated menu.
UI_MenuBar* UI_CompositeVObject::MenuBar () const
{
    return _menuBar;
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
bool UI_CompositeVObject::TakeFocus ()
{
    if (_currentChild >= 0) {
        UI_VisualObject* v = (UI_VisualObject*) _tabSequence[_currentChild];
        if (v)
            return v->TakeFocus();
    }
    return FALSE;
}


void UI_CompositeVObject::MoveFocusTo (UI_VisualObject* child)
{
    if (!(child && child->IsTabStop() && child->IsVisible() &&
          child->IsEnabled()))
        return;
    short pos = _tabSequence.LinearSearch (child);
    if (pos >= 0) {
        _currentChild = pos;
        // child->TakeFocus();
    }
}

bool UI_CompositeVObject::AdvanceFocus (short n)
{
    long size = _tabSequence.Size();
    if (n != 1 && n != -1 ||  size <= 1)
        return FALSE;
    short pos = _currentChild == -1 ? 0 : _currentChild + n;
    UI_VisualObject* v = NULL;
    if (_stickToParent) {
        // Stop if hit end of sequence in either direction
        short i;
        for (i = pos; i >= 0 && i < size; i += n) {
            v = (UI_VisualObject*) _tabSequence[pos];
            if (v->IsVisible() && v->IsEnabled() && v->IsTabStop())
                break;
        }
        if (i < 0 || i >= size)
            return FALSE;
        v->TakeFocus ();
        _currentChild = i;
        return TRUE;
    }

    // We don't stick to our parent, so we manage all tabbing within
    // ourselves.
    if (pos == size)
        pos = 0;
    else if (pos == -1)
        pos = size-1;
    while (pos != _currentChild) {
        v = (UI_VisualObject*) _tabSequence[pos];
        if (v->IsVisible() && v->IsEnabled() && v->IsTabStop())
            break;
        pos = (pos + n) % size;
        if (pos == -1)
            pos += size;
    }
    if (pos != _currentChild) {
        v->TakeFocus();
        _currentChild = pos;
    }
    return TRUE;
}

#endif


UI_VisualObject* UI_CompositeVObject::RemoveChild (UI_VisualObject* view)
{
    if (view) {
        short index = _tabSequence.LinearSearch (view);
        if (index >= 0)
            _tabSequence.Remove (index);
    }
    UI_VObjCollection::RemoveChild (view);
    return view;
}

void UI_CompositeVObject::AddChild (UI_VisualObject* child)
{
    // Called from child->UI_VisualObject::_Init
    if (!child)
        return;
    UI_VObjCollection::AddChild (child);
    UI_ViewID id = child->ViewID();
    if (id > 0 && id <= 32767) {
        CL_IntPtrMap& modelMap = *(CL_IntPtrMap*) _model;
        modelMap.Add (id, &(child->Model()));
    }
}



bool UI_CompositeVObject::_ShapeRectChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VisualObject::_ShapeRectChanged ();
#elif defined(__OS2__)
    if (_stickToParent || _handle  <= 0)
        return UI_VObjCollection::_ShapeRectChanged ();
    long ht = _YACLWindowHeight (_parent ? _parent->ViewHandle()
                                : HWND_DESKTOP);
    SWP swp, frameSwp;
    WinQueryWindowPos  (_handle, &swp);
    WinQueryWindowPos  (_frameHandle, &frameSwp);
    long newX = _shape.Left() - swp.x;
    long newY = ht - _shape.Bottom () - swp.y;
    long newW = _shape.Width()  + frameSwp.cx - swp.cx;
    long newH = _shape.Height() + frameSwp.cy - swp.cy;

    // Now adjust if the parent has a menu bar
    UI_ViewHandle menuBarHandle = _parent ? 
        UI_Application::MenuBarHandle (_parent->ViewHandle()) : 0;
    if (menuBarHandle) {
        RECTL rect;
        WinQueryWindowRect (menuBarHandle, &rect);
        newY -= rect.yTop - rect.yBottom;
    }

    // Finally, set the window position
    WinSetWindowPos (_frameHandle, HWND_TOP, newX, newY, newW, newH,
                     SWP_SIZE | SWP_MOVE);
    return TRUE;
#elif defined (__X_MOTIF__)
    if (!_xwidget || _stickToParent)
        return UI_VisualObject::_ShapeRectChanged ();
    // Need to do this only for non-sticky children under X: they have a
    // dialog shell, and its shape must be changed, not that of the
    // Composite.
    Arg arg[4];
    short argn = 0;
    long x = _shape.Origin().XCoord();
    long y = _shape.Origin().YCoord();
    long w = _shape.Width();
    long h = _shape.Height();
    XtVaSetValues (_shell, XtNwidth, w, NULL);
    // Set the shell's width before asking for the menu bar's height!
    if (_menuBar) {
        Dimension menuBarHt = 0;
        XtVaGetValues (_menuBar->ViewHandle(), XtNheight, &menuBarHt, NULL);
        h += menuBarHt;
    }
    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;
    XtSetValues (_shell, arg, argn);
    return TRUE;
#elif defined(__X_YACL__)
    if (_window) {
        Display* d = _Controller->AppDisplay();
        int screenNo = DefaultScreen (d);
        XWindowChanges changes;
        changes.x = _shape.Left();
        changes.y = _shape.Top();
        changes.width = _shape.Width();
        changes.height = _shape.Height();
        XReconfigureWMWindow  (d, _window, screenNo,
                               CWX | CWY | CWWidth | CWHeight, &changes);
    }
#endif
    
}


bool UI_CompositeVObject::_TitleChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VisualObject::_TitleChanged ();

#elif defined(__OS2__)
    if (_stickToParent)
        return UI_VisualObject::_TitleChanged ();
    if (_frameHandle)
        return (WinSetWindowText (_frameHandle, _title.AsPtr()) ? TRUE :
                FALSE);
    return TRUE;
#elif defined(__X_MOTIF__)
    if (!_xwidget || _stickToParent)
        return UI_VisualObject::_TitleChanged ();
    _SetWindowTitle (_xwidget, _title);
    return TRUE;
#elif defined(__X_YACL__)
    if (!_window)
        return TRUE;
    _SetWindowTitle (_window, _title);
    return TRUE;
#endif
}




bool UI_CompositeVObject::PropagateFontChange (UI_VisualObject* initiator)
{
    return (_stickToParent || initiator == this)
        ? UI_VObjCollection::PropagateFontChange (initiator)
        : TRUE; // Refuse propagation if we're an independent window
}


#if defined(__X_MOTIF__)
void UI_CompositeVObject::Realized ()
{
    if (_visible)
        XtMapWidget (_shell);
    CL_ObjectSequence children = _Controller->ChildrenOf (this);
    for (short i = children.Size() - 1; i >= 0; i--) {
        UI_VisualObject* child = (UI_VisualObject*) children(i);
        UI_Cursor& childCursor = child->Cursor();
        if (childCursor != UICursor_Default)
            _Controller->ChangeCursor (child->ViewHandle(), childCursor);
    }
}

#endif

