




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/color.h"
#include "ui/applic.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <windows.h>
#elif defined (__X_MOTIF__) || defined(__X_YACL__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Xlib.h>
#endif



struct ColorStruct {
    long red, green, blue;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    ColorStruct (long r, long g, long b) : red(r), green (g), blue(b) {};
#else
    ColorStruct (double r, double g, double b)
        : red  ((long) (r * UI_MAXCOLORS)), 
          green((long) (g * UI_MAXCOLORS)),
          blue ((long) (b * UI_MAXCOLORS)){};
#endif
};


static ColorStruct Colors (UI_ColorScheme c)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    switch(c) {
    case UIColor_Black:
        return ColorStruct (0, 0, 0);

    case UIColor_Red:
        return ColorStruct (255, 0, 0);

    case UIColor_Green:
        return ColorStruct (0, 255, 0);

    case UIColor_Blue:
        return ColorStruct (0, 0, 255);

    case UIColor_White:
        return ColorStruct (255, 255, 255);

    case UIColor_DarkGray:
        return ColorStruct (128, 128, 128);

    case UIColor_MediumGray:
        return ColorStruct (192, 192, 192);

    case UIColor_LightGray:
        return ColorStruct (224, 224, 224);

    default:
        return ColorStruct (0, 0, 0);
    }
#else
    switch(c) {
    case UIColor_Black:
        return ColorStruct (0, 0, 0);

    case UIColor_Red:
        return ColorStruct (1, 0, 0);

    case UIColor_Green:
        return ColorStruct (0, 1, 0);

    case UIColor_Blue:
        return ColorStruct (0, 0, 1);

    case UIColor_White:
        return ColorStruct (1, 1, 1);

    case UIColor_DarkGray:
        return ColorStruct (0.5, 0.5, 0.5);

    case UIColor_MediumGray:
        return ColorStruct (0.75, 0.75, 0.75);

    case UIColor_LightGray:
        return ColorStruct (0.875, 0.875, 0.875);

    default:
        return ColorStruct (0, 0, 0);
    }
#endif
}




UI_Color::UI_Color ()
{
    _red = _green = _blue = 0;
}


#if defined (__X_MOTIF__)  || defined(__X_YACL__)
static ulong _XPixelVal (XColor xcolor)
{
    Display* dpy = YACLApp()->AppDisplay();
    short screen_num = DefaultScreen (dpy);
    XAllocColor (dpy, DefaultColormap (dpy, screen_num), &xcolor);
    return xcolor.pixel;
}
#endif


UI_Color::UI_Color (UI_ColorScheme c)
{
    ColorStruct s = Colors (c);
    _red   = s.red;
    _blue  = s.blue;
    _green = s.green;
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
}


UI_Color::UI_Color (double r, double g, double b)
{
    if (r < 0 || r > 1) {
        CL_Error::Warning ("UI_Color constructor: invalid red component "
                           "%e", r);
        _red = _green = _blue = 0;
    }
    else if (g < 0 || g > 1) {
        CL_Error::Warning ("UI_Color constructor: invalid green component "
                           "%e", g);
        _red = _green = _blue = 0;
    }
    else if (b < 0 || b > 1) {
        CL_Error::Warning ("UI_Color constructor: invalid blue component "
                           "%e", b);
        _red = _green = _blue = 0;
    }
    else {
        _red      = (long) (r * UI_MAXCOLORS);
        _green    = (long) (g * UI_MAXCOLORS);
        _blue     = (long) (b * UI_MAXCOLORS);
    }
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
}

UI_Color::UI_Color (long r, long g, long b)
: _red (r), _green (g), _blue (b)
{
}


UI_Color::UI_Color (const UI_Color& c)
{
    _red      = c._red;
    _green    = c._green;
    _blue     = c._blue;
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
}


void UI_Color::Red (double r)
{
    if (!PrepareToChange ())
        return;
    _red      = (long) (r * UI_MAXCOLORS);
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
    Notify ();
}


void UI_Color::Green (double g)
{
    if (!PrepareToChange())
        return;
    _green    = (long) (g * UI_MAXCOLORS);
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
    Notify();
}


void UI_Color::Blue (double b)
{
    if (!PrepareToChange())
        return;
    _blue     = (long) (b * UI_MAXCOLORS);
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
    Notify();
}



UI_Color& UI_Color::operator= (const UI_Color& x)
{
    if (!PrepareToChange())
        return *this;
    _red       = x._red;
    _green     = x._green;
    _blue      = x._blue;
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    _xPixel = _XPixelVal (NativeForm());
#endif
    Notify();
    return *this;
}


bool UI_Color::operator== (const UI_Color& o) const
{
    return _red == o._red && _blue == o._blue && _green == o._green;
}


bool UI_Color::operator< (const UI_Color& o) const
{
    if (_red < o._red)
        return TRUE;
    if (_red > o._red)
        return FALSE;
    if (_green < o._green)
        return TRUE;
    if (_green > o._green)
        return FALSE;
    if (_blue < o._blue)
        return TRUE;
    return FALSE;
}


UI_NativeColorRep UI_Color::NativeForm () const
{
    return _ColorVal (_red, _green, _blue);
}


UI_NativeColorRep UI_Color::_ColorVal (long r, long g, long b)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return RGB (r, g, b);
#elif defined(__OS2__)
    return ((ushort) (r) << 16) + ((ushort) (g) << 8) +
            ((ushort) (b));
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    UI_NativeColorRep color;
    color.red   = (short) (r);
    color.green = (short) (g);
    color.blue  = (short) (b);
    return color;
#endif

}


static inline long _LightShade (long c)
{
    return maxl ((UI_MAXCOLORS + c)/2, minl (UI_MAXCOLORS, 14*c/10));
}

UI_Color UI_Color::LightShadow () const
{
    // The idea for the LightShadow and DarkShadow methods is shamelessly
    // stolen from the Tk toolkit. -- Sridhar, April 24, 1996.
    return UI_Color (_LightShade(_red), _LightShade(_green),
                     _LightShade(_blue)); 
}


UI_Color UI_Color::DarkShadow () const
{
    return UI_Color ((long) (60 * _red / 100), 
                     (long) (60 * _green / 100), 
                     (long) (60 * _blue / 100));
}


