




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma implementation
#endif



// ----------------------- Header file includes -----------------------


#include "base/treewalk.h"

#include "ui/cntroler.h"
#include "ui/applic.h"
#include "ui/menu.h"
#include "ui/composit.h"
#include "ui/event.h"
#include "ui/btngroup.h"
#include "ui/stred.h"

#if defined(__OS2__)
#include <stdlib.h>
#define INCL_PM
#include <os2.h>
#endif


#if defined (__X_MOTIF__) || defined(__X_YACL__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/StringDefs.h>
#    include <X11/Intrinsic.h>
#    include <X11/Shell.h>
#    if defined(__X_MOTIF__)
#        include <Xm/Xm.h>
#        include <Xm/MainW.h>
#    endif
#    include <iostream.h> // DEBUG
#endif

#if defined(__GNUC__)
template class CL_Binding0<UI_Controller>;
#elif defined(_MSC_VER)
template CL_Binding0<UI_Controller>;
#endif


// ----------------------- Typedefs ---------------------------------

typedef CL_Binding0<UI_Controller> ControllerBind;


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
typedef WNDPROC WinProc;
#endif

// ----------------------- Global and static variables -------------


char _YACLWindowClassName[]   = "YACLWindow";
char _YACLMDIFrameClassName[] = "YACLMDIFrame";
char _YACLMDIChildClassName[] = "YACLMDIChild";
char _YACLSimpleClassName[]   = "YACLSimpleVObj";

#if defined(__X_MOTIF__)
XtAppContext _YACLXAppContext;
#endif


// ----------------------- Function prototypes ----------------------

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
void initApplicationMS (HANDLE);
#elif defined(__OS2__)
MRESULT EXPENTRY YACLWindowProc (HWND, ULONG, MPARAM, MPARAM);
#endif




//
//----------------------Constructor-----------------------
//



UI_Controller::UI_Controller (UI_Application* appl)
{
    UI_VisualObject::_Application = appl;
    _InitController();
}


void UI_Controller::_InitController ()
{
    _current = NULL;
    UI_VisualObject::_Controller = this;
    _root        = NULL;
    _inWaitState = FALSE;
    _focus       = NULL;
    _eventFilter = NULL;
    _termination = NULL;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    _buttonFaceBrush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE));
    _mainWindowIsMDI = FALSE;
#elif defined(__OS2__)
    _deIconifyPending = 0;
#elif defined(__X_YACL__)
    _display = XOpenDisplay (NULL);
    if (!_display)
      CL_Error::Fatal ("Cannot open display");
#endif
}


UI_Controller::~UI_Controller ( )
{
    if ( _root != NULL ) {
        Destroy ( _root );
        _root = NULL;
    }
    _eventQueue.DestroyContents ();
#if defined(__OS2__)
    WinDestroyMsgQueue (_hmq);
    WinTerminate (_hab);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    DeleteObject ((HBRUSH) _buttonFaceBrush);
    UnregisterClass ( _YACLWindowClassName, hInst );
    UnregisterClass ( _YACLSimpleClassName, hInst );
    _menuMap.DestroyContents ();
#endif
}


//
//-----------------Controller service methods----------------------------
//


//
//--------Mouse control methods
//




void UI_Controller::GiveMouseTo (UI_VisualObject* view)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    SetCapture (view->_handle);
#elif defined (__OS2__)
    WinSetCapture (HWND_DESKTOP, view->_handle);
#elif defined(__X_YACL__)
    Window grabWindow = view->ViewHandle();
    ulong mask = ButtonPressMask | ButtonReleaseMask  | ButtonMotionMask
        | PointerMotionMask;
    // Grabbing doesn't work right. Don't yet know why.
//    XGrabPointer (_display, grabWindow, True, mask, GrabModeAsync,
//                  GrabModeAsync, None, None, CurrentTime);
#elif defined(__X_MOTIF__)
    _grabWindow = XtWindow (view->ViewHandle());
    ulong mask = ButtonPressMask | ButtonReleaseMask  | ButtonMotionMask
        | PointerMotionMask;
//    XGrabPointer (_display, _grabWindow, True, mask, GrabModeAsync,
//                  GrabModeAsync, None, None, CurrentTime);
//     XGrabButton (AppDisplay(), AnyButton, AnyModifier, _grabWindow,
//                  True, 0xfffffff,
//                  GrabModeAsync, GrabModeAsync, _grabWindow, None);
#endif
}


void UI_Controller::ReleaseMouse()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    ReleaseCapture();
#elif defined(__OS2__)
    WinSetCapture (HWND_DESKTOP, 0);
#elif defined(__X_YACL__)
    XUngrabPointer (_display, CurrentTime);
#elif defined(__X_MOTIF__)
//     XUngrabButton (AppDisplay(), AnyButton, AnyModifier, _grabWindow);
#endif
}

void UI_Controller::GiveFocusTo (UI_VisualObject* aView)
{
    if (aView)
        aView->TakeFocus ();
}



UI_VisualObject* UI_Controller::operator [] (UI_ViewHandle h) 
{
    return (UI_VisualObject *) _visualObjMap [(long) h];
}

  


void UI_Controller::MakeTopWindow (UI_CompositeVObject* rt)
{
    if (_root && rt != _root)
        CL_Error::Fatal ("Attempt to create two top windows.");
    _root = rt;

    if (_root->Title ().Size () == 0)
        _root->Title () = _YACLWindowClassName;
}


//
// -----------------------Controller methods-------------------
//


CL_ObjectSequence UI_Controller::ChildrenOf (UI_VisualObject* o)
{
    CL_IntegerTreeNode* node = _viewTree.Node ((long) o->ViewHandle());
    CL_ObjectSequence seq (node ? node->ChildCount() : 0);
    if (!node)
        return seq;
    const CL_ObjectSequence& children = node->Children();
    for (short i = 0; i < node->ChildCount(); i++)
        seq[i] = (CL_Object*) ((CL_IntegerTreeNode*) children[i])->Content();
    return seq;
}

void UI_Controller::Register (UI_VisualObject* view)
{
    UI_VisualObject* parent = view->_parent;
    // _root is set when the main VisualObj is constructed. But Register is
    // called only after its visual element has been created. So:
    if ( _root  && (view != _root)) {
        UI_ViewHandle h = parent ? parent->ViewHandle()
            : _root->ViewHandle();
        CL_IntegerTreeNode* v =  _viewTree.AddChild
            ((long) view->ViewHandle (), (long) h);
        if (!v) // Should not happen
            return;
        v->Content () = (long) view;
    }
    else {
        // We're creating the root of the view tree
        _root = (UI_CompositeVObject *) view;
        CL_TreeNode<long>* rootNode = _viewTree.NewRoot
            ((long) view->ViewHandle());
        if (!rootNode)
            CL_Error::Fatal ("Controller::Register: Root creation failed");
        else
            rootNode->Content() = (long)_root;
    }
    // Now add visual object and window pair to the map
    if (!_visualObjMap.Add ((long) view->ViewHandle (), view))
        CL_Error::Warning ("Controller::Register: Duplicate handle %x "
                           "id %d class name '%s'", view->ViewHandle(),
                           view->ViewID(), view->ClassName());
}  



// The following two functions are meant only for debugging support. This
// code might be useful in debugging, and therefore has not been deleted.
// 
// static void PrintTree (const CL_IntegerTree& tree, CL_IntegerTreeNode* node,
//                        short depth = 0)
// {
//     if (!node)
//         return;
//     CL_String s (' ', depth*4);
//     UI_VisualObject* v = (UI_VisualObject*) node->Content();
//     CL_Error::Warning ("%sHandle %ld Id %ld ptr %lx\n", s.AsPtr(),
//                        v->ViewHandle(), v->ViewID(), v);
//     short n = node->ChildCount();
//     if (n <= 0)
//         return;
//     CL_Error::Warning ("%s{\n", s.AsPtr());
//     for (short i = 0; i < n; i++)
//         PrintTree (tree, node->Child(i), depth+1);
//     CL_Error::Warning ("%s}\n", s.AsPtr());
// }
// 
// 
// static void PrintMap (CL_IntPtrMap& map)
// {
//     CL_Error::Warning ("---------");
//     CL_IntPtrMapIterator itr (map);
//     while (itr.More()) {
//         CL_IntPtrAssoc a = itr.Next();
//         UI_VisualObject* v = (UI_VisualObject*) a.value;
//         CL_Error::Warning ("%ld %lx %ld", a.key, a.value, v->ViewID());
//     }
//     CL_Error::Warning ("---------\n");
// }



bool UI_Controller::Destroy (UI_VisualObject* view)
{
    if ( view == NULL )
        return FALSE;

    if ( !(_visualObjMap.IncludesKey ((long) view->ViewHandle ())) )
        return FALSE;

    UI_ViewHandle vh = view->ViewHandle ();

    //    PrintTree (_viewTree, _viewTree.Root()); // DEBUG
    
    // We first go through the subtree and remove all the visual objects in
    // the subtree from the visualObjMap. We then destroy the removed
    // objects. This ensures that if the window system sends events to the
    // objects while they're being destroyed, these events are not
    // dispatched because the view handles will not be in the map.
    CL_ObjectSequence toDestroy;
    CL_IntegerTreePostWalker walker (_viewTree.Node ((long) vh));
    while (walker.More()) {
        UI_VisualObject* v = (UI_VisualObject *) walker.Next()->Content ();
        if (v == _current)
            _current = NULL;
        if (v == _focus)
            _focus = NULL;
        if (v) {
            _visualObjMap.Remove ((long) v->ViewHandle ());
            toDestroy.Add (v);
        }
    }
    if (view == _root) {
        _eventQueue.DestroyContents ();
        _root = NULL;
    }
    else {
        _viewTree.DestroySubtree ((long) vh);
        //   PrintTree (_viewTree, _viewTree.Root()); // DEBUG
    }
    short n = toDestroy.Size();
    for (short i = 0; i < n; i++) {
//         WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
//                        (char*) ("i is " + CL_String (i)).AsPtr(),
//                        "DEBUG", 0, MB_OK); 
        UI_VisualObject* v = (UI_VisualObject *) toDestroy[i];
#if defined(__X_MOTIF__)
        if (v->WindowClass() == xmMainWindowWidgetClass)
            _shellMap.Remove
                ((ulong) ((UI_CompositeVObject*) v)->ShellHandle());
#endif
        v->Finalize ();
        v->_PrivateFinalize ();
        if ( v->_created )
            v->DestroyVisualElement ();
        delete v;
    }
    // PrintMap (_visualObjMap); // DEBUG
    view = NULL;

    return TRUE;
}


bool UI_Controller::DispatchEvent (UI_Event* e)
{
    if (!_root)
        return TRUE; // No event dispatching -- the app is finished
    if (_inWaitState)
        return TRUE; // Do nothing if in wait state
    _currentEvent = e;
    UI_VisualObject* obj = e->Destination ();
    if (e->_type == Event_GetFocus)
        _focus = obj;
    else if (e->_type == Event_LoseFocus)
        _focus = NULL;

    bool b = TRUE;
    if (obj) {
        _currentEventStack.Add (obj);
        b = obj->_PrivateHandleEvent (e);
        _currentEventStack.ExtractRightmost ();
        if (!b) {
            UI_VisualObject* vObj = obj->Parent(); 
            while (vObj) {
                e->_dest = vObj;
                _currentEventStack.Add (vObj);
                b = vObj->_PrivateHandleChildEvent (*e);
                _currentEventStack.ExtractRightmost ();
                if (b) break;
                vObj = vObj->Parent ();
            }
        }
    }
    _currentEvent = NULL;
    return b;
}


bool UI_Controller::ProcessSoftEvent ( UI_Event* e )
{
    bool done = FALSE;
    switch (e->Type ()) {
    case Event_Quit: {
        done  =  (e->Origin() == e->Destination() &&
                  e->Origin() == _root );
        Destroy (e->Destination ());
        break;
    }
                         

    case Event_MakeInterface: {
        UI_VisualObject* origin = e->Origin ();
        if (!origin)
            break;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
        _MakeWindowsInterface (*e);
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
        _MakeXInterface (*e);
#elif defined(__OS2__)
        _MakeOS2Interface (*e);
#endif
        break;
    }  // End of case Event_MakeInterface

#if defined(__X_MOTIF__)
    case Event_StrEdChanged: {
        UI_StringEditor* edit = (UI_StringEditor*) e->Origin ();
        if (!edit)
            break;
        edit->Update();
        break;
    }
#endif
        
    default:
        DispatchEvent (e);
        break;
    }
    return done;
}



void UI_Controller::DispatchSoftEvents ()
{
    UI_Event* e = NULL;
    while (_eventQueue.Size () > 0) {
        e = (UI_Event*) _eventQueue.ExtractLeftmost ();
        if ( !_eventFilter || _eventFilter->Execute (*e) ) {
            ProcessSoftEvent (e);
        }
        if ( _termination && _termination->Execute (*e) ) {
            delete e;
            break;
        }
        delete e;
    }
}




void UI_Controller::EventLoop (CL_AbstractBinding* termination,
                               CL_AbstractBinding* filter
                              )
{
    // Save the filters.
    CL_AbstractBinding* oldEventFilter = _eventFilter;
    CL_AbstractBinding* oldTermFilter  = _termination;
    _eventFilter = filter;
    _termination = termination;

    // Run the loop
    if ( _root )
        ProcessNativeEvents ();

    // Restore the filters
    _eventFilter = oldEventFilter;
    _termination = oldTermFilter;
}


bool UI_Controller::RootDestroyed ()
{
    return _root == NULL;
}


    
void UI_Controller::Run ()
{
    if (!_root) {
        CL_Error::Warning ("UI_Controller::Run: no root window");
        return;
    }
    // Start by cleaning up the soft events
    DispatchSoftEvents ();
    ControllerBind bind (this, &UI_Controller::RootDestroyed);
    EventLoop (&bind, NULL);
}


#if defined(__X_MOTIF__)
void UI_Controller::ChangeCursor (Widget w, const UI_Cursor& c)
{
    XSetWindowAttributes attrs;
    Display* dpy = XtDisplay (_rootshell);
    attrs.cursor = (c == UICursor_Default) ? None : c.Handle();
    XChangeWindowAttributes(dpy, XtWindow (w), CWCursor, &attrs);
/*    CL_IntPtrMapIterator itr (_shellMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        Widget shell = (Widget) assoc.key;
        // cout << "SetCurrentCursor: shell " << shell << " for " <<
        //      ((UI_VisualObject*) assoc.value)->Title() << endl; //DEBUG
        XChangeWindowAttributes(dpy, XtWindow(shell), CWCursor, &attrs);
    }
*/
    // XFlush(dpy);
}
#endif


bool UI_Controller::SetCurrentCursor (UI_Cursor& c)
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    HCURSOR h = c.Handle();
    if (h) {
        SetCursor (h);
        return TRUE;
    }
    return FALSE;
#elif defined(__OS2__)
    if (c != UICursor_Default)
        WinSetPointer (HWND_DESKTOP,
                       _inWaitState ? WinQuerySysPointer
                       (HWND_DESKTOP, SPTR_WAIT, FALSE)
                       : c.Handle());
    return TRUE;
#elif defined (__X_MOTIF__)
    return TRUE;
#endif
}


void UI_Controller::BeginWait ()
{
    _inWaitState = TRUE;
    _defaultCursor = UICursor_Wait;
    DispatchPendingEvents ();
    SetCurrentCursor (_defaultCursor);
}


void UI_Controller::EndWait ()
{
    _inWaitState = FALSE;
    _defaultCursor = UICursor_Arrow;
    SetCurrentCursor (_defaultCursor);
    FlushEventQueue ();
}


        



void UI_Controller::AddEvent(UI_Event* anEvent)
{
    _eventQueue.Add ( anEvent );
}


UI_Event* UI_Controller::RemoveEvent ()
{
    if (_eventQueue.Size () > 0)
        return (UI_Event*) _eventQueue.ExtractLeftmost ();
    return NULL;
}


short UI_Controller::EventsPending (UI_EventType t, UI_VisualObject* v)
{
    short count = 0;
    for (long i = _eventQueue.Size() - 1; i >= 0; i--) {
        UI_Event* e = (UI_Event*) _eventQueue(i);
        bool b = TRUE;
#if defined(__OS2__)
        b = (e->Origin()->WindowClass() != NULL);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
        b = (lstrcmp (e->Origin()->WindowClass(), "menu") != 0);
#endif
        if (b && e->Type() == t && e->Origin()->Parent() == v)
            count++;
    }
    return count;
}


void UI_Controller::Beep ()
{
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    MessageBeep (MB_ICONQUESTION);
#elif defined(__OS2__)
    DosBeep (100, 100);
#elif defined (__X_MOTIF__)
    XBell (AppDisplay(), 100);
#endif
}





