
include ../control/cfr_sgi.ctl


LIBRARY    = $(YACLLIB)/lib$(UI).a
LIBRARY_SO = $(YACLLIB)/lib$(UI).so


# ------------------------ Names of files --------------------------



OBJECTS =    \
3dlabel.o     \
applic.o      \
arc.o         \
bitmap.o      \
brush.o       \
bmpbtn.o      \
bmpushbn.o    \
bmtglbtn.o    \
btngroup.o    \
canvas.o      \
chord.o       \
cntroler.o    \
color.o       \
combobox.o    \
composit.o    \
containr.o    \
cursor.o      \
dateedit.o    \
dialog.o      \
dsplrsrc.o    \
dsinmem.o     \
dsplsurf.o    \
dwgsurf.o     \
ellipse.o     \
event.o       \
font.o        \
fontdesc.o    \
graphic.o     \
grutils.o     \
interval.o    \
label.o       \
lineseg.o     \
mainprog.o    \
menu.o        \
monthcal.o    \
numedit.o     \
pen.o         \
piewedge.o    \
point.o       \
pswdedit.o    \
pushbtn.o     \
orbtngrp.o    \
rectangl.o    \
scrolbar.o    \
scrolwin.o    \
simple.o      \
shadolin.o    \
shadorec.o    \
shadotrg.o    \
stddlg.o      \
stencil.o     \
stred.o       \
strseq.o      \
strview.o     \
textedit.o    \
timer.o       \
toglbtn.o     \
vector.o      \
visualob.o    \
vobjcoll.o    \
xrbtngrp.o    \
xrtglbtn.o    \
xmotfevt.o


STATIC_OBJS = statui.o

include support/$(WIDGET_SET)/objlist.ctl


#
# Shared libraries don't yet work correctly, so they're not built by default.
#

# all: $(LIBRARY) $(LIBRARY_SO)
all: $(LIBRARY)



$(LIBRARY): $(OBJECTS) $(STATIC_OBJS) $(PLATFORM_OBJECTS)
	ar r $(LIBRARY) $(OBJECTS) $(STATIC_OBJS) $(PLATFORM_OBJECTS)
	$(RANLIB) $(LIBRARY)


$(LIBRARY_SO): $(OBJECTS) $(STATIC_OBJS)$(PLATFORM_OBJECTS)
	ld -shared -o $(LIBRARY_SO) $(OBJECTS) $(STATIC_OBJS) \
            $(PLATFORM_OBJECTS)


stddlg.o: support/$(WIDGET_SET)/stddlg.cxx
	$(CC) $(CCOPTS) -ptall -ptv $(OPTIMIZE) -D$(WIDGET_SYMBOL) \
       support/$(WIDGET_SET)/stddlg.cxx


        



#
# Dependencies for x_motif:
#        
mocobox.o: $(YACLPATH)/ui/support/x_motif/mocobox.c
	$(CCOMP) -c  $(DEBUG) $(INCPATH) -D__UNIX__ -D__X_MOTIF__  \
          support/x_motif/mocobox.c


ycomp.o: $(YACLPATH)/ui/support/x_motif/ycomp.c
	$(CCOMP) -c  $(DEBUG) $(INCPATH) -D__UNIX__ -D__X_MOTIF__  \
          support/x_motif/ycomp.c





#
# Dependencies for x_yacl:
#        
window.o:   support/x_yacl/window.cxx
	$(CC) $(CCOPTS) -ptall -ptv $(OPTIMIZE) -D__X_YACL__  \
          support/x_yacl/window.cxx



.SUFFIXES:
.SUFFIXES: .cxx .c .o .a



.cxx.o:
	$(CC) $(CCOPTS) -ptall -ptv $(OPTIMIZE) -D$(WIDGET_SYMBOL) $*.cxx

        
.c.o:
	$(CCOMP) -c  $(DEBUG) $(INCPATH) -D__UNIX__ -D$(WIDGET_SYMBOL) $*.c
        

clean:
	-rm -f *.o  $(LIBRARY)
