
#ifndef _canvas_h_ /* Thu Dec 15 12:54:38 1994 */
#define _canvas_h_




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// A Canvas is a VisualObject that creates a DisplaySurface for itself when
// initialized, and destroys the DisplaySurface when it is destroyed. The
// Canvas can be used for drawing.



#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/visualob.h"

class YACL_UI UI_Canvas: public UI_VisualObject {

public:
    UI_Canvas (UI_VisualObject* parent, const UI_Rectangle& shape,
               UI_ViewID id = -1);
    // Create a Canvas with the given parent, shape and view id.

    ~UI_Canvas () {};
    // Destructor.
    
    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName () const { return "UI_Canvas";};


protected:
    bool Paint (const UI_Rectangle&);
    
    void _PrivateInitialize ();
    // [Internal use only.] Create a DisplaySurface for this object.
     
    void Finalize ();
    // Destroy the DisplaySurface.

};


#endif /* _canvas_h_ */
