

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/btngroup.h"
#include "ui/cntroler.h"
#include "ui/simple.h"
#include "ui/applic.h"
#include "ui/font.h"
#include "ui/shadorec.h"
#include "ui/shadolin.h"

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
#    if defined(USE_CTL3D)
#        include <ctl3d.h>
#    endif
#    define DEFAULT_STYLE BS_GROUPBOX | WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS
#elif defined(__OS2__)
#    define DEFAULT_STYLE  SS_GROUPBOX | WS_VISIBLE | WS_GROUP
#elif defined (__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <Xm/BulletinB.h>
#    include <Xm/Frame.h>
#    include <Xm/Label.h>
#    include "ui/support/x_motif/ycomp.h"
#elif defined(__X_YACL__)
#    include "ui/support/x_yacl/window.h"
#endif

typedef UI_EventBinding1<UI_ButtonGroup> BtnGroupBind;

#if defined(__GNUC__)
template class UI_EventBinding1<UI_ButtonGroup>;
#elif defined(_MSC_VER)
template UI_EventBinding1<UI_ButtonGroup>;
#endif


#if defined(__OS2__) && defined(__IBMCPP__)
inline MRESULT EXPENTRY CallBackButtonGroupProc( HWND hWnd, ULONG msg,
                                                 MPARAM p1, MPARAM p2)
{
    return UI_ButtonGroup::ButtonGroupProc( hWnd, msg, p1, p2);
}
#endif


UI_ButtonGroup::UI_ButtonGroup
    (UI_VObjCollection* parent, const UI_Rectangle& r,  UI_ViewID id)
: UI_VObjCollection (parent, r, id)
{
    if (!_parent)
        CL_Error::Warning ("ButtonGroup constructor: id %d: NULL parent!",
                           id);
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    _style = DEFAULT_STYLE;
    BtnGroupBind bind (this, &UI_ButtonGroup::_GetFocus);
    AddEventDependent (Event_Other, bind);
#elif defined(__OS2__)
    _style = DEFAULT_STYLE;
    BtnGroupBind bind (this, &UI_ButtonGroup::_GetFocus);
    AddEventDependent (Event_KeyTyped, bind);
#elif defined (__X_MOTIF__)
    _frameWidget = NULL;
    _frameLabel  = NULL;
#endif
}



#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
// For resource-based construction (only under MS-Windows):

UI_ButtonGroup::UI_ButtonGroup
    (UI_VObjCollection* parent, UI_ViewID id, UI_ViewHandle h)
: UI_VObjCollection (parent, UI_Rectangle(), id)
{
    _id = id;
    _handle = h;
#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
    BtnGroupBind bind (this, &UI_ButtonGroup::_GetFocus);
    AddEventDependent (Event_Other, bind);
#elif defined (__OS2__)
    BtnGroupBind bind (this, &UI_ButtonGroup::_GetFocus);
    AddEventDependent (Event_KeyTyped, bind);
#endif
}

#endif



UI_ButtonGroup::~UI_ButtonGroup ()
{
}



bool UI_ButtonGroup::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    if (!UI_VObjCollection::MakeVisualElement())
        return FALSE;
#if defined(USE_CTL3D)
    if (Has3DLook()) {
        Ctl3dSubclassCtl (_handle);
    }
#endif
    return TRUE;
#elif defined(__OS2__)
    bool b = UI_VObjCollection::MakeVisualElement();
    // And, just like under Windows, we need to subclass the button group,
    // otherwise it doesn't repaint itself right.
    // _Subclass ();
    return b;
#elif defined(__X_MOTIF__)
    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    // First, we'll create a Frame widget
    CL_String instance_name = InstanceName();
    CL_String frame_name    = instance_name  + "_frame";

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources
    XtSetArg (arg[argn ], XmNshadowType, XmSHADOW_ETCHED_OUT); argn++;
    XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
    XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
    _frameWidget = XtCreateWidget (frame_name.AsPtr(), xmFrameWidgetClass,
                                   pw, arg, argn);

    // Next, create a label child of the frame
    CL_String label_name = instance_name + "_label";
    argn = 0;
    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    XtSetArg (arg [argn], XmNchildType, XmFRAME_TITLE_CHILD); argn++;
    _frameLabel = XtCreateWidget
        (label_name.AsPtr(), xmLabelWidgetClass, _frameWidget, arg, argn);

    // Finally, create the bulletin board widget
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();
    argn = 0;
    XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
    XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, _frameWidget, arg,
                               argn);
    // Clean up
    XmStringFree (title);

    if (_visible) {
        XtManageChild (_frameWidget);
        XtManageChild (_frameLabel);
    }
    return TRUE;
#elif defined(__X_YACL__)
    _visualElement = new YVE_Window (this);
    if (_visualElement)
        _window = _visualElement->Handle();
    return _visualElement && _visualElement->Handle() ? TRUE : FALSE;
#endif
}


void UI_ButtonGroup::_PrivateInitialize ()
{
    UI_VObjCollection::_PrivateInitialize ();
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h && !_parent->CreatedViaResource()) {
        SendMessage (_handle, WM_SETFONT, (UINT) h, TRUE);
    }

    // We must subclass the GroupBox to ensure that group boxes get
    // correctly repainted under Windows. This is not necessary for
    // resource-based dialogs, however.
    if (!CreatedViaResource()) {
        WNDPROC realProc = (WNDPROC) SetWindowLong
            (_handle, GWL_WNDPROC, (long) YACLBtnGroupProc);
#if defined(__MS_WIN32__)
        Invalidate ();
        SetProp (_handle, BTNGROUP_PROPERTY1, (void*) (realProc));
#else
        // Set the property to our address
        SetProp (_handle, BTNGROUP_PROPERTY1, LOWORD (realProc));
        SetProp (_handle, BTNGROUP_PROPERTY2, HIWORD (realProc));
#endif
    }
#elif defined(__OS2__)
    if (_font)
        _SetPlatformFont (_handle);
#elif defined(__X_MOTIF__)
    UI_ResourceHandle h  = _font ? _font->Handle() : 0;
    if (h && _frameLabel) {
        Display *dpy = XtDisplay (_frameLabel);
        XmFontList f = XmFontListCreate (XQueryFont (dpy, h),
                                         XmSTRING_DEFAULT_CHARSET);
        XtVaSetValues (_frameLabel, XmNfontList,  f, NULL);
        XmFontListFree (f);
    }
#endif
}


void UI_ButtonGroup::MakeInvisible ()
{
    UI_VObjCollection::MakeInvisible ();
#if defined(__X_MOTIF__)
    if (_frameWidget)   // We've been created
        XtUnmanageChild (_frameWidget);
#endif
}


void UI_ButtonGroup::MakeVisible ()
{
#if defined(__X_MOTIF__)
    if (_frameWidget) {   // We've been created
        XtManageChild (_frameWidget);
        XtManageChild (_frameLabel);
    }
#endif
    UI_VObjCollection::MakeVisible ();
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
bool UI_ButtonGroup::_GetFocus (UI_Event& e)
{
#if defined(__OS2__)
    ushort virtKey = SHORT2FROMMP (e.NativeEvent()->mp2);
#else
    MSG* msg = e.NativeEvent();
    if (msg->message != WM_KEYDOWN)
        return TRUE;
    ushort virtKey = msg->wParam;
#endif
    if (virtKey != VK_UP && virtKey != VK_DOWN)
        return TRUE;
    CL_ObjectSequence seq = _Controller->ChildrenOf (this);
    short n = seq.Size();
    if (n > 0) {
        long index = seq.LinearSearch (e.Origin());
        if (index >= 0) {
            short next = virtKey == VK_UP ? index-1 : ((index+1) % n);
            if (next == -1)
                next += n;
            ((UI_VisualObject*) seq(next))->TakeFocus();
        }
    }
    return TRUE;
}

bool UI_ButtonGroup::TakeFocus ()
{
    CL_ObjectSequence seq = _Controller->ChildrenOf (this);
    short n = seq.Size();
    if (n > 0)
        return ((UI_VisualObject*) seq[0])->TakeFocus();
    return FALSE;
}

#endif


UI_WindowClass UI_ButtonGroup::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return  "button";
#elif defined(__OS2__)
    return WC_STATIC;
#elif defined(__X_MOTIF__)
    // return xmBulletinBoardWidgetClass;
    return yCompositeWidgetClass;
#endif
}





bool UI_ButtonGroup::_TitleChanged ()
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    return UI_VObjCollection::_TitleChanged ();

#elif defined(__OS2__)
    return UI_VObjCollection::_TitleChanged ();

#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE; // Not yet set up
    XmString xmtitle;
    xmtitle = XmStringCreate ((char*)_title.AsPtr(),
                              XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (_frameWidget, XmNlabelString, xmtitle, NULL);
    XmStringFree (xmtitle);
    XmUpdateDisplay (_xwidget);
    return TRUE;
#endif
}


bool UI_ButtonGroup :: _FontChanged ()
{
#if defined (__X_MOTIF__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h <= 0 || !_frameLabel)
        return FALSE;
    Display *dpy = XtDisplay (_frameLabel);
    XmFontList f = XmFontListCreate (XQueryFont (dpy, h),
                                     XmSTRING_DEFAULT_CHARSET);
    Arg arg [1];
    XtSetArg       (arg [0], XmNfontList,  f);
    XtSetValues    (_frameLabel, arg, 1);
    XmFontListFree (f);
#endif
    return UI_VObjCollection::_FontChanged ();
}


#if defined(__X_YACL__)
void UI_ButtonGroup::DrawVisualElement ()
{
    if (!_visible)
        return;
    UI_DisplaySurface& sfc = CreateDisplaySurface();

    // First we draw a rectangle
    UI_ShadowedLine top (2, 8, _shape.Width() - 4,
                         UI_ShadowedLine::Recessed);
    UI_ShadowedLine bottom (2, _shape.Height() - 5, _shape.Width() - 4,
                            UI_ShadowedLine::Recessed);
    UI_ShadowedLine left (1, 10, _shape.Height() - 12,
                          UI_ShadowedLine::Recessed,
                          UI_ShadowedLine::Vertical);
    UI_ShadowedLine right (_shape.Width()-4, 10, _shape.Height() - 12,
                           UI_ShadowedLine::Recessed,
                           UI_ShadowedLine::Vertical);
    top.DrawOn (sfc);
    left.DrawOn (sfc);
    bottom.DrawOn (sfc);
    right.DrawOn (sfc);

    // Then we erase the label region
    UI_Font& fnt = sfc.Font();
    long l = fnt.TextWidth (_title);
    long h = fnt.Height();
    
    sfc.ColorRectangle (UI_Rectangle (10, 2, l+10, h), _bgColor);

    // Finally we draw the label
    sfc.WriteString (_title, UI_Rectangle (15, 2, l+2, h));

    // All done
    DestroyDisplaySurface ();
}

bool UI_ButtonGroup::HandleEvent (UI_Event* e)
{
    if (!e)
        return FALSE;
    switch (e->Type()) {
    case Event_Paint:
        DrawVisualElement();
        break;

    default:
        break;
    }
    return ProcessEvent (e);
            
}
#endif


#if defined(__OS2__)
MRESULT
#if !defined(__IBMCPP__)
EXPENTRY
#endif
UI_ButtonGroup::ButtonGroupProc (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    UI_ButtonGroup* grp = (UI_ButtonGroup*) (*_Controller)[hWnd];
    switch (msg) {
//     case WM_ERASEBACKGROUND:
//         CL_Error::Warning ("ButtonGroup erase: hwnd %d\n", hWnd);
//         break;
//         
//     case WM_PAINT: {
//         if (grp) {
//             CL_Error::Warning ("ButtonGroup paint: hwnd %d\n", hWnd);
//         }
//         break;
//     }
        
//         HPS hps = WinGetPS (hWnd);
//         RECTL rect;
//         WinQueryWindowRect (hWnd, &rect);
//         HRGN hrgn = GpiCreateRegion (hps, 1, &rect);
//         GpiSetClipRegion (hps, hrgn, NULL);
//         GpiErase (hps);
//         GpiDestroyRegion (hps, hrgn);
//         WinReleasePS (hps);

    default:
        break;
    }
    if (grp)
        return (*(grp->_oldProc))(hWnd, msg, p1, p2);
    return WinDefWindowProc (hWnd, msg, p1, p2);
    
}

void UI_ButtonGroup::_Subclass ()
{
#if defined(__IBMCPP__)
    _oldProc = WinSubclassWindow (_handle, CallBackButtonGroupProc);
#else
    _oldProc = WinSubclassWindow (_handle, UI_ButtonGroup::ButtonGroupProc);
#endif
}

#endif


