#ifndef _brush_h_
#define _brush_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



/*
  Authors: M. A. Sridhar
           N. Bhowmik
*/


#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/dsplrsrc.h"
#include "ui/color.h"


// A Brush is an object used to draw patterns and colors on a
// DrawingSurface. An application does not create a Brush; it merely uses
// the Brush returned by the {\tt Brush} method of the DrawingSurface and
// its derived classes. The Brush only maintains attributes of the brush; the
// actual drawing is done by the DrawingSurface object.


//[ Global
enum UI_BrushPattern   {
    UIBrush_Hatched, UIBrush_Hollow, UIBrush_Solid
};
//] Global


class YACL_UI UI_BrushDescriptor;

class YACL_UI UI_Brush: public UI_DisplayResource {

public:
    UI_Brush (UI_DrawingSurface* ctxt, const UI_Color& color,
              UI_BrushPattern pattern);
    // Construct a brush with given color and pattern for the given
    // DrawingSurface.


    ~UI_Brush ();
    // Destructor.

    void Pattern (UI_BrushPattern p);
    // Set the brush pattern to {\tt p}.

    UI_BrushPattern Pattern ();
    // Return the brush pattern.

    UI_BrushDescriptor Descriptor () const;
    
    const UI_Color& Color ();
    // Return the color of the Brush.

    void Color (const UI_Color& c);
    // Set the color of the Brush to {\tt c}.
    
    void operator= (const UI_BrushDescriptor&);
    // Assignment operator.

    void operator=   (const CL_Object& x);

    const char* ClassName() const {return "UI_Brush";};
    // Override the inherited {\small\tt CL_Object}'s method.

protected:

    UI_Color          _color;
    UI_BrushPattern   _pattern;

    void              _Setup();

};





// A BrushDescriptor merely describes the attributes of a Brush. In contrast, a
// Brush instance might include platform-specific data that relates the
// attributes to a particular DrawingSurface.

class YACL_UI UI_BrushDescriptor: public CL_Object {

public:
    UI_BrushDescriptor (const UI_Color& clr, UI_BrushPattern p)
    :  color (clr), pattern (p) {};

    UI_BrushDescriptor (const UI_BrushDescriptor& c)
    : color (c.color), pattern (c.pattern) {};

    ~UI_BrushDescriptor () {};
    
    const char* ClassName () const {return "UI_BrushDescriptor";};
    
    UI_Color        color;
    UI_BrushPattern pattern;
};


#endif

