


!include ..\control\borlandc.ctl

LIBRARY  = $(UI)
LIBRARYP = $(YACLLIB)\$(LIBRARY)


# ------------------------ Names of object files --------------------------

OBJECTS =       \
3dlabel.obj     \
applic.obj      \
arc.obj         \
bitmap.obj      \
bmpbtn.obj      \
bmpushbn.obj    \
bmtglbtn.obj    \
brush.obj       \
btngroup.obj    \
canvas.obj      \
chord.obj       \
cntroler.obj    \
color.obj       \
combobox.obj    \
composit.obj    \
containr.obj    \
cursor.obj      \
dateedit.obj    \
dialog.obj      \
dsinmem.obj     \
dsplrsrc.obj    \
dsplsurf.obj    \
dwgsurf.obj     \
ellipse.obj     \
event.obj       \
font.obj        \
fontdesc.obj    \
graphic.obj     \
grutils.obj     \
interval.obj    \
label.obj       \
lineseg.obj     \
menu.obj        \
monthcal.obj    \
numedit.obj     \
orbtngrp.obj    \
pen.obj         \
piewedge.obj    \
point.obj       \
pswdedit.obj    \
pushbtn.obj     \
rectangl.obj    \
scrolbar.obj    \
scrolwin.obj    \
shadolin.obj    \
shadorec.obj    \
shadotrg.obj    \
simple.obj      \
stddlg.obj      \
stencil.obj     \
stred.obj       \
strseq.obj      \
strview.obj     \
textedit.obj    \
timer.obj       \
toglbtn.obj     \
vector.obj      \
visualob.obj    \
vobjcoll.obj    \
xrbtngrp.obj    \
xrtglbtn.obj


STATIC_OBJS  = statui.obj
MAINPROG     = mainprog.obj

!if $(YACLPLATFORM) == OS2
PLATFORM_OBJECTS = os2evt.obj  mdi.obj printjob.obj
!elif $(YACLPLATFORM) == WINDOWS || $(YACLPLATFORM) == WIN32
PLATFORM_OBJECTS =  mdi.obj printjob.obj winevt.obj \
copy.obj dibutil.obj errors.obj file.obj
!endif



# ---------------------- Compilation rules -----------------------


.SUFFIXES:
.SUFFIXES: .cxx .obj


CCOPTS    = $(CCOPTS) -Jgd


TARGET = $(LIBRARYP).lib


# Somehow I am still not able to get the UI DLL to work correctly. So it is
# disabled for now.
#
!if $d(BUILD_DLL)
!if $(YACLPLATFORM) == WINDOWS
CCOPTS   = $(CCOPTS) -DBUILD_DLL -WDE -tWDE -p-
TARGET   = $(LIBRARYP).dll
LINK_DLL = -Twd -C -c -A:16
C0OBJD   = c0dl
COBJD    = crtldll cwl 
IMPORT   = import
MATH     = mathwl
DLLMAIN  = dllmain.obj
!elif $(YACLPLATFORM) == WIN32
CCOPTS   = -WDE -tWDE $(CCOPTS) -DBUILD_DLL 
TARGET   = $(LIBRARYP).dll
LINK_DLL = -Tpd 
C0OBJD   = c0d32
COBJD    = cw32
IMPORT   = import32
CPP_IMP  = cl.lib
MATH     = 
DLLMAIN  = dllmain.obj
!elif $(YACLPLATFORM) == OS2
CCOPTS   = $(CCOPTS) -sd  -DBUILD_DLL
TARGET   = $(LIBRARYP).dll
LINK_DLL = -Tod
C0OBJD   = c02d
COBJD    = c2mt  os2
DLLDEF   = uidll.def
DLLMAIN  =
!else
!error Cannot build dll for $(YACLPLATFORM).
!endif
!endif



!if $d(DEBUG)
.cxx.obj:
    $(CC) -v -DDEBUG +$(LIBRARY).cfg  { $<}
    
.c.obj:
    $(CC) -v -DDEBUG +$(LIBRARY).cfg  -P- $<
    
!else
.cxx.obj:
    $(CC) +$(LIBRARY).cfg  { $<}
    
.c.obj:
    $(CC) +$(LIBRARY).cfg -P- $<
    
!endif



all: $(LIBRARY).cfg $(TARGET)



$(LIBRARYP).lib: $(OBJECTS) $(MAINPROG) $(STATIC_OBJS) $(PLATFORM_OBJECTS)
    $(LIBR) $(LIBRARYP)   @&&!
-+$(OBJECTS: = -+) -+$(MAINPROG) -+$(PLATFORM_OBJECTS: = -+) -+$(STATIC_OBJS) /P256
!
    -$(COPY) $(MAINPROG) $(YACLLIB)
    -$(DELETE) $(LIBRARYP).bak
    -$(DELETE) $(LIBRARY).cfg




$(LIBRARY).cfg: borlandc.mak $(YACLPATH)\control\borlandc.ctl
	copy &&|
$(WARNINGS) $(CCOPTS)
| $(LIBRARY).cfg



$(LIBRARYP).dll: $(OBJECTS) $(MAINPROG) $(PLATFORM_OBJECTS) $(STATIC_OBJS) $(DLLMAIN) uidll.def
    $(LINK) -c -x $(DEBUG) $(LINK_DLL) -L$(BCPATH)\lib @&&|
    $(BCPATH)\lib\$(C0OBJD).obj $(OBJECTS) $(PLATFORM_OBJECTS) \
    $(STATIC_OBJS) $(DLLMAIN)
    $(LIBRARYP).dll
    NUL
    $(YACLLIB)\$(BASE) $(YACLLIB)\$(IO) $(THREED) $(IMPORT) $(MATH)  $(COBJD)
|, uidll.def 
    implib $(LIBRARYP).lib $(LIBRARYP).dll
    -$(COPY) $(MAINPROG) $(YACLLIB)
    -del uidll.def


!if $(YACLPLATFORM) == OS2
stddlg.obj: support/os2/stddlg.cxx

os2evt.obj: support/os2/os2evt.cxx

!else
stddlg.obj: support/windows/stddlg.cxx

winevt.obj: support/windows/winevt.cxx

copy.obj: support/windows/copy.c

errors.obj: support/windows/errors.c

dibutil.obj: support/windows/dibutil.c

file.obj: support/windows/file.c


!endif



!if $(YACLPLATFORM) == WINDOWS
uidll.def:
    copy &&|
    LIBRARY ui;dll
    EXETYPE WINDOWS
    CODE PRELOAD MOVEABLE DISCARDABLE
    DATA PRELOAD MOVEABLE MULTIPLE
    HEAPSIZE 32000
| uidll.def
!elif $(YACLPLATFORM) == WIN32
uidll.def:
    copy &&|
    LIBRARY ui;dll
    EXETYPE WINDOWS
    CODE PRELOAD MOVEABLE DISCARDABLE
    DATA PRELOAD MOVEABLE MULTIPLE
    HEAPSIZE 32000
| uidll.def
!elif $(YACLPLATFORM) == OS2
uidll.def:
    copy &&|
    LIBRARY UI
    DESCRIPTION 'YACL UI LIBRARY'
    PROTMODE
    DATA  NONSHARED READWRITE LOADONCALL
    CODE  LOADONCALL
    HEAPSIZE 64000
| uidll.def
!endif




# ------------------ Other targets ---------------------------


clean:
    -del *.obj
    -del *.cfg
    -del $(LIBRARYP).lib
    -del $(LIBRARYP).bak






