

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif

#include "ui/bmpushbn.h"
#include "ui/applic.h"
#include "ui/event.h"
#include "ui/cntroler.h"
#include "ui/dsplsurf.h"
#include "ui/shadorec.h"

#if defined (__MS_WINDOWS__) || defined(__MS_WIN32__)
#    define BUTTON_STYLE WS_CHILD | WS_VISIBLE | WS_TABSTOP
#elif defined(__OS2__)
#    define BUTTON_STYLE WS_VISIBLE | BS_USERBUTTON
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Xlib.h>
#    include <X11/Intrinsic.h>
#    include <Xm/Xm.h>
#    include <Xm/PushB.h>
#endif

UI_BitmapPushButton::UI_BitmapPushButton (UI_VisualObject* parent,
                                          const UI_Rectangle& shape,
                                          UI_ViewID id,
                                          UI_BitmapData* eData,
                                          UI_BitmapData* dData)
: UI_BitmapButton (parent, shape, id)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    _style = BUTTON_STYLE;
#endif
    _model = &_title;
    _ownModel = FALSE;
    if (eData)
        _enabledBitmap.BuildFrom (*eData);
    if (dData)
        _disabledBitmap.BuildFrom (*dData);
}


UI_BitmapPushButton::~UI_BitmapPushButton ()
{
}


#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
void UI_BitmapPushButton::Press ()
{
}

void UI_BitmapPushButton::Release ()
{
}

bool UI_BitmapPushButton::IsRaised ()
{
    return TRUE; // Always drawn in raised state
}

#endif


UI_WindowClass UI_BitmapPushButton::WindowClass() const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    return UI_BitmapButton::WindowClass();
#elif defined(__X_MOTIF__)
    return xmPushButtonWidgetClass;
#endif
}

void UI_BitmapPushButton::_PrivateInitialize ()
{
    UI_BitmapButton::_PrivateInitialize ();
#if defined(__X_MOTIF__)
    XtAddCallback (_xwidget, XmNactivateCallback, 
                   &UI_BitmapPushButton::SelectionCallback, (XtPointer) this);
#endif
}

#if defined(__X_MOTIF__)
void UI_BitmapPushButton::SelectionCallback (Widget , void* client,
                                             void* call)
{
    UI_BitmapPushButton* btn = (UI_BitmapPushButton *) client;
    XmAnyCallbackStruct* cb = (XmAnyCallbackStruct*) call;
    if (cb->reason == XmCR_ACTIVATE) {
        UI_Event evt (Event_Select, btn, btn);
        _Controller->DispatchEvent (&evt);
    }
}
#endif
