

#ifndef _bmpbtn_h_ /* Sun Sep 17 14:50:51 1995 */
#define _bmpbtn_h_


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// BitmapButton represents a button that uses a bitmap in its visual
// representation. It does not use its title string. It can use two
// different bitmaps, one in enabled state and one in disabled state. To
// use this class, you can specify either just the enabled bitmap or both
// the enabled and disabled bitmaps. These bitmaps can either be specified
// at object construction time (via constructor parameters) or by
// assignment to the return values of the methods {\tt EnabledBitmap()}
// and {\tt DisabledBitmap()} that return these two bitmaps. Note that the
// return values of these methods may be modified via any of the Bitmap
// methods, e.g.:
//
// \begin{verbatim}
//
//    myBmpButton->EnabledBitmap().BuildFrom ("favorite.bmp");
//
// \end{verbatim}
//
// BitmapButton is an abstract class from which are derived BitmapPushButton
// and BitmapToggleButton.
//
// Caveat: This class overrides the inherited HandleEvent method. So any
// class derived from this one should not override HandleEvent, or should
// exercise care if it does.


#include "ui/simple.h"
#include "ui/bitmap.h"

class YACL_UI UI_BitmapButton: public UI_SimpleVObject {

public:
    virtual UI_Bitmap& EnabledBitmap ();
    // Return the bitmap used by this button when it is in enabled state.

    virtual UI_Bitmap& DisabledBitmap ();
    // Return the bitmap used by this button when it is in disabled state.
    
    UI_WindowClass WindowClass () const;

    bool Enable ();
    // Override the inherited method.

    bool Disable ();
    // Override the inherited method.

    const char* ClassName () const {return "UI_BitmapButton";};
    
    
protected:
    UI_BitmapButton (UI_VisualObject* parent, const UI_Rectangle& shape,
                     UI_ViewID id);
    // Constructor protected, so can only be instantiated via derived class.

    ~UI_BitmapButton ();

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__OS2__)
    bool HandleEvent (UI_Event* e);
    // Override the inherited method. Classes derived from BitmapButton
    // should not override this method; if they do, they should call
    // UI_BitmapButton::HandleEvent in their implementation.

    virtual bool IsRaised () = 0;
    // Pure virtual. This hook is used by BitmapButton to query the derived
    // class whether the button must be drawn in raised state. If the return
    // value is FALSE, the button will be drawn in recessed state.

    virtual void Press () = 0;
    // Pure virtual. This hook is used by BitmapButton to tell the derived
    // class that it has been pressed, either via mouse or keyboard.

    virtual void Release () = 0;
    // Pure virtual. This hook is used by BitmapButton to tell the derived
    // class that it has been released after being pressed, either via mouse
    // or keyboard.

    void DrawRaised ();
    // Draw this button in raised state.

    void DrawRecessed ();
    // Draw this button in recessed state.

    bool _DrawDisabledBitmap (UI_DwgSurfHandle h);

    void _DrawBitmap (UI_DwgSurfHandle h);
    
#elif defined(__X_MOTIF__)
    void _SetEnabledBitmap ();
    // [X-windows-specific, for internal use only] Called to set the
    // button's bitmap resource.
    
    void _SetDisabledBitmap ();
    // [X-windows-specific, for internal use only] Called to set the
    // button's bitmap resource.
    
    void _SetupStyle (void* p, short& argn);
    // [X-windows-specific, for internal use only] override the inherited
    // method to set X resources.
    
#endif

    virtual bool _EnabledBitmapChanged ();
    // Called by this object's Bitmap to inform that the Bitmap has changed.
    
    virtual bool _DisabledBitmapChanged ();
    // Called by this object's Bitmap to inform that the Bitmap has changed.
    
    void _PrivateInitialize ();
    
    UI_Bitmap _enabledBitmap;
    UI_Bitmap _disabledBitmap;
};




inline UI_Bitmap& UI_BitmapButton::EnabledBitmap ()
{
    return _enabledBitmap;
}


inline UI_Bitmap& UI_BitmapButton::DisabledBitmap ()
{
    return _disabledBitmap;
}




#endif /* _bmpbtn_h_ */
