#ifndef _applic_h_
#define _applic_h_





/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



/* Authors:   M. A. Sridhar
              N. Bhowmik
*/


// This class provides the basic behaviour of ``global state'' of a GUI
// application. It includes methods for creating and
// destroying the root window for the application, destroying individual views,
// terminating the application itself, and the like.  It also
// includes the main entry point for the
// application (the method {\tt Main}).




#if defined(__GNUC__)
#pragma interface
#endif



#include "base/map.h"
#include "ui/uidefs.h"
#include "ui/rectangl.h"


class YACL_UI UI_CompositeVObject;
class YACL_UI UI_Controller;
class YACL_UI UI_VisualObject;
class YACL_UI UI_FontEntrySet;

class YACL_UI UI_Application: public CL_Object {

public:

    // --------------- Construction and destruction ---------------------
    UI_Application();
    // Default constructor: set up the environment Map and the warning and
    // fatal error handlers of the {\tt CL_Error} class.

    virtual ~UI_Application();
    // Destructor: clean up and exit.

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    virtual void Initialize (HANDLE hInstance, HANDLE hPrevInstance,
                             LPSTR lpCmdln, int nCmdShow);
    // [MS-Windows-specific method]
    // Initialize the application, and create and initialize the single
    // Controller instance.
    
    
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    virtual void Initialize (int& argc, char *argv[]);
    // [X-Windows-specific method]
    // Initialize the application, and create and initialize the single
    // Controller instance.

#elif defined(__OS2__)
    virtual void Initialize (int argc, char *argv[]);
    // [OS/2-specific method]
    // Initialize the application, and create and initialize the single
    // Controller instance.

#endif

    // ------------------------- Querying -----------------------------
    
    UI_Pid ProcessId () const {return pid; };
    // Return the process id of this process.  Under MS-Windows, this method
    // returns the instance handle of the application.

    const CL_StringStringMap& Environment () const {return _env;};
    // Return a reference to a Map containing the environment variables and
    // their values. Note that some environment variables may have null
    // values associated with them, because they were set that way;
    // therefore, unlike the conventions with YACL Maps, the fact that {\tt
    // Environment ()[v] == ""} does not mean that {\tt v} is not a defined
    // environment variable. This must be ascertained explicitly via the Map's
    // {\tt IncludesKey} method.
    
    UI_CompositeVObject* MainWindow () const;
    // Return the main window of the application. This method returns NULL
    // if the main window has not yet been created.

    UI_Rectangle ScreenRect () const;
    // Return the rectangle corresponding to the screen. Its origin will
    // be set at (0,0).

    UI_Point AsScreenPoint (const UI_Point& windowPoint,
                            UI_VisualObject* vObj) const;
    // Given a point in the co-ordinate space of {\tt vObj}, translate it to
    // screen co-ordinates and return the result.
    
    
    UI_Controller& Controller();  
    // Return a reference to the  Controller object. 

    CL_String ErrorString () const;
    // Return a string containing an indication of the most recent
    // error. The content of this string is platform-dependent.
    
    // --------------- Creating and destroying views ------------------
    
    void MakeTopWindow (UI_CompositeVObject* topWindow);
    // Make the given object the root window of the application. This method
    // must be called only once, at the beginning of the application.

    virtual void Destroy (UI_VisualObject* v);
    // Close down and destroy the given visual object.

    // --------------------------- Execution ------------------------

    int Main (int argc, char* argv[]);
    // Entry point for a GUI application. If the application does not supply
    // its own (platform-specific) main program, it must supply this method,
    // which will be called by the library's built-in main program. The
    // parameters will be supplied in Unix style, with {\tt argc} being the
    // number of command-line arguments and {\tt argv} being the arguments
    // themselves. The name of the program will be in {\tt argv[0]}.
    
    virtual void Run ();
    // Execute the application. Simply invokes {\tt Run()} on the controller.

    virtual void End ();
    // Terminate the application. This method generates a Quit event for
    // the root window. 


    // ------------------------- Miscellaneous services --------------
    virtual CL_String InstanceName (UI_VisualObject* v);
    // Return the instance name of the given visual object. This method is
    // used under X-windows to set the instance name at the time of widget
    // creation, and derived classes may override it. The default
    // implementation constructs a string with the class name, the view id
    // and a unique widget number. This method is not used inder MS-Windows
    // or OS/2.

    virtual CL_String Name () const;
    // Return the name of this application. The default implementation
    // returns the name of the application's executable file. This method
    // is used to determine the application's name under X windows, and
    // derived classes may override it; it is
    // not used under MS-Windows or OS/2.
    
    virtual CL_String AppClass () const;
    // Return the class name of this application. The default implementation
    // returnes the string returned by the {\tt Name} method with its first
    // letter capitalized (to meet the X windows convention). This method
    // is used to determine the application's class under X windows; it is
    // not used under MS-Windows or OS/2.
    
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    Display* AppDisplay () {return _display;};
    // [X-windows-specific method, for YACL internal use only] return the
    // {\tt Display} pointer for this application.

#endif

    // --------------------- End public protocol -----------------------
    
protected:
    
    UI_Controller*     _controller;
    CL_StringStringMap _env;
    
    UI_Pid pid;
#if defined(__X_MOTIF__) || defined(__X_YACL__)
    Display* _display;
#endif
    CL_String _name;
   
    short _widgetCount;

    short NextWidgetNumber () { return ++_widgetCount;};
    
public:
#if defined(__OS2__)
    UI_Rectangle YACLRect (UI_ViewHandle parent, const RECTL& rect) const;
    // [OS/2-specific, internal use only]

    static void PMError ();
    // [OS/2-specific, internal use only] Ask PM for the most recent error
    // string, and send it out as {\tt CL_Error::Warning}.

    static UI_ViewHandle MenuBarHandle (UI_ViewHandle vObjHandle);
    // [OS/2-specific, for YACL internal use only] If {\tt vObjHandle} is the
    // handle of a Composite window that has a menu
    // bar, return the handle of the menu bar. Otherwise, return 0.
    
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    CL_PtrIntMap& BrushPool () {return _brushPool;};
    // [MS-Windows-specific, YACL internal use only] The pool of brushes
    // needed to support background and foreground colors for visual objects.

protected:
    CL_PtrIntMap _brushPool;
    
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__X_YACL__) || defined(__X_MOTIF__)

public:
    UI_FontEntrySet* FontEntries () const {return _fontEntries;};
    // [MS- and X-windows-specific, for YACL internal use only]
    
private:
    UI_FontEntrySet* _fontEntries;
#endif
    
};


//[ Global

UI_Application* YACL_UIFUNC YACLApp ();

// This is a global function that returns a pointer to the single
// instance  of {\tt UI_Application}.
//] Global


inline UI_Controller& UI_Application::Controller ()
{
    return *_controller; 

}


#endif
