




/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include <setjmp.h>

#if defined(__WATCOMC__)
#include <stdlib.h>
#endif

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#    include <dos.h>
#    include <windows.h>
#    if defined(USE_CTL3D)
#        include <ctl3d.h>
#    endif
#elif defined(__X_MOTIF__)
#    if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#        include <string.h>  // Without this, the X includes barf
#    endif
#    include <X11/Xlib.h>
#    include <X11/Intrinsic.h>
#    include <iostream.h>
#elif defined(__X_YACL__)
#    include <iostream.h>
#elif defined(__OS2__)
#    include <stdlib.h>
#    if defined(__GNUC__)  // EMX compiler
#        define OS2EMX_PLAIN_CHAR
#    endif
#    define INCL_PM
#    define INCL_DOSPROCESS
#    include <os2.h>
#endif


#include "base/error.h"
#include "base/string.h"
#include "base/strgseq.h"

#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/cntroler.h"


// ------------------------ FontEntrySet stuff -----------------------

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__X_YACL__) || defined(__X_MOTIF__)
#include "base/objset.h"

// No FontEntrySet under OS/2

class YACL_UI UI_FontEntrySet: public CL_ObjectSet {
    // This class declaration is duplcated in font.cxx. Since it's so
    // short, and in any case it's not a public class, I don't have a
    // separate header file for it.
public:
    ~UI_FontEntrySet () {DestroyContents();};
};

#endif


// --------------------------- Global variables ------------------------

static UI_Application* _TheApplication = NULL;

#if defined(__UNIX__)
#define ENVIRONMENT environ
extern char** environ;
#elif __BCPLUSPLUS__ > 0x310
#define ENVIRONMENT _environ
#else
#define ENVIRONMENT environ
#endif


// ----------------------------------------------------------------


#if (defined(__MS_WINDOWS__) || defined(__MS_WIN32__)) && defined(DEBUG)
static HWND _DebugWindow = 0;
static HFONT _DebugFont = 0;
static long  count = 0;
#elif defined(__OS2__) && defined(DEBUG)
static HWND dbugWin = 0;
static HWND dbugWinFrame = 0;
static short count = 0;
#endif

static bool ErrorHandler (const char* message)
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#if defined(DEBUG)
    if (_DebugWindow) {
        CL_String s = "(" + CL_String(++count) + ") " +
            CL_String (message) + "\r\n";
        SendMessage (_DebugWindow, EM_REPLACESEL, 0,
                     (LPARAM) s.AsPtr());
    }
#else
    MessageBox (NULL, message, "YACL", MB_ICONEXCLAMATION | MB_OK);
#endif
#elif defined(__X_MOTIF__) || defined(__X_YACL__)
    cerr << "YACL: " <<  message << endl;
#elif defined(__OS2__)
#if defined(DEBUG)
    CL_String s = "(" + CL_String (++count) + ") " + message;
    WinSendMsg (dbugWin, MLM_INSERT, (MPARAM) s.AsPtr(), 0);
#else
    static const short ID_MESSAGEBOX = 501; // Arbitrary value
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, (PCH) message,
                  (PCH) "YACL", ID_MESSAGEBOX,
                  MB_OK | MB_APPLMODAL | MB_MOVEABLE | MB_ERROR);
#endif
#endif
    return TRUE;
}



UI_Application* YACLApp()
{
    return _TheApplication;
}

UI_Application::UI_Application()
{
    CL_Error::SetWarningHandler    (ErrorHandler);
    CL_Error::SetFatalErrorHandler (ErrorHandler);

    if (_TheApplication)
        CL_Error::Fatal ("Application constructor: attempt to construct"
                         "more than one Application object!");
    _TheApplication = this;
    // Set up the environment map
    for (short i = 0; ENVIRONMENT[i] != NULL; i++) {
        CL_String s (ENVIRONMENT[i]);
        short j = s.CharIndex ('=');
        if (j >= 0)
            _env.Add (s(0,j), s.Suffix(j+1));
    }
    _widgetCount = 0;
#if defined(__X_MOTIF__)
    _display = NULL;
#endif
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__X_YACL__) || defined(__X_MOTIF__)
    _fontEntries = new UI_FontEntrySet;
#endif
}



UI_Application::~UI_Application()
{
    delete _controller;
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#if defined(DEBUG)
    DestroyWindow (_DebugWindow);
    DeleteObject (_DebugFont);
#endif
#if defined(USE_CTL3D)
    Ctl3dUnregister (pid);
#endif
    CL_PtrIntMapIterator itr (_brushPool);
    while (itr.More()) {
        CL_PtrIntAssoc a = itr.Next();
        delete a.key;
        DeleteObject ((HBRUSH) a.value);
    }
#endif
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__) || defined(__X_MOTIF__)
    delete _fontEntries;
#endif
}


CL_String UI_Application::Name () const
{
    return _name;
}


CL_String UI_Application::AppClass () const
{
    CL_String t = _name;
    t.WordCapitalize();
    return t;
}


CL_String UI_Application::ErrorString() const
{
#if defined(__MS_WIN32__)
    CL_String s;
//    LPSTR bufPtr = "";
    char bufPtr[1000];
    int errCode = GetLastError();
    FormatMessage (FORMAT_MESSAGE_FROM_SYSTEM, 0, errCode, 0, bufPtr, 0, 0);
    s.AssignWithFormat ("Win32 error code %d: %s", errCode, bufPtr);
    //    LocalFree (bufPtr);
    return s;
#elif defined(__OS2__)
    PERRINFO  errInfo;
    PSZ       offset;
    PSZ  errMsg;

    CL_String errorString;
    HAB hab = _controller->AnchorBlockHandle();
    if ((errInfo = WinGetErrorInfo (hab)) != NULL) {
        offset = ((PSZ) errInfo) + errInfo->offaoffszMsg;
        errMsg = ((PSZ) errInfo) + *((PSHORT) offset);
        errorString.AssignWithFormat ("PM Error: %s\n", errMsg);
        WinFreeErrorInfo (errInfo);
    }
    return errorString;
#else
    return "";
#endif
}

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

void UI_Application::Initialize
    (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdln, int nCmdShow)
{
    pid = hInstance;
#if defined(DEBUG)
    _DebugWindow = CreateWindow
        ("edit", "DEBUG",
         ES_MULTILINE  | WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_VSCROLL,
         CW_USEDEFAULT, CW_USEDEFAULT, 500, 400,
         NULL, NULL, hInstance, NULL);
    _DebugFont = CreateFont (14, 0, 0, 0, FW_BOLD, 0, 0, 0, DEFAULT_CHARSET,
                              OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                              DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE,
                              "Courier");
    SendMessage (_DebugWindow, WM_SETFONT, (UINT) _DebugFont, 0);
#endif
    _name = CL_String (lpCmdln).Field (1);
    _controller = new UI_Controller ( this );
    _controller->Initialize (hInstance, hPrevInstance, lpCmdln, nCmdShow);

#if defined(USE_CTL3D)
    Ctl3dRegister (pid);
    Ctl3dAutoSubclass (pid);
#endif
}


#elif defined(__X_MOTIF__) || defined(__X_YACL__)
void UI_Application::Initialize (int& argc, char* argv[])
{
    CL_StringSequence seq =  CL_String (argv[0]).Split ("/");
    _name = seq[seq.Size()-1];
    _controller = new UI_Controller (this);
    _controller->Initialize (argc, argv);
    _controller->DispatchPendingEvents();
    _display = _controller->AppDisplay ();
}
#elif defined(__OS2__)
void UI_Application::Initialize (int /* argc */, char* argv[])
{
    PPIB pib;
    PTIB tib;
    _name = argv[0];
    DosGetInfoBlocks (&tib, &pib);
    pid = pib->pib_ulpid;
    _controller = new UI_Controller (this);
    _controller->Initialize ();
#if defined(DEBUG)
    ulong style = FCF_SHELLPOSITION | FCF_TITLEBAR | FCF_SIZEBORDER |
        FCF_VERTSCROLL;
    dbugWinFrame = WinCreateStdWindow
        (HWND_DESKTOP, WS_VISIBLE, &style,
         WC_MLE, "DEBUG", 0, 0, 0, &dbugWin);
    CL_String fontString = "8.Courier";
    WinSetPresParam (dbugWin, PP_FONTNAMESIZE, fontString.Size()+1,
                     (void*) fontString.AsPtr());
#endif
}
#endif



void UI_Application::MakeTopWindow (UI_CompositeVObject* root)
{
    _controller-> MakeTopWindow (root);
}



void UI_Application::Destroy(UI_VisualObject *v)
{
    if (v != NULL && _controller->Root() != NULL)
        _controller->AddEvent (new UI_Event (Event_Quit, v));
    // Instead of: _controller->Destroy (v);
}



void UI_Application::Run ()
{   
    if ( _controller  ) 
        _controller->Run ();
}



void UI_Application::End ()
{
    if (_controller)
        _controller->AddEvent (new UI_Event
                               (Event_Quit, _controller->Root ()));
}




UI_CompositeVObject* UI_Application::MainWindow () const
{
    return _controller ? _controller->Root() : (UI_CompositeVObject*) NULL;
}


CL_String UI_Application::InstanceName (UI_VisualObject* v)
{
    CL_String s;
    s.AssignWithFormat ("%s_%d_%d", v->ClassName(), v->ViewID(),
                        NextWidgetNumber());
    return s;
}


UI_Rectangle UI_Application::ScreenRect () const
{
#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    RECT r;
    GetClientRect (GetDesktopWindow (), &r);
    return UI_Rectangle (r.left, r.top, r.right-r.left+1,
                         r.bottom-r.top+1
                        );

#elif defined (__X_MOTIF__)
    Screen* screen;
    screen = DefaultScreenOfDisplay
        (XtDisplay ((Widget) (_controller->Root()->ViewHandle())));
    long height = HeightOfScreen (screen);
    long width  = WidthOfScreen  (screen);
    return UI_Rectangle (0, 0, width, height);

#elif defined (__X_YACL__)
    Screen* screen = DefaultScreenOfDisplay (_controller->AppDisplay());
    long height = HeightOfScreen (screen);
    long width  = WidthOfScreen  (screen);
    return UI_Rectangle (0, 0, width, height);

#elif defined(__OS2__)
    RECTL rect;
    WinQueryWindowRect  (HWND_DESKTOP, &rect);
    return UI_Rectangle (rect.xLeft, rect.yTop, rect.xRight - rect.xLeft + 1,
                          rect.yTop  - rect.yBottom + 1);
#endif
}


UI_Point UI_Application::AsScreenPoint (const UI_Point& p,
                                        UI_VisualObject* vObj) const
{
    if (!vObj || !vObj->ViewHandle())
        return UI_Point (0, 0);
#if defined(__X_MOTIF__)
    Position x, y;
    XtTranslateCoords (vObj->ViewHandle(), p.XCoord(), p.YCoord(),
                       &x, &y);
    return UI_Point (x, y);
#elif defined(__X_YACL__)
    int x, y;
    Window c;
    XTranslateCoordinates (_display, vObj->ViewHandle(),
                           RootWindow(_display, DefaultScreen (_display)),
                           p.XCoord(), p.YCoord(),
                           &x, &y, &c);
    return UI_Point (x, y);
#elif defined(__OS2__)
    POINTL pt;
    pt.x = p.XCoord();
    pt.y = p.YCoord();
    WinMapWindowPoints (vObj->ViewHandle(), HWND_DESKTOP, &pt, 1);
    return UI_Point (pt.x, pt.y);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    POINT pt;
    pt.x = p.XCoord();
    pt.y = p.YCoord();
    ClientToScreen (vObj->ViewHandle(), &pt);
    return UI_Point (pt.x, pt.y);
#endif
}



#if defined(__OS2__)
UI_Rectangle UI_Application::YACLRect (UI_ViewHandle parent, const RECTL&
                                       rect) const
{
    long ht = _YACLWindowHeight (parent);
    return UI_Rectangle (rect.xLeft, ht - rect.yTop,
                         rect.xRight - rect.xLeft + 1,
                         rect.yTop - rect.yBottom + 1);
}


void UI_Application::PMError ()
{
    if (!_TheApplication)
        return;
    CL_String errString = _TheApplication->ErrorString();
    if (errString.Size())
        CL_Error::Warning (errString.AsPtr());
}


UI_ViewHandle UI_Application::MenuBarHandle (UI_ViewHandle vObjHandle)
{
    // If vObjHandle is the handle of a Composite window that has a menu
    // bar, return the handle to the menu bar. Otherwise, return 0.
    if (!vObjHandle)
        return 0;
    HWND hParent = WinQueryWindow (vObjHandle, QW_PARENT);
    if (!hParent)
        return 0;
    char buf[20] = {20*0};
    WinQueryClassName (hParent, sizeof buf, buf);
    if (buf[0] != '#')
        return 0;
    long classPtr = atoi (&buf[1]);
    if (classPtr != (long) WC_FRAME)
        return 0;
    HWND menuHandle = WinWindowFromID (hParent, FID_MENU);
    return menuHandle;
}


#endif



