

!ifndef YACLPATH
!error Please define the environment variable YACLPATH.
!endif



!include $(YACLPATH)\control\msvcpp.ctl



FLAGS = YACLPLATFORM=$(YACLPLATFORM) $(YACLPLATFORM)=1

!ifdef DEBUG
FLAGS = $(FLAGS) DEBUG=1
!endif

!ifdef BUILD_DLL
FLAGS = $(FLAGS) BUILD_DLL=1
!endif

yacl:  libdir base io ui

libdir: pseudo
	-md $(YACLPATH)\lib
	-md $(YACLPATH)\lib\$(YACLPLATFORM)

base: pseudo
	cd base
	-$(MAKE) -fmsvcpp.mak $(FLAGS)
	-cd ..

io: pseudo
        cd io
	-$(MAKE) -fmsvcpp.mak $(FLAGS)
        -cd ..


ui: pseudo
	cd ui
	-$(MAKE) -fmsvcpp.mak $(FLAGS)
        -cd ..


pseudo:

# -------------------- Targets below are for my use only ---------------

    
basedemo: pseudo
    cd basedemo
    $(MAKE) -fmsvcpp.mak
    cd ..

uidemos: pseudo
    cd uidemo
    $(MAKE) -fmsvcpp.mak
    cd ..

apps: pseudo
    cd apps\bmpview
    $(MAKE) -f msvcpp.mak
    cd ..\dlged
    $(MAKE) -f msvcpp.mak
    cd ..\..
    
    


everything: yacl basedemo uidemos apps


clean: pseudo
    cd base
    -$(MAKE) -fmsvcpp.mak clean
    cd ..\io
    -$(MAKE) -fmsvcpp.mak clean
    cd ..\ui
    -$(MAKE) -fmsvcpp.mak clean
    cd ..
    cd basedemo
    -rm -f */*.obj */*.exe */*.map
    cd ..\uidemo
    $(MAKE) -f msvcpp.mak clean
    cd $(YACLLIB)
	-del base.*
	-del io.*
	-del ui.*
	-del memory.*
	-del *.bak
    cd ..\..


