

#ifndef _pathname_h_ /* Sun Aug 18 10:45:27 1996 */
#define _pathname_h_



/*
 *
 *          Copyright (C) 1996, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1996. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// A PathName is the name of a file in a directory system, possibly with
// embedded directory separators ('/' under Unix, '\' under DOS, OS/2 and
// Windows).

#include "io/iodefs.h"  // Include this first!!!

#include "base/string.h"

class YACL_IO CL_PathName: public CL_Object {

public:
    static const char Separator;
    
    CL_PathName (const char* path = ".");
    // Construct a path name from the given character string.

    CL_PathName (const CL_PathName&);
    // Copy constructor.

    ~CL_PathName (){};
    
    CL_String DirectoryName () const;
    // Return the name of the directory of this path. This method returns
    // the string {\tt "."} if there is no directory separator in the given
    // path name.

    CL_String FileName () const;
    // Return the filename portion of this path.

    //    CL_String AbsolutePathName () const;
    // Return the absolute path name of this path. (Not yet implemented.)

    
protected:
    CL_String  _pathName;

    long _RightmostSeparatorPos () const;
    // Return the rightmost position at which the separator occurs. Return
    // -1 if it does not occur.
    
};
#endif /* _pathname_h_ */
