


!include ..\control\borlandc.ctl

LIBRARY  = $(IO)
LIBRARYP = $(YACLLIB)\$(LIBRARY)


# ------------------------ Names of files --------------------------

OBJECTS =  binfile.obj bytstore.obj directry.obj dskbtree.obj \
           pathname.obj slotfile.obj



# ---------------------- Compilation rules -----------------------


.SUFFIXES:
.SUFFIXES: .cxx .obj


CCOPTS    = $(CCOPTS) -Jgx


TARGET = $(LIBRARYP).lib

!if $d(BUILD_DLL)
!if $(YACLPLATFORM) == WINDOWS
CCOPTS   = $(CCOPTS) -DBUILD_DLL -WDE -tWDE -p-
TARGET   = $(LIBRARYP).dll
LINK_DLL = -Twd -C -c -A:16
C0OBJD   = c0dl
COBJD    = crtldll cwl
IMPORT   = import
MATH     = mathwl
DLLMAIN  = dllmain.obj 
!elif $(YACLPLATFORM) == WIN32
CCOPTS   = $(CCOPTS) -DBUILD_DLL -WCD -tWD
TARGET   = $(LIBRARYP).dll
LINK_DLL = -Tpd
C0OBJD   = c0d32
COBJD    = cw32
IMPORT   = import32
MATH     = 
DLLMAIN  = dllmain.obj 
!elif $(YACLPLATFORM) == OS2
CCOPTS   = $(CCOPTS) -sd  -DBUILD_DLL
TARGET   = $(LIBRARYP).dll
LINK_DLL = -Tod
C0OBJD   = c02d
COBJD    = c2 os2
DLLDEF   = base.def
!else
!error Cannot build DLL for $(YACLPLATFORM).
!endif
!endif






.cxx.obj:
    $(CC) $(DEBUG) +$(LIBRARY).cfg  { $<}


        
all: $(LIBRARY).cfg $(TARGET)
    -$(DELETE) $(LIBRARY).cfg


$(LIBRARY).cfg: borlandc.mak $(YACLPATH)\control\borlandc.ctl
    copy &&|
$(WARNINGS) $(CCOPTS)
| $(LIBRARY).cfg


$(LIBRARYP).lib: $(OBJECTS)
    $(LIBR) $(LIBRARYP)  /P64 /E @&&!
-+$(OBJECTS: = -+)
!
    -$(DELETE) $(LIBRARYP).bak
    -$(DELETE) $(LIBRARY).cfg


$(LIBRARYP).dll: $(OBJECTS) $(DLLMAIN) iodll.def
    $(LINK) -c -x $(DEBUG) $(LINK_DLL) -L$(BCPATH)\lib @&&|
    $(BCPATH)\lib\$(C0OBJD).obj $(OBJECTS) $(STATIC_OBJS) $(DLLMAIN)
    $(LIBRARYP).dll
    NUL
    $(YACLLIB)\$(BASE).lib $(IMPORT) $(MATH)  $(COBJD)
|, iodll.def
    implib $(LIBRARYP).lib $(LIBRARYP).dll
    -del iodll.def




!if $(YACLPLATFORM) == WINDOWS
iodll.def:
    copy &&|
    LIBRARY io;dll
    EXETYPE WINDOWS
    CODE PRELOAD MOVEABLE DISCARDABLE
    DATA PRELOAD MOVEABLE MULTIPLE
    HEAPSIZE 32000
| iodll.def
!elif $(YACLPLATFORM) == WIN32
iodll.def:
    copy &&|
    LIBRARY io;dll
    EXETYPE WINDOWS
    CODE PRELOAD MOVEABLE DISCARDABLE
    DATA PRELOAD MOVEABLE MULTIPLE
    HEAPSIZE 32000
| iodll.def
!elif $(YACLPLATFORM) == OS2
iodll.def:
    copy &&|
    LIBRARY io INITINSTANCE
    DESCRIPTION 'YACL io library'
    PROTMODE
    DATA  NONSHARED
| iodll.def
!endif

            
# ------------------ Other targets ---------------------------




clean:
    -del *.obj
    -del *.cfg
    -del $(LIBRARYP).lib
    -del $(LIBRARYP).dll
    -del $(LIBRARYP).bak






