
!IFNDEF YACLPATH
!  ERROR Please define the environment variable YACLPATH.
!ENDIF

!INCLUDE $(YACLPATH)\control\ibmvacpp.ctl

FLAGS = /$(MAKEFLAGS) YACLPLATFORM=$(YACLPLATFORM)

!IFDEF DEBUG
FLAGS = $(FLAGS) DEBUG=1
!endif

yacl: libdir base io ui

libdir:
        -md $(YACLPATH)\lib > nul 2>&1
        -md $(YACLPATH)\lib\$(YACLPLATFORM) >nul 2>&1

base:
	cd base
	$(MAKE) /F ibmvacpp.mak $(FLAGS)
	-cd ..

io:
	cd io
	$(MAKE) /F ibmvacpp.mak $(FLAGS)
	-cd ..

ui:
	cd ui
	$(MAKE) /F ibmvacpp.mak $(FLAGS)
	-cd ..

# -------------------- Targets below are for my use only ---------------
   
basedemo:
	cd basedemo
	$(MAKE) /F ibmvacpp.mak $(FLAGS)
	-cd ..

uidemo:
        cd uidemo
	$(MAKE) /F ibmvacpp.mak $(FLAGS)
	-cd ..

all: yacl basedemo uidemo

apps:
    cd apps\bmpview
    $(MAKE) -f ibmvacpp.mak
    cd ..\dlged
    $(MAKE) -f ibmvacpp.mak
    cd ..\..
    
    
clean:
	cd base
	$(MAKE) /F ibmvacpp.mak clean
	cd ..\io
	$(MAKE) /F ibmvacpp.mak clean
	cd ..\ui
	$(MAKE) /F ibmvacpp.mak clean
	cd ..\basedemo
	$(MAKE) /F ibmvacpp.mak clean
	cd ..\uidemo
        $(MAKE) /F ibmvacpp.mak clean
        cd ..\lib\os2
        -$(DELETE) ibmtmplt\*.cpp > nul 2>&1
        -$(DELETE) ibmtmplt\*.obj > nul 2>&1
        -rmdir ibmtmplt > nul 2>&1
        cd ..\..
