

#
#  Makefile for building YACL GUI classes on a Unix machine with GNU C++
#


include $(YACLPATH)/control/gnuc.ctl


LIBS = libdir make_base make_io make_ui

.PHONY: libdir make_base make_io make_ui

yacl: banner libdir $(LIBS)



banner:
	-@echo " ***************************************************"
	-@echo " Building YACL for " $(YACLPLATFORM) " with " $(WIDGET_SET)
	-@echo " ***************************************************"

        
libdir:
	-mkdir $(YACLPATH)/lib
	-mkdir $(YACLPATH)/lib/$(YACLPLATFORM)





make_base:
	- cd base && make -f gnuc.mak && cd .. 


make_io:
	- cd io && make -f gnuc.mak && cd .. 


make_ui:
	- cd ui && make -f gnuc.mak && cd ..


make_basedemos:
	- cd basedemo && make -f gnuc.mak && cd ..


make_uidemos:
	- cd uidemo && make -f gnuc.mak && cd ..


everything: libdir make_base make_io make_ui make_basedemos make_uidemos


clean:  banner
	-rm -f base/*.o io/*.o ui/*.o lib/$(YACLPLATFORM)/*.{so,a}
	- cd uidemo && make -f gnuc.mak clean && cd ..
	- rm -f apps/*/*.o apps/dlged/dlged apps/bmpview/bmpview
        

        



ZIP = zip

zip:
	rm -f yacl_all.zip
	find . \! \( -perm -0111 -o -name '*.[ao]' -o -name '*.so' \) -print | \
	sort  | \
	$(ZIP) yacl_all.zip -@


dist:
	rm -f yacl.zip
	find . \! \( -perm -0111 -o -name '*.sav' -o -name '*.o' -o -name '*.a' \) -print | \
	egrep -v '/private/' | sort  | \
	$(ZIP) yacl.zip -@



uizip:
	rm -f yaclui.zip
	(find ./control ./ui ./uidemo \! \( -perm -0111 -o -name '*.o' \
        -o -name '*.a' \)  -print; ls ./makefile.* ./*.txt)| sort | \
	$(ZIP) yaclui.zip -@


