

include $(YACLPATH)/control/emxdebug.ctl


LIBS = base io ui


yacl: libdir $(LIBS)

everything: base io ui basedemo uidemos apps



libdir:
	-md $(YACLPATH)\lib
	-md $(YACLPATH)\lib\$(YACLPLATFORM)




.PHONY: base io ui uidemos

base:
	- cd base && make -f emxdebug.mak && cd .. 


io:
	- cd io && make -f emxdebug.mak && cd .. 


ui:
	- cd ui && make -f emxdebug.mak && cd .. 


uidemos:
	- cd uidemo && make -f emxdebug.mak && cd ..

apps:
	- cd apps/bmpview; make -f emxdebug.mak ; cd ../dlged
	- make -f emxdebug.mak; cd ../..
        

clean:
	-rm -f base/*.obj io/*.obj ui/*.obj
	-rm -f lib/$(YACLPLATFORM)/base.lib lib/$(YACLPLATFORM)/io.lib
	-rm -f lib/$(YACLPLATFORM)/ui.lib
	-rm -f apps/dlged/*.obj apps/dlged/*.exe
	-rm -f apps/bmpview/*.obj apps/bmpview/*.exe
#	-cd uidemo && make -f emxdebug.mak clean && cd ..
        

        



ZIP = zip

zip:
	rm -f yacl_all.zip
	find . \! \( -perm +u+x -o -name '*.o' -o -name '*.a' \) -print | \
	sort  | \
	$(ZIP) yacl_all.zip -@

changezip:
	rm -f changes.zip
	find . -newer watmak.ctl \! \( -perm +u+x \) -print | \
        egrep -v '\.[oa]' | sort  | \
	$(ZIP) changes.zip -@

uizip:
	rm -f yaclui.zip
	(find ./ui ./uidemo \! \( -perm +u+x -o -name '*.o' -o -name \
        '*.a' \)  -print; ls ./*.ctl ./makefile.* ./changlog ./*.txt)| sort | \
	$(ZIP) yaclui.zip -@


