# -------------------------------------------------------------------------
#                 Control file for IBM VAC++ 3.0 nmake                    |
#--------------------------------------------------------------------------

YACLPLATFORM = os2_ibmc

#
# ---------------------  Command names -------------------------
#

COPY    = copy
DELETE  = del
RENAME  = move
SED     = sed
FIND    = find
AWK     = gawk
LIBR    = ilib
LINK    = icc
CC      = icc
UNZIP   = unzip
ZIP     = zip
SH      = bash

#
# ---------------------- Path names ----------------------------
#

!IFDEF CPPMAIN
ICCPATH      = $(CPPMAIN)
!ELSE
ICCPATH      = f:\ibmcpp
!ENDIF

!IFNDEF YACLPATH
!  ERROR Please define the environment variable YACLPATH.
!ENDIF

# ------------- Should not need to change anything below this line --------

YACLLIB     = $(YACLPATH)\lib\$(YACLPLATFORM)
INCLUDE     = $(ICCPATH)\INCLUDE;$(ICCPATH)\INCLUDE\OS2;$(YACLPATH)
LIB         = $(ICCPATH)\LIB\;$(YACLLIB)

#
# ---------------------- YACL components --------------------
#

BASE      = base
MEMORY    = memory
IO        = io
UI        = ui

BASELIB   = $(YACLLIB)\$(BASE).lib
MEMORYLIB = $(YACLLIB)\$(MEMORY).lib
IOLIB     = $(YACLLIB)\$(IO).lib
UILIB     = $(YACLLIB)\$(UI).lib

#
#  ---------------------------- Compile options ------------------------
#

#  list of warning messages to include...

WARNING1 = /Wcnd /Wext /Wgot /Wini /Wobs /Wpar /Wpor
WARNINGS = $(WARNING1) /Wpro /Wrea /Wtru /Wund /Wuni /Wuse

#  template control file directory...
!IFNDEF TEMPLATE
# TEMPLATE = /Ft$(YACLPATH)\lib\os2\ibmtmplt
TEMPLATE = /Ft-
!ENDIF

!IFDEF DEBUG
DBGSWTCH  = /Ti /G3  /B"/DBGPACK"
OPTIMIZE  =
!ELSE
OPTIMIZE  = /O /Oi /G5 /Gl /B"/EXEPACK /PACKCODE /PACKDATA"
# OPTIMIZE  = /G5 /B"/EXEPACK /PACKCODE /PACKDATA"
DBGSWTCH  =
!ENDIF

BASEOPT = /Tdp /Q /I$(INCLUDE) $(DBGSWTCH) $(OPTIMIZE) $(TEMPLATE) /B"/NOE"
CCOPTS  = /C $(BASEOPT)  $(WARNINGS)
LNKOPTS = $(BASEOPT)
LIBOPTS = /Q /NOI 

LNKLIB      = $(UILIB) $(IOLIB) $(BASELIB) $(MEMORYLIB)
BASELNKLIB  = $(IOLIB) $(BASELIB) $(MEMORYLIB)

#  ---------------------------- Compile command ------------------------

.cxx.obj:
    $(CC) $(CCOPTS) $?
 


