
#
# ---------------- Control file for YACL make under GNU C++ -------------
#

# Define the widget set you want to compile YACL for:
# WIDGET_SET = x_yacl
WIDGET_SET = x_motif

# Include the symbol definition file for the platform on which you
# want to compile YACL:
include $(YACLPATH)/control/gnuc/linux.cfg
# include $(YACLPATH)/control/gnuc/sunos.cfg
# include $(YACLPATH)/control/gnuc/solaris.cfg
# include $(YACLPATH)/control/gnuc/sgi.cfg
# include $(YACLPATH)/control/gnuc/generic.cfg


#
# ----------------- Should not need to change anything below --------------
# 

include $(YACLPATH)/control/$(WIDGET_SET).def

#
# Derived path names
#
YACLLIB      = $(YACLPATH)/lib/$(YACLPLATFORM)
YACLINC      = -I$(YACLPATH)


# Component names:

BASE         = base
IO           = io
MEMORY       = memory
UI           = ui

BASELIB      = $(YACLLIB)/lib$(BASE).a
IOLIB        = $(YACLLIB)/lib$(IO).a
MEMORYLIB    = $(YACLLIB)/lib$(MEMORY).a
UILIB        = $(YACLLIB)/lib$(UI).a

# Processors

CC          = gcc -fno-implicit-templates
LINK        = gcc


# Processor options:

# DEBUG    = -g
# OPTIMIZE = -O1
# PROFILE  = -pg
INCPATH  = $(YACLINC) $(CPP_INC)    $(X11INC)    $(WIDGET_INC)
LIBPATH  = -L$(X11LIBPATH)  $(WIDGET_LIBPATH) -L$(YACLLIB)


CCOPTS      = $(PROFILE) $(OPTIMIZE) $(DEBUG) $(INCPATH) \
  -D$(WIDGET_SYMBOL) -c -D__UNIX__
LNKLIB      = -l$(UI) -l$(IO)   -l$(BASE)   -l$(CPLUSPLUSLIB) $(WIDGET_LIB) -lm
LNKOPTS     = $(DEBUG) $(LIBPATH) $(PROFILE) 
BASELNKLIB  = -l$(IO) -l$(BASE) -l$(MEMORY) -l$(CPLUSPLUSLIB) -lm

